(*

                     Inertia Singletime 3D Rendering Engine
     Copyright (c) 1996, Alex Chalfin, Jeroen Bouwens. All Rights Reserved.
           DISTRIBUTION OF THIS SOURCE CODE IS STRICTLY PROHIBITED

*)

Program GMV;
{ Gfxfx Mesh Viewer }
{$R-}
{$S-}

Uses
  Crt,     { Included for keyboard reading      }
  Mode13h, { A simple mode 13h graphics unit    }
  Dos,     { Included for file finding routines }
  Mouse,   { Mouse reading routines             }
  Types,   { Inertia data types                 }
  Inertia, { Inertia 3d engine                  }
  Font13h; { Cool 7x3 graphics font             }


Const
  DataSet : String = 'copprenv';

  MENUCOLOR  = 254;
  MENUCOLOR2 = 253;
  MENUTEXT   = 255;
  MAXFILES   = 256;
  F1 = #59; F2 = #60; F3 = #61; F4 = #62;
  F5 = #63; F6 = #64; F7 = #65; F8 = #66;
  F9 = #67; F10 = #68;
  HelpText : Array[0..16] of String = (
  'GFXFX Mesh Viewer/TMT  v1.00',
  ' ',
  'Keys while running:',
  ' F1 - Select UNSHADED shading',
  ' F2 - Select AMBIENT shading',
  ' F3 - Select LAMBERT shading',
  ' F4 - Select GOURAUD shading',
  ' F5 - Select PHONG shading',
  ' F6 - Select SMOOTH surface model',
  ' F7 - Select TEXTURE surface model',
  ' F8 - Select REFLECTION surface model',
  ' T  - Toggle object transparency',
  ' H  - Toggle help screen',
  ' S  - Object stats',
  ' P  - PCX Screen dump',
  ' ESC - Quit',
  '');

Type
  pString = ^String;
  tFileList = Array[0..MAXFILES-1] of pString;
  fVector3d = Record
    x, y, z : Single;
  End;

Var
  MemStart, MaxMem : Longint;
  OldExitProc : Pointer;
  MenuLocX1, MenuLocY1, MenuLocX2, MenuLocY2 : Longint;
  ScrollButton1X1, ScrollButton1Y1, ScrollButton1X2, ScrollButton1Y2,
  ScrollButton2X1, ScrollButton2Y1, ScrollButton2X2, ScrollButton2Y2 : Longint;
  TopSelect, BottomSelect : Longint;
  CurrentSelection : Longint;
  FileList : tFileList;
  NumFiles : Longint;
  NewSelection : Boolean;
  View : ViewObject;
  Obj : VectorObject;
  Surface : Longint;
  Shade : Longint;
  HighLight : Longint;
  Xaxis, Yaxis, Zaxis : FVector3d;

Procedure GetFileList;

Var
  DirInfo : SearchRec;
  i, j : Longint;
  temp : pString;

Begin
  NumFiles := 0;
  FindFirst('*.GVO', AnyFile, DirInfo);
  While (DOSError = 0) And (NumFiles < 256) do
    Begin
      New(FileList[NumFiles]);
      FileList[NumFiles]^ := DirInfo.Name;
      NumFiles := NumFiles + 1;
      FindNext(DirInfo);
    End;
  CurrentSelection := 0;
  TopSelect := 0;
  If (NumFiles > 9)
    Then BottomSelect := 9
    Else BottomSelect := (NumFiles - 1);

  { Sort the file entries }
  For i := 0 to (NumFiles - 1) do
    Begin
      For j := (NumFiles-2) downto i do
        Begin
          If (FileList[j]^ > FileList[j+1]^)
            Then Begin
              Temp := FileList[j];
              FileList[j] := FileList[j+1];
              FileList[j+1] := Temp;
            End;
        End;
    End;
End;


Procedure Zuit(S : String);

Begin
  SetMode($03);
  Writeln(S);
  Halt(0);
End;


Procedure Zuit03(S : String);

Begin
  SetMode($03);
  Writeln(S);
  Halt(0);
End;

Procedure Initialize;

Var
  x : Longint;

Begin
  If (InitMouse <> -1) Then Zuit('A mouse is required to run this program.');
  GetFileList;
  Writeln;
  If (NumFiles = 0) Then Zuit('There are no GVO files to view!');
  If LoadIntensityTable(DataSet + '.It', 0) <> 0 Then Zuit('Error Loading Intensity Table');
  If LoadTransparencyTable('Copprenv.tt', 0) <> 0 Then Zuit('Error Loading Transparency Table');
  If LoadPCXTexture(1, DataSet + '.PCX', 0) <> 0 Then Zuit('Error Loading Texture');
  If MakePhongMap(0) <> 0 Then Zuit('Error making phong buffer');

  InitView(View);

  For x := 0 to 15 do
    Writeln(HelpText[x]);

  Writeln;
  Writeln('Use your mouse to rotate an object. Right click to bring up the object');
  Writeln('selection menu.');
  Writeln;
  Writeln('Press any key to continue.');
  While Not(KeyPressed) do;
  While KeyPressed do ReadKey;
  GetTexturePalette(1);
  PushLightSource(0, 0, -1);
  Xaxis.x := 1; Xaxis.y := 0; Xaxis.z := 0;
  Yaxis.x := 0; Yaxis.y := 1; Yaxis.z := 0;
  Zaxis.x := 0; Zaxis.y := 0; Zaxis.z := 1;
End;

Procedure SolidRectangle(x1, y1, x2, y2 : Longint; Color : Byte);

Var
  vSeg, vOfs : Longint;

Begin
  vOfs := Longint(VirtualPage);
  Inc(vOfs, y1*320+x1);
  While (y1 < y2) do
    Begin
      FillChar(Mem[vOfs], x2-x1, Color);
      Inc(vOfs, 320);
      Inc(y1);
    End;
End;

Procedure RenderMenu(x, y, mx, my : Longint);

Const
  MenuWidth = 13*6;
  dMaxFiles = 10;

Var
  MenuHeight : Longint;
  dMenuHeight : Longint;
  x2, y2 : Longint;
  b1, b2 : Longint;
  i, Range : Longint;


Begin
  { figure out how many files to display }
  If (NumFiles < dMaxFiles)
    Then MenuHeight := NumFiles
    Else MenuHeight := dMaxFiles;

  dMenuHeight := MenuHeight * 8;

  { calculate the x and y parameters of the menu}
  If (x + MenuWidth) > 319 Then x := x - ((x + MenuWidth) - 319);
  If (y + dMenuHeight) > 199 Then y := y - ((y + dMenuHeight) - 199);
  MenuLocX1 := x;
  MenuLocY1 := y;
  MenuLocX2 := x + MenuWidth;
  MenuLocY2 := y + dMenuHeight+1;

  { draw the background menu image }
  SolidRectangle(MenuLocX1, MenuLocY1, MenuLocX2, MenuLocY2, MENUCOLOR);

  { draw the scrollbar }
  ScrollButton1X1 := MenuLocX1+2;
  ScrollButton1Y1 := MenuLocY1+2;
  ScrollButton1X2 := MenuLocX1+6;
  ScrollButton1Y2 := MenuLocY1+5;
  ScrollButton2X1 := MenuLocX1+2;
  ScrollButton2Y1 := MenuLocY2-5;
  ScrollButton2X2 := MenuLocX1+5;
  ScrollButton2Y2 := MenuLocY2+2;

  SolidRectangle(MenuLocX1+1, MenuLocY1+1, MenuLocX1+6, MenuLocY2-1, MENUCOLOR2);
  SolidRectangle(MenuLocX1+2, MenuLocY1+2, MenuLocX1+5, MenuLocY1+5, MENUCOLOR);
  SolidRectangle(MenuLocX1+2, MenuLocY2-5, MenuLocX1+5, MenuLocY2-2, MENUCOLOR);

  Range := (ScrollButton2Y1 - 1) - (ScrollButton1Y2 + 1);
  b1 := (ScrollButton1Y2 + 1) + Round(Range * (TopSelect / NumFiles));
  b2 := (ScrollButton1Y2 + 1) + Round(Range * ((BottomSelect+1) / NumFiles));
  SolidRectangle(MenuLocX1+2, b1, MenuLocX1+5, b2, MenuColor);

  { draw the text }
  For i := TopSelect to BottomSelect do
    Begin
      If ((mx > ScrollButton2X2) And
          (mx <= MenuLocX2)) And
         ((my >= (MenuLocY1+1+((i-TopSelect)*8))) And (my <= (MenuLocY1+1+((i-TopSelect)*8)+7)))
           Then Begin
             SolidRectangle(ScrollButton2X2+2, MenuLocY1+1+((i-TopSelect)*8-1),
                          MenuLocX2-1, MenuLocY1+1+((i-TopSelect)*8+7), MENUCOLOR2);
             HighLight := i;
             WriteString(MenuLocX1+8, MenuLocY1+1+((i-TopSelect)*8), FileList[i]^, MENUTEXT, VirtualPage);
           End
         Else Begin
           WriteString(MenuLocX1+8, MenuLocY1+1+((i-TopSelect)*8), FileList[i]^, MENUCOLOR2, VirtualPage);
           WriteString(MenuLocX1+9, MenuLocY1+2+((i-TopSelect)*8), FileList[i]^, MENUTEXT, VirtualPage);
         End;

    End;
End;

Procedure SelectAction(x, y : Longint);

Begin
  If (x >= ScrollButton1X2) And (x <= MenuLocX2) And
     (y >= MenuLocY1) And (y <= MenuLocY2)
     Then Begin
       CurrentSelection := highlight;
       NewSelection := True;
     End;

  If (x >= ScrollButton1X1) And (x <= ScrollButton1X2) And
     (y >= ScrollButton1Y1) And (y <= ScrollButton1Y2)
     Then Begin
       If TopSelect > 0
         Then Begin
           Dec(TopSelect);
           Dec(BottomSelect);
         End;
     End;

  If (x >= ScrollButton2X1) And (x <= ScrollButton2X2) And
     (y >= ScrollButton2Y1) And (y <= ScrollButton2Y2)
     Then Begin
       If BottomSelect < (NumFiles - 1)
         Then Begin
           Inc(TopSelect);
           Inc(BottomSelect);
         End;
     End;
  WaitBClear;
End;

Procedure DisplayHelp;

Var
  i : Longint;

Begin
  For i := 0 to 15 do
    WriteString(0, i*8, HelpText[i], MENUTEXT, VirtualPage);
End;


Procedure AxisRotate(Var v : fVector3d; A : Single; x, y, z : Single);

Var
  cosa, sina : Single;
  dot, dx, dy, dz : Single;
  rx, ry, rz : Single;
  cx, cy, cz : Single;

Begin
  cosa := cos(a);
  sina := sin(a);
  dot := (x * v.x + y * v.y + z * v.z);
  dx := dot * x * (1 - cosa);
  dy := dot * y * (1 - cosa);
  dz := dot * z * (1 - cosa);
  rx := v.x * cosa;
  ry := v.y * cosa;
  rz := v.z * cosa;
  cx := (y * v.z - z * v.y)*sina;
  cy := (z * v.x - x * v.z)*sina;
  cz := (x * v.y - y * v.x)*sina;

  v.x := rx + dx + cx;
  v.y := ry + dy + cy;
  v.z := rz + dz + cz;
End;

Procedure FixAxis;

Var
  dot1, dot2 : Single;
  len : Single;

Begin
  dot1 := xaxis.x * yaxis.x + xaxis.y * yaxis.y + xaxis.z * yaxis.z;
  dot2 := xaxis.x * zaxis.x + xaxis.y * zaxis.y + xaxis.z * zaxis.z;
  xaxis.x := xaxis.x - dot1 * yaxis.x;
  xaxis.y := xaxis.y - dot1 * yaxis.y;
  xaxis.z := xaxis.z - dot1 * yaxis.z;
  xaxis.x := xaxis.x - dot2 * zaxis.x;
  xaxis.y := xaxis.y - dot2 * zaxis.y;
  xaxis.z := xaxis.z - dot2 * zaxis.z;
  len := 1/sqrt(sqr(xaxis.x) + sqr(xaxis.y) + sqr(xaxis.z));
  xaxis.x := xaxis.x*len;
  xaxis.y := xaxis.y*len;
  xaxis.z := xaxis.z*len;

  dot1 := xaxis.x * yaxis.x + xaxis.y * yaxis.y + xaxis.z * yaxis.z;
  dot2 := yaxis.x * zaxis.x + yaxis.y * zaxis.y + yaxis.z * zaxis.z;
  yaxis.x := yaxis.x - dot1 * xaxis.x;
  yaxis.y := yaxis.y - dot1 * xaxis.y;
  yaxis.z := yaxis.z - dot1 * xaxis.z;
  yaxis.x := yaxis.x - dot2 * zaxis.x;
  yaxis.y := yaxis.y - dot2 * zaxis.y;
  yaxis.z := yaxis.z - dot2 * zaxis.z;
  len := 1/sqrt(sqr(yaxis.x) + sqr(yaxis.y) + sqr(yaxis.z));
  yaxis.x := yaxis.x*len;
  yaxis.y := yaxis.y*len;
  yaxis.z := yaxis.z*len;

  zaxis.x := xaxis.y*yaxis.z - xaxis.z*yaxis.y;
  zaxis.y := xaxis.z*yaxis.x - xaxis.x*yaxis.z;
  zaxis.z := xaxis.x*yaxis.y - xaxis.y*yaxis.x;
End;

Procedure SetObjectMatrix(x, y, z : Longint);

Var
  phi, theta : Single;

Begin
  phi := (x And 1023)*2*Pi/1024;
  theta := (y And 1023)*2*Pi/1024;
  AxisRotate(XAxis, theta, xaxis.x, xaxis.y, xaxis.z);
  AxisRotate(YAxis, theta, xaxis.x, xaxis.y, xaxis.z);
  AxisRotate(ZAxis, theta, xaxis.x, xaxis.y, xaxis.z);

  AxisRotate(XAxis, phi, yaxis.x, yaxis.y, yaxis.z);
  AxisRotate(YAxis, phi, yaxis.x, yaxis.y, yaxis.z);
  AxisRotate(ZAxis, phi, yaxis.x, yaxis.y, yaxis.z);

  phi := (z And 1023)*2*Pi/1024;
  AxisRotate(XAxis, phi, zaxis.x, zaxis.y, zaxis.z);
  AxisRotate(YAxis, phi, zaxis.x, zaxis.y, zaxis.z);
  AxisRotate(ZAxis, phi, zaxis.x, zaxis.y, zaxis.z);

  FixAxis;

  Obj.Orientation[0] := Xaxis.x;
  Obj.Orientation[3] := Xaxis.y;
  Obj.Orientation[6] := Xaxis.z;

  Obj.Orientation[1] := Yaxis.x;
  Obj.Orientation[4] := Yaxis.y;
  Obj.Orientation[7] := Yaxis.z;

  Obj.Orientation[2] := Zaxis.x;
  Obj.Orientation[5] := Zaxis.y;
  Obj.Orientation[8] := Zaxis.z;
End;

Procedure Action;

Var
  x, y, b : Longint;
  InMenu : Boolean;
  mLocx, mLocy : Longint;
  rotx, roty : Longint;
  dx, dy : Longint;
  retcode : Longint;
  ch : Char;
  Fini : Boolean;
  ViewHelp : Boolean;
  Trans : Longint;
  MemMessage : Boolean;
  ZLoc : Single;
  zscale : Single;
  stats : boolean;
  s1, s2, s3, s4, s5 : String;
  lastdraw : Longint;
  fps : Single;
  st, et, frame : Longint;
  i : Longint;

Begin
  SetMode($13);
  

{
  For i := 0 to 255 do
    SetRGB(i, GlobalPalette[i].r, GlobalPalette[i].g, GlobalPalette[i].b);
}

  SetPalette(GlobalPalette);
  SetRGB(MENUCOLOR, 45, 45, 45);
  SetRGB(MENUCOLOR2, 32, 32, 32);

  InMenu := False;
  NewSelection := False;
  InitVectorObject(Obj);
  dx := 0;
  dy := 0;
  Fini := False;
  Surface := SMOOTH;
  Shade := AMBIENT;
  ViewHelp := False;
  Trans := 0;
  MemMessage := False;
  stats := False;
  frame := 0;
  MaxMem := MemAvail;
  MemStart := MemAvail;
  Repeat
    If KeyPressed
      Then Begin
        frame := 0;
        ch := Readkey;
        If (ch = #0)
          Then Begin
            Case ReadKey of
              F1 :  Shade := UNSHADED;
              F2 :  Shade := Ambient;
              F3 :  Shade := Lambert;
              F4 :  Shade := Gouraud;
              F5 :  Shade := Phong;
              F6 :  Surface := Smooth;
              F7 :  Surface := Texture;
              F8 :  Surface := Reflection;
            End;
          End
          Else Begin
            Case UpCase(Ch) of
              #27 : Fini := True;
              'H' : ViewHelp := Not(ViewHelp);
              'T' : Trans := TRANSPARENT - Trans;
              'S' : Stats := Not(Stats);
            End;
          End;
        SetRenderMask(Obj, Trans or Surface or Shade);
        if (Trans = 0)
          Then SetCull(Obj, 1)
          Else SetCull(Obj, 0);
      End;

    AddtoRenderList(View, Obj);
    lastdraw := RenderList.Count;

    Render(View, VirtualPage, 320, 200);

    ReadMickey(rotx, roty);

    If Not(InMenu) And LeftButtonPressed
      Then Begin
        ZLoc := ZLoc + roty*zscale;
        SetAbsoluteLocation(Obj, 0, 0, ZLoc);
        SetObjectMatrix(0, 0, rotx);
      End
      Else Begin
        SetObjectMatrix(rotx, roty, 0);
        ReadMouse(x, y, b);
      End;

    If InMenu Then RenderMenu(mLocx, mLocy, x, y);
    If ViewHelp Then DisplayHelp;
    If (b = 2) Then Begin WaitBClear; InMenu := Not(InMenu); mLocx := x; mLocy := y; End;
    If (InMenu And (b = 1)) Then SelectAction(x, y);
    If NewSelection
      Then Begin
        { Load a new object }
        FreeVectorObject(Obj);
        MemMessage := False;
        InMenu := Not(InMenu);
        NewSelection := False;
        RetCode := LoadGVO(Obj, FileList[CurrentSelection]^, 0);
        If (RetCode <> 0)
          Then Begin
            If RetCode <> I_MEMERR
              Then Zuit03('Error loading GVO object! ' + FileList[CurrentSelection]^)
              Else MemMessage := True;
          End;
        SetBaseColor(Obj, 36);
        SetObjectTexture(Obj, 1);
        SetAbsoluteLocation(Obj, 0, 0, 2*Obj.Radius);

        ZLoc := 2*Obj.Radius;
        ZScale := Obj.Radius / 20;

        SetRenderMask(Obj, Trans or Surface or Shade);
        if (Trans = 0)
          Then SetCull(Obj, 1)
          Else SetCull(Obj, 0);
        frame := 0;
        SetObjectPhongMap(Obj, 0);
      End;

    If Stats
      Then Begin
        If (Trans <> 0) Then WriteString(95, 180, 'Transparent', MENUTEXT, VirtualPage);
        Case Shade of
          UNSHADED : WriteString(0, 180, 'Unshaded', MENUTEXT, VirtualPage);
          AMBIENT : WriteString(0, 180, 'Ambient', MENUTEXT, VirtualPage);
          Lambert : WriteString(0, 180, 'Lambert', MENUTEXT, VirtualPage);
          Gouraud : WriteString(0, 180, 'Gouraud', MENUTEXT, VirtualPage);
          Phong   : WriteString(0, 180, 'Phong', MENUTEXT, VirtualPage);
        End;

        Case Surface of
          SMOOTH     : WriteString(40, 180, 'Smooth', MENUTEXT, VirtualPage);
          TEXTURE    : WriteString(40, 180, 'Texture', MENUTEXT, VirtualPage);
          Reflection : WriteString(40, 180, 'Reflection', MENUTEXT, VirtualPage);
        End;

        if (et - st) = 0
          Then fps := 0
          Else fps := (frame * 18.2) / (et-st);
        Str(Obj.NumVert, s1);
        Str(Obj.NumPoly, s2);
        Str(lastdraw, s3);
        Str(MemStart-MaxMem, s4);
        s5 := 'N/A';
        WriteString(0, 190, 'Verts: '+s1+' Faces: '+s2+' Drawn: '+s3+
                            ' Mem: '+s4+' FPS: '+s5, MENUTEXT, VirtualPage);
      End;

    If MemMessage Then WriteString(0, 190, 'Not enough memory for object!', MENUTEXT, VirtualPage);

    PutMouseCursor(x-4, y-4);
    frame := frame + 1;

    Flip;

  Until Fini;
  SetMode($03);
End;


Begin
  SetAspectRatio(1.33333 / (320 / 200) );
  Initialize;
  Action;
  Writeln('This program was written using the Inertia realtime 3d rendering');
  Writeln('system, a subset of the GFXFX3 project.');
  Writeln;
  Writeln('Program code: Alex Chalfin');
  Writeln('Engine code:  Alex Chalfin, Jeroen Bouwens');
  Writeln('GFXFX3 team:  Jeroen Bouwens, Alex Chalfin, Bas van Gaalen, Sean Palmer');
  Writeln;
End.
