#include "jpg.h"
#include <malloc.h>
#include <string.h>
#include <stdio.h>

typedef unsigned int  uint;
typedef unsigned short ush;


/* Load JPG file and save it as bitmap */
void main()
{
	char *name = "test.jpg";
	FILE *fout;
	int i, j, linelen, walign, imgsz, dsize;
	unsigned char byte;

	memset(&jpeg_file_s,0,sizeof(jpeg_file_s));
	if(!(jpeg_file_s.file = fopen(name,"rb"))) return;

	jpeg_readmarkers();
	jpeg_file_s.data = (unsigned char*)malloc(jpeg_file_s.width * jpeg_file_s.height * 3);
    
	jpeg_decompress();     
	if(jpeg_file_s.num_components == 3) jpeg_ycbcr2rgb();
	fclose(jpeg_file_s.file);

	printf("file: %s\n", name);
	printf("width: %d\n", jpeg_file_s.width);
	printf("height: %d\n", jpeg_file_s.height);
	printf("bpp: %d\n", jpeg_file_s.num_components * 8);

	linelen = jpeg_file_s.width * jpeg_file_s.num_components;
	dsize = linelen * jpeg_file_s.height;
	walign  = (((jpeg_file_s.width * (jpeg_file_s.num_components * 8) + 31) & ~31)) / 8;
	imgsz = walign * jpeg_file_s.height;
	walign -= linelen;

	if(!(fout = fopen("out.bmp", "wb"))) return;

	// Write File Header
	fwrite("BM", 2, 1, fout);
	fwrite(&(i = 54), 4, 1, fout);
	fwrite(&(i = 0), 2, 1, fout);
	fwrite(&(i = 0), 2, 1, fout);
	fwrite(&(i = 54), 4, 1, fout);

	// Write Bitmap Header
	fwrite(&(i = 40), 4, 1, fout);
	fwrite(&jpeg_file_s.width, 4, 1, fout);
	fwrite(&jpeg_file_s.height, 4, 1, fout);
	fwrite(&(i = 1), 2, 1, fout);
	fwrite(&(i = jpeg_file_s.num_components * 8), 2, 1, fout);
	fwrite(&(i = 0), 4, 1, fout);
	fwrite(&imgsz, 4, 1, fout);
	fwrite(&(i = 0), 4, 1, fout);
	fwrite(&(i = 0), 4, 1, fout);
	fwrite(&(i = 0), 4, 1, fout);
	fwrite(&(i = 0), 4, 1, fout);

	if(jpeg_file_s.num_components == 1)
		for(j = 0; j < 256; j++) // write color table
		{
			fwrite(&j, 1, 1, fout);
			fwrite(&j, 1, 1, fout);
			fwrite(&j, 1, 1, fout);
			fwrite(&(i = 0), 1, 1, fout);
		}
	else
		for(j = 0; j < dsize; j += 3) // swap colors
		{
			byte = jpeg_file_s.data[j];
			jpeg_file_s.data[j] = jpeg_file_s.data[j+2];
			jpeg_file_s.data[j+2] = byte;
		}

	for(j = dsize - linelen; j >= 0; j -= linelen)
	{
		fwrite(jpeg_file_s.data + j, linelen, 1, fout);
		fwrite(&(i = 0), walign, 1, fout);
	}

	fclose(fout);
	free(jpeg_file_s.data);
}
