
(*
** Instrument Recognition Types-Declaration and sample unit
** Written by Bas van Gaalen in November/December '96.
*)

unit types;

interface

const
  slack=8;                                      { Skip first bytes in signal }
  fftsize=2048;                            { Size of FFT-window (power of 2) }
  samplesize=slack+fftsize;                          { Total size of signal  }
  samplefreq=22050;          { Samplefrequency (smaller for higher fft-res.) }
  maxfpr=500;  { Maximum number of frequency-values for fingerprint-checking }
  psize=80;                                              { Diagram/Plot size }

  recordvolume:byte=6;   { 0..7 }
  detectvolume:byte=6;   { 0..7 }
  detecttreshold:byte=4; { 0..15 }

type
  vartype=single;                                        { Type of variables }
  complex=record                                            { Complex number }
    re,im:vartype;
  end;
  datastruc=array[0..fftsize] of complex;               { The data-structure }
  magstruc=array[1..maxfpr] of byte;               { The magnitude-structure }
  sampletype=array[0..samplesize] of byte;                { The samplebuffer }

var
  sample:sampletype;

function detect:boolean;
procedure waitforend;
procedure sampler(var sbuf:sampletype);

{----------------------------------------------------------------------------}

implementation

uses
  crt,sbdsp;

function detect:boolean; { Returns true if sound was detected, key otherwise }
begin
  SetMicVolume(detectvolume);
  while (integer(readdac)-127<detecttreshold) and (not keypressed) do;
  detect:=keypressed;
end;

procedure waitforend;
const
  maxleave=50;
var
  val:integer;
  i:word;
  leave:boolean;
begin
  i:=0;
  leave:=false;
  repeat
    val:=abs(integer(readdac)-127);
    if val<=1 then inc(i) else i:=0;
    leave:=i>maxleave;
  until leave;
end;

procedure sampler(var sbuf:sampletype);
begin
  ResetMixer;
  SetMicVolume(recordvolume);
  RecordSoundRPD(samplefreq);
  while not haltrecord do;
  StopRecording;
  move(sample,sbuf,samplesize);
end;

procedure initsb;
begin
  ResetDSP(2,5,1,5);
  SetInputSource(NoFilter, Mic1Input);
end;

begin
  initsb;
end.
