
(*
** Testprogram to see of the frequency-independancy theory works
** Written by Bas van Gaalen in December, '96.
**
** Damned DC-component! Get rid of it - NOW!
*)

program test_frequency_independancy;

uses
  types;

const
  treshold=25;
  origspec='spr\synbr-c3.spr';             { Should be the highest frequency }
  checkspec='spr\synbr-c4.spr';                    { Some other frequency... }

type
  shortstr=string[10];
  commentstr=string[20];
  sprrec=record                                          { Soundprint record }
    name:commentstr;                                        { Instrumentname }
    print:magstruc;                        { Frequencyspectrum of instrument }
    idxmax:byte;              { Index of maximum amplitude (groundfrequency) }
  end;

var
  ospr,                                     { Original (comparence) spectrum }
  cspr,                                                     { Check spectrum }
  sspr:sprrec;                    { Scaled spectrum (should be same as ospr) }
  font:pointer;

{----------------------------------------------------------------------------}

function tostr(num:longint):shortstr;
var
  tmpstr:shortstr;
begin
  str(num,tmpstr);
  tostr:=tmpstr;
end;

{ Get pointer to systemfont -------------------------------------------------}

procedure getfont; assembler;
asm
  mov ax,1130h
  mov bh,3
  push bp
  int 10h
  mov font.word[2],es
  mov font.word[0],bp
  pop bp
end;

{ Draw a horizontal line from given coordinate to xe in color c -------------}

procedure hline(x,y,xe:word; c:byte); assembler;
asm
  cmp x,319
  ja @exit
  cmp xe,319
  jle @skiprange
  mov xe,319
 @skiprange:
  cmp y,199
  ja @exit
  mov es,sega000
  mov bx,x
  mov cx,xe
  cmp cx,bx
  jge @skip
  xchg cx,bx
 @skip:
  inc cx
  sub cx,bx
  mov ax,320
  mul y
  add ax,bx
  mov di,ax
  mov al,c
  rep stosb
 @exit:
end;

{ Draw a vertical line from given coordinate to ye in color c ---------------}

procedure vline(x,y,ye:word; c:byte); assembler;
asm
  cmp x,319
  ja @exit
  cmp y,199
  ja @exit
  cmp ye,199
  jle @skiprange
  mov ye,199
 @skiprange:
  mov es,sega000
  mov bx,y
  mov cx,ye
  cmp cx,bx
  jge @skip
  xchg cx,bx
 @skip:
  inc cx
  sub cx,bx
  mov ax,320
  mul bx
  add ax,x
  mov di,ax
  mov al,c
 @l1:
  mov es:[di],al
  add di,320
  loop @l1
 @exit:
end;

{ Draw a string in graphicsmode ---------------------------------------------}

procedure outtextxy(x,y:word; s:string; c:byte);
var len,i,j,k:byte;
begin
  len:=length(s);
  if len=0 then exit;
  for i:=0 to length(s)-1 do
    for j:=0 to 7 do
      for k:=0 to 7 do
        if ((mem[seg(font^):ofs(font^)+ord(s[i+1])*8+j] shl k) and 128)<>0 then
          mem[sega000:(y+j)*320+(i*8)+x+k]:=c;
end;

{----------------------------------------------------------------------------}

function loadspr(fname:string; var spr:sprrec):boolean;
var
  f:file;
  dummy:word;
begin
  loadspr:=false;
  assign(f,fname);
  {$i-} reset(f,1); {$i+}
  if ioresult<>0 then exit;
  blockread(f,spr,121,dummy);
  if dummy<>121 then exit;
  close(f);
  loadspr:=true; { Load successful }
end;

{----------------------------------------------------------------------------}

procedure findmax(var spr:sprrec);
var
  i,max,idx:word;
begin
  max:=0;
  for i:=0 to sizeof(magstruc)-1 do
    if spr.print[i]>max then begin
      max:=spr.print[i];
      idx:=i;
    end;
  spr.idxmax:=idx;
end;

{----------------------------------------------------------------------------}

procedure init;
begin
  { Load spectra }
  if not loadspr(origspec,ospr) then halt(1);
  if not loadspr(checkspec,cspr) then halt(2);
  { Find out maxs }
  findmax(ospr);
  findmax(cspr);
  asm mov ax,13h; int 10h; end;
  getfont;

end;

{----------------------------------------------------------------------------}

procedure displayspr(spr:sprrec; x,y:word);
var
  i:word;
  c,v,pv:byte;
begin
  pv:=0;
  for i:=0 to sizeof(magstruc)-1 do begin
    v:=spr.print[i];
    if (v>treshold) and (pv<treshold) then c:=15 else c:=8;
    if i=spr.idxmax then c:=4;
    vline(x+i,y+80-v,y+80,c);
    pv:=v;
  end;
  outtextxy(x+80,y+10,tostr(spr.idxmax),15);
  outtextxy(x,y+82,spr.name,15);
end;

{----------------------------------------------------------------------------}

procedure scalespr(src,ref:sprrec; var dst:sprrec);
var
  mulfac:real;
  i,v,pv,dstidx:word;
begin
  pv:=0;
  fillchar(dst,sizeof(dst),0);
  mulfac:=ref.idxmax/src.idxmax;
  for i:=0 to sizeof(magstruc)-1 do begin
    v:=src.print[i];
    if (v>treshold) and (pv<treshold) then begin
      dstidx:=round(i*mulfac);
      if dstidx<sizeof(magstruc) then
        dst.print[dstidx]:=v;
    end;
    pv:=v;
  end;
  dst.name:='Scaled!';
end;

{----------------------------------------------------------------------------}

procedure checkmatch(original,scaled:sprrec);
var
  i:word;
  occasion:byte;
  okay:boolean;
begin
  okay:=true;
  i:=0;
  occasion:=0;
  while (i<sizeof(magstruc)-1) and (occasion<3) and okay do begin
    if scaled.print[i]>0 then begin
      okay:=(original.print[i-1]>treshold) or
            (original.print[i]>treshold) or
            (original.print[i+1]>treshold);
      if okay then inc(occasion);
    end;
    inc(i);
  end;
  if okay then outtextxy(10,10,'Match!',15)
  else outtextxy(10,10,'No match...',8);
end;

{----------------------------------------------------------------------------}

begin
  init;
  displayspr(ospr,180,0);
  displayspr(cspr,10,100);
  outtextxy(140,140,'->',15);
  scalespr(cspr,ospr,sspr);
  findmax(sspr);
  displayspr(sspr,180,100);
  checkmatch(ospr,sspr);
  readln;
  asm mov ax,3; int 10h; end;
end.
