
(*
** Show signal saved with SR
** Written by Bas van Gaalen, November '96.
*)

program show_signal;

uses
  crt,gui,svga,types,_fft,u_kb; { 'types' and '_fft' for structures only! }

const
  bgipath='i:\bgi';

type
  shortstr=string[10];

var
  swidth:word;

{----------------------------------------------------------------------------}

function tostr(num:longint; fld:byte):shortstr;
var
  tmp:shortstr;
begin
  str(num:fld,tmp);
  tostr:=tmp;
end;

{----------------------------------------------------------------------------}

procedure readsignal(var m:magstruc);
var
  f:file;
  err:integer;
begin
  assign(f,'signal.dat');
  {$i-} reset(f,1); {$i+}
  err:=ioresult;
  if err<>0 then begin
    writeln('Error opening file...'); halt(err); end;
  blockread(f,m,sizeof(m));
  close(f);
end;

{----------------------------------------------------------------------------}

procedure init;
begin
  swidth:=sizeof(magstruc);
  { Detect GUI-errorcodes }
  if GUI_Error<>GUI_Err_Okay then halt(GUI_Error);
end;

{----------------------------------------------------------------------------}

procedure displaysignals(m:magstruc);
const
  grid=10;
  axis=300;
  range=80;
var
  i:word;
begin
  { Draw grid }
  i:=axis-range;
  while i<axis do begin
    horline(0,i,swidth,darkgray);
    inc(i,grid);
  end;
  i:=0;
  while i<=swidth do begin
    verline(i,axis-range,axis,darkgray);
    inc(i,grid);
  end;

  { Draw frequency-signal }
  for i:=0 to swidth-1 do
    verline(i,300-m[i],300,white);
end;

{----------------------------------------------------------------------------}

procedure walksignal(m:magstruc);
var
  cx,px,key:word;
  leave:boolean;
begin
  drawstr(10,10,'x:',white,mainfont);
  drawstr(10,30,'y:',white,mainfont);
  cx:=0; px:=cx;
  leave:=false;
  repeat
    fbox(30,10,54,22,0);
    drawstr(30,10,tostr(cx,3),white,mainfont);
    fbox(30,30,54,42,0);
    drawstr(30,30,tostr(m[cx],3),white,mainfont);
    verline(px,301,303,0);
    verline(cx,301,303,15);
    key:=getekey;
    px:=cx;
    case key of
      crsrleft:if cx>0 then dec(cx);
      crsrright:if cx<swidth then inc(cx);
      crsrcleft:if cx>10 then dec(cx,10);
      crsrcright:if cx<swidth-10 then inc(cx,10);
      crsresc:leave:=true;
    end;
  until leave;
end;

{----------------------------------------------------------------------------}

var
  mag:magstruc;

begin
  init;
  readsignal(mag);
  displaysignals(mag);
  walksignal(mag);
end.
