
(*
** Instrument Recognition Types-Declaration unit
**
*)

unit types;

interface

const
  slack=8{1024}{3072};
  fftsize=1024;
  samplesize=slack+fftsize;
  samplefreq=44100;

  recordvolume:byte=6;   { 0..7 }
  detectvolume:byte=6;   { 0..7 }
  detecttreshold:byte=4; { 0..15 }

type
  sampletype=array[0..samplesize] of byte;

var
  sample:sampletype;

function detectinput:boolean;
procedure waitforend;
procedure sampler(var sbuf:sampletype);

{----------------------------------------------------------------------------}

implementation

uses
  crt,sbdsp;

function detectinput:boolean; { Returns true if sound was detected, key otherwise }
begin
  SetMicVolume(detectvolume);
  while (integer(readdac)-127<detecttreshold) and (not keypressed) do;
  detectinput:=keypressed;
end;

procedure waitforend;
const
  maxleave=50;
var
  val:integer;
  i:word;
  leave:boolean;
begin
  i:=0;
  leave:=false;
  repeat
    val:=abs(integer(readdac)-127);
    if val<=1 then inc(i) else i:=0;
    leave:=i>maxleave;
  until leave;
end;

procedure sampler(var sbuf:sampletype);
begin
  ResetMixer;
  SetMicVolume(recordvolume);
  RecordSoundRPD(samplefreq);
  while not haltrecord do;
  StopRecording;
  move(sample,sbuf,samplesize);
{  waitforend;}
end;

procedure initsb;
begin
  ResetDSP(2,5,1,5);
  SetInputSource(NoFilter, Mic1Input);
end;

begin
  initsb;
end.
