{       SMIX is Copyright 1995 by Ethan Brodsky.  All rights reserved.       }
{$R-} {$Q-} {$S-} {Speed it up a bit}
program Wav2Raw;
  const
    BlockSize = 32000;
  var
    InFile, OutFile: file;
    Header: array[1..44] of byte;
    InData:  array[0..BlockSize] of byte;
    OutData: array[0..BlockSize] of ShortInt;
    BytesRead: word;
    i: word;
  begin
    if ParamCount <> 1
      then
        begin
          writeln('SYNTAX:');
          writeln('  WAV2RAW filename');
          writeln('Will convert filename.wav to filename.raw');
          writeln('Must be an 8-bit WAV sampled at 22050 HZ');
          Halt(255);
        end;
    Assign(InFile,  ParamStr(1) + '.WAV');  Reset(InFile,    1);
    Assign(OutFile, ParamStr(1) + '.RAW');  ReWrite(OutFile, 1);

    BlockRead(InFile, Header, SizeOf(Header));
    repeat
      BlockRead(InFile, InData, BlockSize, BytesRead);
      for i := 1 to BytesRead do
        OutData[i] := InData[i] - $80;
      BlockWrite(OutFile, OutData, BytesRead);
    until BytesRead = 0;

    Close(InFile);  Close(OutFile);
  end.