/*
 *      Archivers.h
 *
 * MIDAS Module Player for Windows NT archiver support
 *
 * Copyright 1996 Petteri Kangaslampi
*/

#ifndef __ARCHIVERS_H
#define __ARCHIVERS_H



typedef struct
{
    char        *extension;
    char        *decompress;
} Archive;


extern int      numArchives;
extern Archive  archives[];




/****************************************************************************\
*
* Function:     int IsArchive(char *fileName);
*
* Description:  Checks if a file is an archive (based on the extension)
*
* Input:        char *fileName          file name
*
* Returns:      1 if the file is an archive, 0 if not
*
\****************************************************************************/

int IsArchive(char *fileName);




/****************************************************************************\
*
* Function:     void Decompress(char *fileName, char *destFileName);
*
* Description:  Decompresses a music archive
*
* Input:        char *fileName          file name
*               char *destFileName      pointer to decompression destination
*                                       file name buffer
*
* Returns:      Decompressed file name.
*
\****************************************************************************/

void Decompress(char *fileName, char *destFileName);



#endif