/*********************************************************************************************************
*
*	TGA2MSK.cpp
*
*	Source code for the utility to create .MSK (Mask) files from .TGA (Targa) files
*
*	Author: Saxon Druce
*
*	Copyright + 1997-2000
*
*	Use of this source code is subject to acceptance of the conditions of the
*	license in the accompanying documentation.
*
**********************************************************************************************************/

/*********************************************************************************************************/
// Include files
/*********************************************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "JXP.h"

/*********************************************************************************************************/
// Defines
/*********************************************************************************************************/

/*********************************************************************************************************/
// Local typedefs
/*********************************************************************************************************/

/*********************************************************************************************************/
// Static function prototypes
/*********************************************************************************************************/

/*********************************************************************************************************/
// Global variables
/*********************************************************************************************************/

/*********************************************************************************************************/
// Static variables
/*********************************************************************************************************/

/*********************************************************************************************************/
// Functions
/*********************************************************************************************************/

/*********************************************************************************************************
*
*	function:	main()
*
*	desc:		Programme entry point
*
*	notes:
*
**********************************************************************************************************/

void main(int Numargs, char *Args[])
{
	char SourceFilename[_MAX_PATH],DestinationFilename[_MAX_PATH];
	JXP_Image_24b *Image;
	JXP_TargaType Type;
	char Drive[_MAX_DRIVE];
	char Dir[_MAX_DIR];
	char Fname[_MAX_FNAME];
	char Ext[_MAX_EXT];

	printf("\nTGA2MSK 2.0 - TGA to MaSK converter\n");
	printf("Copyright (C) 1997-2000, Saxon Druce (Penfold/JiNX)\n");

	if (Numargs==1 || Numargs>3)
	{
		printf("\nIncorrect number of arguments. Syntax:\n\n");
		printf("TGA2MSK source[.tga] [dest[.msk]]\n\n");
		printf("   source[.tga]      source indexed-colour b/w tga\n");
		printf("   dest[.msk]        destination mask file\n\n");
		printf("dest[.msk] is source.msk by default if not supplied\n");
		exit(1);
	}

	printf("\n");

	// Set up source filename
	_splitpath(Args[1],Drive,Dir,Fname,Ext);
	if (!*Ext)
		strcpy(Ext,".tga");
	_makepath(SourceFilename,Drive,Dir,Fname,Ext);

	// Set up destination filename
	if (Numargs==3)
	{
		_splitpath(Args[2],Drive,Dir,Fname,Ext);
		if (!*Ext)
			strcpy(Ext,".msk");
		_makepath(DestinationFilename,Drive,Dir,Fname,Ext);
	}
	else
	{
		_splitpath(Args[1],Drive,Dir,Fname,Ext);
		_makepath(DestinationFilename,Drive,Dir,Fname,".msk");
	}

	printf("Reading TGA - '%s'\n",SourceFilename);

	// Get the type of the source file
	if (JXP_GetTargaFileFormat(SourceFilename,&Type)!=JXP_SUCCESS)
	{
		printf("JXP Error in JXP_GetTargaFileFormat(): %s \n",JXP_Utils.ErrorDescription(JXP_Utils.GetLastError()));
		exit(1);
	}

	// Read in the source file
	switch (Type)
	{
		case JXP_TGA_INDEXED:
			{
				printf("  Indexed colour format\n");

				// Read in the TGA
				JXP_Image_8b *Image8b;
				if (JXP_Read8bTargaFile(SourceFilename,&Image8b)!=JXP_SUCCESS)
				{
					printf("JXP Error in JXP_Read8bTargaFile(): %s \n",JXP_Utils.ErrorDescription(JXP_Utils.GetLastError()));
					exit(1);
				}

				// Create 24bit TGA from the 8bit one
				Image=new JXP_Image_24b(Image8b);
				delete Image8b;
			}
			break;

		case JXP_TGA_RGB:
			{
				printf("  True colour format\n");

				// Read in the TGA
				if (JXP_Read24bTargaFile(SourceFilename,&Image)!=JXP_SUCCESS)
				{
					printf("JXP Error in JXP_Read24bTargaFile(): %s \n",JXP_Utils.ErrorDescription(JXP_Utils.GetLastError()));
					exit(1);
				}
			}
			break;

		case JXP_TGA_UNSUPPORTED:
			printf("  Unsupported format\n");
			exit(1);
			break;
	}

	printf("Writing MSK file - '%s'\n",DestinationFilename);

	// Generate a mask file from the 24bit image
	JXP_Data *Mask;
	if (JXP_GenerateMask(Image,&Mask)!=JXP_SUCCESS)
	{
		printf("JXP Error in JXP_GenerateMask(): %s \n",JXP_Utils.ErrorDescription(JXP_Utils.GetLastError()));
		exit(1);
	}

	delete Image;

	// Write to .msk file
	FILE *Fptr;
	Fptr=fopen(DestinationFilename,"wb");
	if (!Fptr)
	{
		printf("Error opening output file '%s' for writing\n",DestinationFilename);
		exit(1);
	}
	Mask->WriteToFile(Fptr);
	fclose(Fptr);

	delete Mask;

	printf("Done.\n");
}

/*********************************************************************************************************/
