/*********************************************************************************************************
*
*	JXP_Targa.h
*
*	Some basic functions to handle Targa images
*
*	Author: Saxon Druce
*
*	Copyright + 1997-2000
*
*	Use of this source code is subject to acceptance of the conditions of the
*	license in the accompanying documentation.
*
**********************************************************************************************************/

// Revision history:
// ----------------

// v2.01 - 22/1/2000
// No changes to this file in this version.
//
// v2.0 - 4/1/2000
// First version to include Targa loading convenience functions.

#ifndef __JXP_TARGA_H
#define __JXP_TARGA_H

/*********************************************************************************************************/
// Include files
/*********************************************************************************************************/

#include "JXP.h"

/*********************************************************************************************************/
// Defines
/*********************************************************************************************************/

/*********************************************************************************************************/
// Global typedefs
/*********************************************************************************************************/

// JXP_Targa_Interface - interface class which handles Targa files
class JXP_Targa_Interface
{
public:

	// GetTargaFormat() - gets the type of the file in 'Source'
	int JXP_API_CALL GetTargaFormat(JXP_Data *Source, JXP_TargaType *Format);

	// GetTargaFileFormat() - gets the type of the file 'Filename'
	int JXP_API_CALL GetTargaFileFormat(char *Filename, JXP_TargaType *Format);

	// Read24bTarga() - reads in a 24bit RGB TGA
	int JXP_API_CALL Read24bTarga(JXP_Data *Source, JXP_Image_24b **Destination);

	// Read8bTarga() - reads in an 8bit RGB TGA
	int JXP_API_CALL Read8bTarga(JXP_Data *Source, JXP_Image_8b **Destination);
};

/*********************************************************************************************************/
// Global function prototypes
/*********************************************************************************************************/

/*********************************************************************************************************/
// Global variables
/*********************************************************************************************************/

/*********************************************************************************************************/

#endif // __JXP_TARGA_H
