/*********************************************************************************************************
*
*	JXP_Resample.h
*
*	Some functions to perform resampling
*
*	Author: Saxon Druce
*
*	Copyright + 1997-2000
*
*	Use of this source code is subject to acceptance of the conditions of the
*	license in the accompanying documentation.
*
**********************************************************************************************************/

// Revision history:
// ----------------

// v2.01 - 22/1/2000
// Fixed a bug with reading outside the source image in the bilinear filter.
//
// v2.0 - 4/1/2000
// First version to include resampling functions.

#ifndef __JXP_RESAMPLE_H
#define __JXP_RESAMPLE_H

/*********************************************************************************************************/
// Include files
/*********************************************************************************************************/

#include "JXP.h"

/*********************************************************************************************************/
// Defines
/*********************************************************************************************************/

/*********************************************************************************************************/
// Global typedefs
/*********************************************************************************************************/

// JXP_Resample_Interface - interface class which handles image resampling
class JXP_Resample_Interface
{
public:

	// ResampleImage() - resamples an image
	int JXP_API_CALL ResampleImage(JXP_Image_24b *Source, int Width, int Height, JXP_Image_24b **Destination, JXP_ResampleType ResampleType);
};

/*********************************************************************************************************/
// Global function prototypes
/*********************************************************************************************************/

/*********************************************************************************************************/
// Global variables
/*********************************************************************************************************/

/*********************************************************************************************************/

#endif // __JXP_RESAMPLE_H
