/*********************************************************************************************************
*
*	JXP_Mask.h
*
*	Functions for handling of .MSK Mask files
*
*	Author: Saxon Druce
*
*	Copyright + 1997-2000
*
*	Use of this source code is subject to acceptance of the conditions of the
*	license in the accompanying documentation.
*
**********************************************************************************************************/

// A mask file is a run length encoded black and white image,
// which can be useful for certain applications.

// Revision history:
// ----------------

// v2.01 - 22/1/2000
// No changes to this file in this version.
//
// v2.0 - 4/1/2000
// Major rewrite, including conversion to C++. Added library function to
// generate mask files, not just read them.
//
// v1.21 - 3/1/1998
// No changes to this file in this version.
//
// v1.2 - 2/1/1998
// Initial inclusion of mask file support.

#ifndef __JXP_MASK_H
#define __JXP_MASK_H

/*********************************************************************************************************/
// Include files
/*********************************************************************************************************/

#include "JXP.h"

/*********************************************************************************************************/
// Defines
/*********************************************************************************************************/

/*********************************************************************************************************/
// Global typedefs
/*********************************************************************************************************/

// JXP_Mask_Interface - interface class which handles mask files
class JXP_Mask_Interface
{
public:

	// GenerateMask() - generates a mask file from the source image
	int JXP_API_CALL GenerateMask(JXP_Image_24b *Source, JXP_Data **Destination);

	// ReadMask() - reads a mask file
	int JXP_API_CALL ReadMask(JXP_Data *Source, JXP_Image_GreyScale **Destination);
};

/*********************************************************************************************************/
// Global function prototypes
/*********************************************************************************************************/

/*********************************************************************************************************/
// Global variables
/*********************************************************************************************************/

/*********************************************************************************************************/

#endif // __JXP_MASK_H
