/*****************************************************************************

JiNX Network System (JNet) - IPX Network Driver - By Mark Hodson, 1998-99

                                Demo Programme

*****************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <ctype.h>
#include <string.h>

#include "JNet.h"

#define PACKET_HANDLERS 32
#define PACKETS_TO_RECEIVE (PACKET_HANDLERS/2)

#define REGISTRY_ENTRIES 26

// Define a packet structure which is 546 bytes or less //

typedef struct {

    int sequence;
    char data[512];

} xfer_packet;

// Main programme //

void main(void)
{
    int result, i, j, input;

    char data[] = "JiNX Network System (JNet) - By Mark Hodson\n";

    char *address;

    IPX_Socket socket;
    IPX_Packet *packet;

    // Initialise IPX Registry

    result = JNet_IPX_InitialiseRegistry(REGISTRY_ENTRIES);

    if (result)
    {
        printf("IPX Registry Returned Error Code %0d\n", result);
        exit(1);
    }

    // Initialise IPX Driver

    printf("\nJNet IPX Test Programme - By Mark Hodson 1998-99\n");
    printf(" - JNet IPX Internal Packet Size is %0d bytes\n\n", sizeof(IPX_Packet));

    result = JNet_IPX_Initialise(PACKET_HANDLERS);

    if (result)
    {
        printf("IPX Initialise Returned Error Code %0d\n", result);
        exit(1);
    }

    printf("IPX Driver Information:\n\n");

    printf("IPX Maximum Packet Size = %0d\n", IPX_MaximumPacketSize);
    printf("IPX Retry Count         = %0d\n\n", IPX_RetryCount);

    printf("Local IPX Network Address = ");
    for (i=0; i<4; i++) printf("%02X", IPX_NetworkAddress[i]); printf(":");
    for (i=4; i<10; i++) printf("%02X", IPX_NetworkAddress[i]); printf("\n\n");

    // Open a Socket

    result = JNet_IPX_OpenSocket(0x8123); socket = IPX_LastSocketOpened;

    if (result)
    {
        printf("IPX Open Socket Returned Error Code %0d\n", result);
        exit(1);
    }

    // Prepare to Receive a Number of Packets

    for (i=0; i<PACKETS_TO_RECEIVE; i++)
    {
        result = JNet_IPX_ReceivePacket(socket);

        if (result)
        {
            printf("IPX Receive Packet Returned Error Code %0d\n", result);
            exit(1);
        }
    }

    // Main Loop

    printf("Keys: <B>roadcast a packet to all users.\n");
    printf("      <S>end a packet to a specific user.\n");
    printf("      <ESC>ape!\n\n");

    do
    {
        // Check for new input from keyboard

        if (kbhit())
        {
            input = getch();
        }
        else
        {
            input = 0;
        }

        // Act on input from keyboard

        if (input == 'B' || input == 'b')
        {
            // Broadcast data string including terminating NULL at end of string

            result = JNet_IPX_BroadcastPacket(socket, socket, data, strlen(data) + 1);

            if (result)
            {
                printf("IPX Broadcast Packet Returned Error Code %0d\n", result);
                exit(1);
            }

            printf("Broadcast a Packet on Socket 0x%04X\n\n", socket);
        }

        if (input == 'S' || input == 's')
        {
            // Send data string including terminating NULL at end of string to particular user

            if (JNet_IPX_HowManyAddresses() == 0)
            {
                printf("There are no registered IPX users yet!\n\n");
            }
            else
            {
                // Print out all currently registered network addresses

                printf("Choose destination from the IPX registry:\n");

                for (i=0; i<JNet_IPX_HowManyAddresses(); i++)
                {
                    address = JNet_IPX_ReturnAddress(i);

                    printf("%c. ", 'A' + i);

                    for (j=0; j<4; j++) printf("%02X", address[j]); printf(":");
                    for (j=4; j<10; j++) printf("%02X", address[j]); printf("\n");
                }

                // Get the user to choose one

                i = toupper(getch()) - 'A';

                if (i>=0 && i<JNet_IPX_HowManyAddresses())
                {
                    result = JNet_IPX_SendPacket(socket, JNet_IPX_ReturnAddress(i), socket, data, strlen(data) + 1);

                    if (result)
                    {
                        printf("IPX Send Packet Returned Error Code %0d\n", result);
                        exit(1);
                    }

                    printf("Sent a Packet on Socket 0x%04X\n\n", socket);
                }
                else
                {
                    printf("Send Packet Aborted\n\n");
                }
            }
        }

        // Check for completion status of any active packets

        result = JNet_IPX_CheckStatus();

        if (result)
        {
            printf("Packet Interrogation [%0d].  %0d Handlers Free, %0d Receiving, %0d Sending\n", result,
                   JNet_IPX_HowManySpare(), JNet_IPX_HowManyReceiving(), JNet_IPX_HowManySending());

            packet = IPX_LastPacketReported;

            printf("  Packet Checksum    : %04X\n", packet->packet_checksum);
            printf("  Packet Length      : %04X\n", packet->packet_length);
            printf("  Transport Control  : %02X\n", packet->transport_control);
            printf("  Packet Type        : %02X\n", packet->packet_type);

            printf("  Packet Destination : ");
            for (i=0; i<4; i++) printf("%02X", packet->destination_address[i]); printf(":");
            for (i=4; i<10; i++) printf("%02X", packet->destination_address[i]); printf(":");
            printf("%04X\n", packet->destination_socket);
        
            printf("  Packet Source      : ");
            for (i=0; i<4; i++) printf("%02X", packet->source_address[i]); printf(":");
            for (i=4; i<10; i++) printf("%02X", packet->source_address[i]); printf(":");
            printf("%04X\n", packet->source_socket);

            printf("  Packet Data        : %s\n", packet->packet_data);

            // If we used up a receiver then...

            if (result >= 0x10 && result <= 0x1F)
            {
                // Replenish receiver supplies

                result = JNet_IPX_ReceivePacket(socket);

                if (result)
                {
                    printf("IPX Receive Packet Returned Error Code %0d\n", result);
                    exit(1);
                }

                // Add source address of packet to address registry (unless already there)

                if (!JNet_IPX_CheckAddress(packet->source_address))
                {
                    JNet_IPX_RegisterAddress(packet->source_address);
                }
            }
        }
    }
    while (input != 27);

    // Close the Socket

    result = JNet_IPX_CloseSocket(socket);

    if (result)
    {
        printf("IPX Close Socket Returned Error Code %0d\n", result);
        exit(1);
    }
}



