// (c) 1994-1997 Niklas Beisert, this file is part of "Indoor Music System".
// you must not read, modify, print, compile or copy this file or parts of
// it unless you have accepted the license in the accompanying file IMS.TXT.

#include <ctype.h>
#include <conio.h>
#include <string.h>
#include <stdlib.h>
#include "binfile.h"

#include "mcp.h"
#include "gmdplay.h"
#include "err.h"

/*
static short vibsintab[256]=
 {    0,    50,   100,   151,   201,   251,   301,   350,
    400,   449,   498,   546,   595,   642,   690,   737,
    784,   830,   876,   921,   965,  1009,  1053,  1096,
   1138,  1179,  1220,  1260,  1299,  1338,  1375,  1412,
   1448,  1483,  1517,  1551,  1583,  1615,  1645,  1674,
   1703,  1730,  1757,  1782,  1806,  1829,  1851,  1872,
   1892,  1911,  1928,  1945,  1960,  1974,  1987,  1998,
   2009,  2018,  2026,  2033,  2038,  2042,  2046,  2047,
   2048,  2047,  2046,  2042,  2038,  2033,  2026,  2018,
   2009,  1998,  1987,  1974,  1960,  1945,  1928,  1911,
   1892,  1872,  1851,  1829,  1806,  1782,  1757,  1730,
   1703,  1674,  1645,  1615,  1583,  1551,  1517,  1483,
   1448,  1412,  1375,  1338,  1299,  1260,  1220,  1179,
   1138,  1096,  1053,  1009,   965,   921,   876,   830,
    784,   737,   690,   642,   595,   546,   498,   449,
    400,   350,   301,   251,   201,   151,   100,    50,
      0,   -50,  -100,  -151,  -201,  -251,  -301,  -350,
   -400,  -449,  -498,  -546,  -595,  -642,  -690,  -737,
   -784,  -830,  -876,  -921,  -965, -1009, -1053, -1096,
  -1138, -1179, -1220, -1260, -1299, -1338, -1375, -1412,
  -1448, -1483, -1517, -1551, -1583, -1615, -1645, -1674,
  -1703, -1730, -1757, -1782, -1806, -1829, -1851, -1872,
  -1892, -1911, -1928, -1945, -1960, -1974, -1987, -1998,
  -2009, -2018, -2026, -2033, -2038, -2042, -2046, -2047,
  -2048, -2047, -2046, -2042, -2038, -2033, -2026, -2018,
  -2009, -1998, -1987, -1974, -1960, -1945, -1928, -1911,
  -1892, -1872, -1851, -1829, -1806, -1782, -1757, -1730,
  -1703, -1674, -1645, -1615, -1583, -1551, -1517, -1483,
  -1448, -1412, -1375, -1338, -1299, -1260, -1220, -1179,
  -1138, -1096, -1053, -1009,  -965,  -921,  -876,  -830,
   -784,  -737,  -690,  -642,  -595,  -546,  -498,  -449,
   -400,  -350,  -301,  -251,  -201,  -151,  -100,   -50};
*/

static inline void putcmd(unsigned char *&p, unsigned char c, unsigned char d)
{
  *p++=c;
  *p++=d;
}

extern "C" int mpLoadIT(gmdmodule &m, binfile &file)
{
  cputs(".IT loader is not at all perfect!\r\n");
  cputs("bugreports on known bugs will be ignored\r\n");

  int i,j,k;
  mpReset(m);

  struct
  {
    unsigned long sig;
    unsigned char name[26];
    unsigned short _d1;
    unsigned short nords;
    unsigned short nins;
    unsigned short nsmps;
    unsigned short npats;
    unsigned short cwtv;
    unsigned short cmwt;
    unsigned short flags;
    unsigned short special;
    unsigned char gvol;
    unsigned char mvol;
    unsigned char ispd;
    unsigned char itmp;
    unsigned char chsep;
    unsigned char _d2;
    unsigned short msglen;
    unsigned long msgoff;
    unsigned long _d3;
    unsigned char pan[64];
    unsigned char vol[64];
  } hdr;

  file.read(&hdr, sizeof(hdr));
  if (hdr.sig!=0x4D504D49)
    return errFormSig;

  if ((hdr.flags&4)&&(hdr.cmwt<0x200))
    return errFormOldVer;

  int signedsamp=0;
  if (hdr.cmwt<0x202)
    signedsamp=1;

  unsigned char orders[256];
  unsigned long sampoff[100];
  unsigned long insoff[100];
  unsigned long patoff[200];

  file.read(orders, hdr.nords);
  file.read(insoff, hdr.nins*4);
  file.read(sampoff, hdr.nsmps*4);
  file.read(patoff, hdr.npats*4);

  memcpy(m.name, hdr.name, 26);
  m.name[26]=0;

  m.channum=0;
  for (i=0; i<64; i++)
    if (!(hdr.pan[i]&0x80))
      m.channum=i+1;
  if (m.channum>32)
    m.channum=32;
  if (!m.channum||(m.channum>32))
    return errFormSupp;

  m.modsampnum=m.sampnum=hdr.nsmps;
  m.instnum=(hdr.flags&4)?hdr.nins:hdr.nsmps;
  m.patnum=hdr.npats+1;
  m.ordnum=hdr.nords;
  m.endord=hdr.nords;
  m.envnum=3*hdr.nins;
  m.tracknum=hdr.npats*(m.channum+1)+1;
  m.options=MOD_S3M;
  m.loopord=0;
  if (hdr.flags&8)
    m.options|=MOD_EXPOFREQ;

  if (hdr.special&1)
  {
    char *msg=new char [hdr.msglen+1];
    if (!msg)
      return errAllocMem;
    file.seek(hdr.msgoff);
    file.read(msg, hdr.msglen);
    msg[hdr.msglen]=0;
    int linect=1;
    for (i=0; i<hdr.msglen; i++)
    {
      if (msg[i]==0)
        break;
      if (msg[i]==13)
        linect++;
    }
    m.message=new char *[linect+1];
    if (!m.message)
      return errAllocMem;
    *m.message=msg;
    linect=1;
    for (i=0; i<hdr.msglen; i++)
    {
      if (msg[i]==0)
        break;
      if (msg[i]==13)
      {
        msg[i]=0;
        m.message[linect++]=msg+i+1;
      }
    }
    m.message[linect]=0;
  }

  if (!mpAllocInstruments(m, m.instnum)||!mpAllocTracks(m, m.tracknum)||!mpAllocPatterns(m, m.patnum)||!mpAllocSamples(m, m.sampnum)||!mpAllocOrders(m, m.ordnum)||!mpAllocEnvelopes(m, m.envnum))
    return errAllocMem;

  unsigned char reordered[256];

  for (i=m.ordnum-1; i>=0; i--)
  {
    if (orders[i]<254)
      break;
    m.ordnum--;
  }
  if (!m.ordnum)
    return errFormMiss;

  j=0;
  for (i=0; i<m.ordnum; i++)
  {
    orders[j]=orders[i];
    reordered[j]=i;
    if (orders[i]!=254)
      j++;
  }
  int oldpatnum=m.ordnum;
  m.ordnum=j;

  for (i=0; i<m.ordnum; i++)
    if (orders[i]==255)
      break;
  m.endord=i;

  for (i=0; i<hdr.nords; i++)
    if ((orders[i]!=255)&&(orders[i]<hdr.npats))
      m.orders[i]=orders[i];
    else
      m.orders[i]=hdr.npats;

  m.patterns[hdr.npats].patlen=64;
  m.patterns[hdr.npats].gtrack=m.tracknum-1;
  for (i=0; i<m.channum; i++)
    m.patterns[hdr.npats].tracks[i]=m.tracknum-1;

  unsigned char *temptrack=new unsigned char [2000];
  if (!temptrack)
    return errAllocMem;

  unsigned char usechan[64];
  memset(usechan, 0, 64);

  for (k=0; k<hdr.npats; k++)
  {
    if (!patoff[k])
    {
      m.patterns[k].patlen=64;
      m.patterns[k].gtrack=m.tracknum-1;
      for (i=0; i<m.channum; i++)
        m.patterns[k].tracks[i]=m.tracknum-1;
      continue;
    }
    file.seek(patoff[k]);
    int patlen=file.getus();
    int patrows=file.getus();
    file.getl();
    unsigned char *patbuf=new unsigned char [patlen];
    if (!patbuf)
      return errAllocMem;
    file.read(patbuf, patlen);

    m.patterns[k].patlen=patrows;
    m.patterns[k].gtrack=k*(m.channum+1)+m.channum;
    for (i=0; i<m.channum; i++)
      if (hdr.pan[i]&128)
        m.patterns[k].tracks[i]=m.tracknum-1;
      else
        m.patterns[k].tracks[i]=k*(m.channum+1)+i;

    unsigned char chanmask[64];

    for (j=0; j<m.channum; j++)
    {
      unsigned char lastnote;
      unsigned char lastins;
      unsigned char lastvolpan;
      unsigned char lastcmd;
      unsigned char lastdata;
      unsigned char *pp=patbuf;
      unsigned char *tp=temptrack;
      unsigned char *cp=tp+2;
      for (i=0; i<patrows; i++)
      {
        int nte=-1;
        int ins=0;
        int cmd=0;
        int data=0;
        int volpan=-1;

        while (1)
        {
          int chn=*pp++;
          if (!chn--)
            break;
          if ((chn&127)>=32)
            return errFormSupp;
          usechan[chn&127]=1;
          if (chn&128)
            chanmask[chn&=127]=*pp++;
          int c=chanmask[chn];
          if (chn!=j)
          {
            if (c&1)
              pp++;
            if (c&2)
              pp++;
            if (c&4)
              pp++;
            if (c&8)
              pp+=2;
            continue;
          }
          if (c&1)
            lastnote=*pp++;
          if (c&2)
            lastins=*pp++;
          if (c&4)
            lastvolpan=*pp++;
          if (c&8)
          {
            lastcmd=*pp++;
            lastdata=*pp++;
          }
          if (c&0x11)
            nte=lastnote;
          if (c&0x22)
            ins=lastins;
          if (c&0x44)
            volpan=lastvolpan;
          if (c&0x88)
          {
            cmd=lastcmd;
            data=lastdata;
          }
        }

        int vol=-1;
        int pan=-1;
        int pansrnd=0;

        if ((k==orders[0])&&!i)
        {
          if (hdr.pan[j]==100)
          {
            pansrnd=1;
            pan=0x80;
          }
          else
            pan=(hdr.pan[j]>0x3F)?0xFF:(hdr.pan[j]*4);
        }

        if (volpan!=-1)
          if (volpan&128)
          {
            volpan&=127;
            pan=(volpan>0x3F)?0xFF:(volpan*4);
            pansrnd=0;
          }
          else
            vol=(volpan>0x3F)?0xFF:(volpan*4);

        if (nte==255)
        {
          putcmd(cp, cmdKeyOff, 0);
          nte=-1;
        }
        if (nte==254)
        {
          putcmd(cp, cmdNoteCut, 0);
          nte=-1;
        }

        ins--;
        if (nte>=120)
          nte=-1;

        if ((cmd==0x13)&&((data>>4)==0x8))
        {
          pan=(data&0xF)+((data&0xF)<<4);
          pansrnd=0;
        }

        if (cmd==0x18)
        {
          pan=data;
          pansrnd=0;
        }

        if (((cmd==0x7)||(cmd==0xC))&&(nte!=-1))
          nte|=128;

        if ((cmd==0x13)&&(data==0x91))
        {
          pan=0x80;
          pansrnd=1;
        }

        if ((ins!=-1)||(nte!=-1)||(vol!=-1)||(pan!=-1))
        {
          unsigned char &act=*cp;
          *cp++=cmdPlayNote;
          if (ins!=-1)
          {
            act|=cmdPlayIns;
            *cp++=ins;
          }
          if (nte!=-1)
          {
            act|=cmdPlayNte;
            *cp++=nte;
          }
          if (vol!=-1)
          {
            act|=cmdPlayVol;
            *cp++=vol;
          }
          if (pan!=-1)
          {
            act|=cmdPlayPan;
            *cp++=pan;
          }
          if ((cmd==0x13)&&((data>>4)==0xD))
          {
            act|=cmdPlayDelay;
            *cp++=data&0xF;
          }
        }

        if (pansrnd)
          putcmd(cp, cmdPanSurround, 0);


        switch (cmd)
	{
        case 0x04:
          if (!data)
            putcmd(cp, cmdSpecial, cmdContMixVolSlide);
          else
          if ((data&0x0F)==0x00)
            putcmd(cp, cmdVolSlideUp, (data>>4)<<2);
          else
          if ((data&0xF0)==0x00)
            putcmd(cp, cmdVolSlideDown, (data&0xF)<<2);
          else
          if ((data&0x0F)==0x0F)
            putcmd(cp, cmdRowVolSlideUp, (data>>4)<<2);
          else
          if ((data&0xF0)==0xF0)
            putcmd(cp, cmdRowVolSlideDown, (data&0xF)<<2);
          break;
        case 0x05:
          if (!data)
            putcmd(cp, cmdSpecial, cmdContMixPitchSlideDown);
          else
          if (data<0xE0)
            putcmd(cp, cmdPitchSlideDown, data);
          else
          if (data<0xF0)
            putcmd(cp, cmdRowPitchSlideDown, (data&0xF)<<2);
          else
            putcmd(cp, cmdRowPitchSlideDown, (data&0xF)<<4);
          break;
        case 0x06:
          if (!data)
            putcmd(cp, cmdSpecial, cmdContMixPitchSlideUp);
          else
          if (data<0xE0)
            putcmd(cp, cmdPitchSlideUp, data);
          else
          if (data<0xF0)
            putcmd(cp, cmdRowPitchSlideUp, (data&0xF)<<2);
          else
            putcmd(cp, cmdRowPitchSlideUp, (data&0xF)<<4);
          break;
        case 0x07:
          putcmd(cp, cmdPitchSlideToNote, data);
          break;
        case 0x08:
          putcmd(cp, cmdPitchVibrato, data);
          break;
        case 0x09:
          putcmd(cp, cmdTremor, data);
          break;
        case 0x0A:
          putcmd(cp, cmdArpeggio, data);
          break;
        case 0x0B:
          putcmd(cp, cmdPitchVibrato, 0);
          if (!data)
            putcmd(cp, cmdSpecial, cmdContVolSlide);
          if ((data&0x0F)&&(data&0xF0))
            data=0;
          if (data&0xF0)
            putcmd(cp, cmdVolSlideUp, (data>>4)<<2);
          else
          if (data&0x0F)
            putcmd(cp, cmdVolSlideDown, (data&0xF)<<2);
          break;
        case 0x0C:
          putcmd(cp, cmdPitchSlideToNote, 0);
          if (!data)
            putcmd(cp, cmdSpecial, cmdContVolSlide);
          if ((data&0x0F)&&(data&0xF0))
            data=0;
          if (data&0xF0)
            putcmd(cp, cmdVolSlideUp, (data>>4)<<2);
          else
          if (data&0x0F)
            putcmd(cp, cmdVolSlideDown, (data&0xF)<<2);
          break;
        case 0x0D:
          putcmd(cp, cmdChannelVol, (data>0x3F)?0xFF:(data<<2));
          break;
        case 0x0F:
          putcmd(cp, cmdOffset, data);
          break;
        case 0x10:
          if (!data)
            break;
//            putcmd(cp, cmdSpecial, cmdContMixVolSlide);
          else
          if ((data&0x0F)==0x00)
            putcmd(cp, cmdPanSlide, -((data>>4)<<2));
          else
          if ((data&0xF0)==0x00)
            putcmd(cp, cmdPanSlide, (data&0xF)<<2);
          else
          if ((data&0x0F)==0x0F)
            putcmd(cp, cmdRowPanSlide, -((data>>4)<<2));
          else
          if ((data&0xF0)==0xF0)
            putcmd(cp, cmdRowPanSlide, (data&0xF)<<2);
          break;
        case 0x11:
          putcmd(cp, cmdRetrig, data);
	  break;
	case 0x12:
	  putcmd(cp, cmdVolVibrato, data);
	  break;
        case 0x13:
          cmd=data>>4;
	  data&=0x0F;
	  switch (cmd)
	  {
          case 0x3:
            putcmd(cp, cmdPitchVibratoSetWave, (data&3)+0x10);
            break;
          case 0x4:
            putcmd(cp, cmdVolVibratoSetWave, (data&3)+0x10);
            break;
          case 0xC:
            putcmd(cp, cmdNoteCut, data);
	    break;
          }
          break;
        case 0x15:
          putcmd(cp, cmdPitchVibratoFine, data);
          break;
        }

/*
 S5x - Set panbrello waveform
        Waveforms for x in S3x, S4x and S5x:
          0 = Sine                      2 = Square
          1 = Ramp down                 3 = Random
 Yxy - Panbrello with speed x, depth y
*/

        tp[0]=i;
        tp[1]=cp-tp-2;
        tp=cp;
        cp=tp+2;
      }

      gmdtrack &trk=m.tracks[k*(m.channum+1)+j];
      unsigned short len=tp-temptrack;

      if (!len)
        trk.ptr=trk.end=0;
      else
      {
        trk.ptr=new unsigned char [len];
        trk.end=trk.ptr+len;
        if (!trk.ptr)
          return errAllocMem;
        memcpy(trk.ptr, temptrack, len);
      }
    }

    unsigned char lastgcmd[64];
    unsigned char lastgdata[64];
    unsigned char *pp=patbuf;

    unsigned char *tp=temptrack;
    unsigned char *cp=tp+2;

    if (k==orders[0])
    {
      putcmd(cp, cmdTempo, hdr.ispd);
      putcmd(cp, cmdSpeed, hdr.itmp);
      putcmd(cp, cmdGlobVol, (hdr.gvol>0x7F)?0xFF:(hdr.gvol*2));
    }

    i=0;
    while (i<patrows)
    {
      unsigned char chn=*pp++;
      if (!chn--)
      {
        if (cp!=(tp+2))
        {
          tp[0]=i;
          tp[1]=cp-tp-2;
          tp=cp;
          cp=tp+2;
        }
        i++;
        continue;
      }
      if ((chn&127)>=32)
        return errFormSupp;
      if (chn&128)
        chanmask[chn&=127]=*pp++;
      int c=chanmask[chn];
      if (c&1)
        pp++;
      if (c&2)
        pp++;
      if (c&4)
        pp++;
      if (c&8)
      {
        lastgcmd[chn]=*pp++;
        lastgdata[chn]=*pp++;
      }

      int cmd=0;
      int data=0;
      if (c&0x88)
      {
        cmd=lastgcmd[chn];
        data=lastgdata[chn];
      }
      switch (cmd)
      {
      case 0x01:
        if (data)
          putcmd(cp, cmdTempo, data);
        break;
      case 0x02:
        if (data<oldpatnum)
          putcmd(cp, cmdGoto, reordered[data]);
        break;
      case 0x03:
        putcmd(cp, cmdBreak, data);
        break;
      case 0x13:
        cmd=data>>4;
        data&=0x0F;
        switch (cmd)
        {
        case 0xB:
          putcmd(cp, cmdSetChan, chn);
          putcmd(cp, cmdPatLoop, data);
          break;
        case 0xE:
          if (data)
            putcmd(cp, cmdPatDelay, data);
          break;
        }
        break;
      case 0x14:
        if (data>=0x20)
          putcmd(cp, cmdSpeed, data);
        break;
      case 0x16:
        putcmd(cp, cmdGlobVol, (data>0x7F)?0xFF:(data*2));
        break;
      case 0x17:
        putcmd(cp, cmdSetChan, chn);
        if (!data)
          break;
        else
        if ((data&0x0F)==0x00)
          putcmd(cp, cmdGlobVolSlide, (data>>4)<<2);
        else
        if ((data&0xF0)==0x00)
          putcmd(cp, cmdGlobVolSlide, -((data&0xF)<<2));
        break;
      }
    }

    gmdtrack &trk=m.tracks[k*(m.channum+1)+m.channum];
    unsigned short len=tp-temptrack;

    if (!len)
      trk.ptr=trk.end=0;
    else
    {
      trk.ptr=new unsigned char [len];
      trk.end=trk.ptr+len;
      if (!trk.ptr)
        return errAllocMem;
      memcpy(trk.ptr, temptrack, len);
    }

    delete patbuf;
  }
  delete temptrack;

  unsigned char smpinfo[100][5];
  signed short smpnormnotes[100];
  char (*smpnames)[26]=new char[100][26];
  if (!smpnames)
    return errAllocMem;

  for (i=0; i<hdr.nsmps; i++)
  {
    struct
    {
      unsigned long sig;
      char dosname[12];
      unsigned char _d1;
      unsigned char gvol;
      unsigned char flags;
      unsigned char vol;
      char name[26];
      unsigned short _d2;
      unsigned long length;
      unsigned long loopstart;
      unsigned long loopend;
      unsigned long c5spd;
      unsigned long sloopstart;
      unsigned long sloopend;
      unsigned long off;
      unsigned char vspd;
      unsigned char vdep;
      unsigned char vrat;
      unsigned char vtype;
    } shdr;
    file.seek(sampoff[i]);
    file.read(&shdr, sizeof(shdr));
    sampoff[i]=shdr.off;

    sampleinfo &sip=m.samples[i];

    smpinfo[i][0]=shdr.vol;
    smpinfo[i][1]=shdr.vspd;
    smpinfo[i][2]=shdr.vdep;
    smpinfo[i][3]=shdr.vrat;
    smpinfo[i][4]=shdr.vtype;
    memcpy(smpnames[i], shdr.name, 26);

    if (!(shdr.flags&1))
      continue;
    if (shdr.flags&0x4)
      return errFormSupp;
    sip.length=shdr.length;
    sip.loopstart=shdr.loopstart;
    sip.loopend=shdr.loopend;
    sip.sloopstart=shdr.sloopstart;
    sip.sloopend=shdr.sloopend;
    sip.samprate=shdr.c5spd>>((shdr.flags&2)?1:0);
    smpnormnotes[i]=-mcpGetNote8363(shdr.c5spd);
    sip.samprate=8363;
    sip.type=((shdr.flags&2)?mcpSamp16Bit:0)|((shdr.flags&0x10)?mcpSampLoop:0)|((shdr.flags&0x40)?mcpSampBiDi:0)|((shdr.flags&0x80)?mcpSampSBiDi:0)|((shdr.flags&0x20)?mcpSampSLoop:0)|(signedsamp?0:mcpSampUnsigned);
    unsigned long len=sip.length<<((sip.type&mcpSamp16Bit)?1:0);
    sip.ptr=new char [len];
    if (!sip.ptr)
      return errAllocMem;
  }

  for (i=0; i<hdr.nsmps; i++)
  {
    sampleinfo &sip=m.samples[i];
    if (!sip.ptr)
      continue;
    unsigned long len=sip.length<<((sip.type&mcpSamp16Bit)?1:0);
    file.seek(sampoff[i]);
    file.read(sip.ptr, len);
  }

  m.modsampnum=0;
  m.modsamples=0;

  for (k=0; k<m.instnum; k++)
  {
    struct envp
    {
      signed char v;
      unsigned short p;
    };
    struct itenv
    {
      unsigned char flags;
      unsigned char num;
      unsigned char lpb;
      unsigned char lpe;
      unsigned char slb;
      unsigned char sle;
      envp pts[25];
      unsigned char _d1;
    };
    struct
    {
      unsigned long sig;
      char dosname[12];
      unsigned char _d1;
      unsigned char nna;
      unsigned char dct;
      unsigned char dca;
      unsigned short fadeout;
      unsigned char pps;
      unsigned char ppc;
      unsigned char gbv;
      unsigned char dfp;
      unsigned short _d2;
      unsigned short tver;
      unsigned char nos;
      unsigned char _d3;
      char name[26];
      char _d4[6];
      unsigned char keytab[120][2];
      itenv envs[3];
    } ihdr;

    if (hdr.flags&4)
    {
      file.seek(insoff[k]);
      file.read(&ihdr, sizeof(ihdr));
    }
    else
    {
      memset(&ihdr, 0, sizeof(ihdr));
      for (i=0; i<120; i++)
      {
        ihdr.keytab[i][0]=i;
        ihdr.keytab[i][1]=k+1;
      }
      memcpy(ihdr.name, smpnames[k], 26);
      ihdr.dfp=0x80;
      ihdr.pps=0x80;
      ihdr.gbv=128;
    }
    gmdinstrument &ip=m.instruments[k];
    memcpy(ip.name, ihdr.name, 26);
    ip.name[26]=0;

    for (i=0; i<3; i++)
    {
      itenv &ie=ihdr.envs[i];
      gmdenvelope &e=m.envelopes[i*hdr.nins+k];
      e.env=0;
      if (!(ie.flags&1))
        continue;
      e.speed=0;
      e.type=0;
      e.len=ie.pts[ie.num-1].p;
      e.env=new unsigned char [e.len+1];
      if (!e.env)
        return errAllocMem;

      int p=0;
      int h=ie.pts[0].v*4;
      for (j=0; j<ie.num; j++)
      {
        int l=ie.pts[j].p-p;
        int dh=ie.pts[j].v*4-h;
        int n;
        for (n=0; n<l; n++)
        {
          int cv=h+dh*n/l+(i?128:0);
          e.env[p++]=(cv>255)?255:cv;
        }
        h+=dh;
      }
      h+=i?128:0;
      e.env[p]=(h>255)?255:h;

      if (ie.flags&4)
      {
        e.type|=mpEnvSLoop;
        e.sloops=ie.pts[ie.slb].p;
        e.sloope=ie.pts[ie.sle].p;
      }
      if (ie.flags&2)
      {
        e.type|=mpEnvLoop;
        e.loops=ie.pts[ie.lpb].p;
        e.loope=ie.pts[ie.lpe].p;
      }
    }

    int lastsamp=0;
    int lastsampnote=-10;
    int lastsampsamp=-10;

    for (i=0; i<120; i++)
    {
      if ((lastsampsamp==ihdr.keytab[i][1])&&((lastsampnote+1)==ihdr.keytab[i][0]))
      {
        lastsampnote++;
        ip.samples[i]=lastsamp;
        continue;
      }
      if (!ihdr.keytab[i][1])
      {
        ip.samples[i]=0xFFFF;
        continue;
      }

      lastsampnote=ihdr.keytab[i][0];
      lastsampsamp=ihdr.keytab[i][1];

      gmdsample sp;
      memset(&sp, 0, sizeof(sp));
      sp.volfade=0xFFFF;
      sp.volenv=0xFFFF;
      sp.panenv=0xFFFF;
      sp.pchenv=0xFFFF;
      sp.stdpan=-1;
      sp.handle=0xFFFF;
      sp.pchint=2;

      memcpy(sp.name, smpnames[lastsampsamp-1], 26);
      sp.name[26]=0;
      if (m.envelopes[k].env)
        sp.volenv=k;
      if (m.envelopes[1*hdr.nins+k].env)
        sp.panenv=1*hdr.nins+k;
      if (m.envelopes[2*hdr.nins+k].env)
        sp.pchenv=2*hdr.nins+k;
      if (m.samples[lastsampsamp-1].ptr)
        sp.handle=lastsampsamp-1;
      if (!(ihdr.dfp&128))
        sp.stdpan=(ihdr.dfp>0x3F)?0xFF:(ihdr.dfp*4);
      sp.stdvol=(smpinfo[lastsampsamp-1][0]>0x3F)?0xFF:(smpinfo[lastsampsamp-1][0]*4);
      sp.normnote=(i-lastsampnote)*256+smpnormnotes[lastsampsamp-1];
      sp.volfade=ihdr.fadeout<<6;
//      if (m.samples[lastsampsamp-1].type&mcpSamp16Bit)
//        sp.opt=MP_OFFSETDIV2;
      sp.vibrate=smpinfo[i][1]<<8;
      sp.vibdepth=smpinfo[i][2]*4;
      sp.vibspeed=0;
      sp.vibtype=smpinfo[i][4];
      sp.vibsweep=smpinfo[i][2]?(255*smpinfo[i][3]/smpinfo[i][2]):0xFFFF;

      for (j=0; j<m.modsampnum; j++)
        if (!memcmp(&sp, &m.modsamples[j], sizeof(sp)))
          break;
      if (j==m.modsampnum)
      {
//        gmdsample *nms=(gmdsample*)realloc(m.modsamples, (m.modsampnum+1)*sizeof(gmdsample));
//        if (!nms)
//          return errAllocMem;
        gmdsample *nms=new gmdsample [m.modsampnum+1];
        if (!nms)
          return errAllocMem;
        memcpy(nms, m.modsamples, m.modsampnum*sizeof(gmdsample));
        delete m.modsamples;

        m.modsamples=nms;
        m.modsampnum++;
        m.modsamples[j]=sp;
      }
      lastsamp=j;
      ip.samples[i]=j;
    }
  }

  for (i=m.channum-1; i>=0; i--)
  {
    if (usechan[i])
      break;
    m.channum--;
  }

  return errOk;
}
