////////////////////////////////////////////////////////////////////////////
//	write your comments to : loadall@hotmail.com
//  chat with the author (loadall) on IRCNet, channel #coders
////////////////////////////////////////////////////////////////////////////
#include "game.hpp"

#define VCLIPF_INUSE 1
#define VCLIPF_LOOPED 2

char* VClip_Explosion01[] = {"explosion1\\e1.gif",
							"explosion1\\e2.gif",
							"explosion1\\e3.gif",
							"explosion1\\e4.gif",
							0};
char* VClip_Explosion02[] = {"explosion2\\e01.gif",
							"explosion2\\e02.gif",
							"explosion2\\e03.gif",
							"explosion2\\e04.gif",
							"explosion2\\e05.gif",
							"explosion2\\e06.gif",
							"explosion2\\e07.gif",
							"explosion2\\e08.gif",
							"explosion2\\e09.gif",
							"explosion2\\e10.gif",
							"explosion2\\e11.gif",
							"explosion2\\e12.gif",
							"explosion2\\e13.gif",
							"explosion2\\e14.gif",
							"explosion2\\e15.gif",
							"explosion2\\e16.gif",
							"explosion2\\e17.gif",
							"explosion2\\e18.gif",
							"explosion2\\e19.gif",
							"explosion2\\e20.gif",
							"explosion2\\e21.gif",
							0};
char* VClip_Smoke1[] = {"smoke1\\s0.pcx",
						"smoke1\\s1.pcx",
						"smoke1\\s2.pcx",
						"smoke1\\s3.pcx",
						"smoke1\\s4.pcx",
						"smoke1\\s5.pcx",
						"smoke1\\s6.pcx",
						"smoke1\\s7.pcx",
						"smoke1\\s8.pcx",
						"smoke1\\s9.pcx",
						0};
char* VClip_Smoke2[] = {"smoke2\\s0.pcx",
						"smoke2\\s1.pcx",
						"smoke2\\s2.pcx",
						"smoke2\\s3.pcx",
						"smoke2\\s4.pcx",
						"smoke2\\s5.pcx",
						"smoke2\\s6.pcx",
						"smoke2\\s7.pcx",
						"smoke2\\s8.pcx",
						"smoke2\\s9.pcx",
						"smoke2\\sa.pcx",
						0};
char* VClip_Smoke3[] = {"smoke3\\s0.pcx",
						"smoke3\\s1.pcx",
						"smoke3\\s2.pcx",
						"smoke3\\s3.pcx",
						"smoke3\\s4.pcx",
						"smoke3\\s5.pcx",
						"smoke3\\s6.pcx",
						0};
char* VClip_Smoke4[] = {"smoke4\\s0.pcx",
						"smoke4\\s1.pcx",
						"smoke4\\s2.pcx",
						"smoke4\\s3.pcx",
						"smoke4\\s4.pcx",
						"smoke4\\s5.pcx",
						"smoke4\\s6.pcx",
						"smoke4\\s7.pcx",
						0};
void VClip_Release(VClip_t* VClip)
{
	Sys_memClear(VClip, sizeof(*VClip));
}
void VClips_UpdateAll()
{
	VClip_t* VClip = gs->VClips;
	int i;
	for (i=0; i<MAX_VCLIPS; i++, VClip++)
	{
		if (!(VClip->Flags & VCLIPF_INUSE))
			continue;
		VClip->Position[2] -= (gs->Speed * gs->Fps.FrameTime);
		VClip->CurrFrameTime += gs->Fps.FrameTime;
		while (VClip->CurrFrameTime > VClip->TotalFrameTime)
		{
			VClip->CurrFrameTime -= VClip->TotalFrameTime; 
			VClip->CurrTextureName++;
			if (!(*VClip->CurrTextureName))
				if (VClip->Flags & VCLIPF_LOOPED)
					VClip->CurrTextureName = VClip->BaseTextureName;
				else
				{
					VClip_Release(VClip);
					continue;
				}
		}
	}
}
void VClips_DrawAll()
{
	VClip_t* VClip = gs->VClips;
	Sprite_t Sprite;
	Sprite.SrcBlend = D3DBLEND_SRCALPHA;
	Sprite.DestBlend = D3DBLEND_ONE;
	Sprite.Flags = (SPRITEF_INITRENDERSTATE
					| SPRITEF_SETIDENTITYMATRIX
					| SPRITEF_SETDEFAULTUV);
	Sprite_Draw(&Sprite);
	D3D_SetRenderState(D3DRENDERSTATE_ZWRITEENABLE, false);
	Sprite.Matrix = &gs->Camera;
	for (int i=0; i<MAX_VCLIPS; i++, VClip++)
	{
		if (!(VClip->Flags & VCLIPF_INUSE))
			continue;
		float Fraction = VClip->CurrFrameTime / VClip->TotalFrameTime;
		Sprite.Position = &VClip->Position;
		Sprite.Height = VClip->Height;
		Sprite.Width = VClip->Width;
		Sprite.Texture = *VClip->CurrTextureName;
		unsigned char NewAlpha = (unsigned char)(255.0f * (1.0f - Fraction));
		Sprite.Color = (VClip->Color + (NewAlpha << 0x18));
		Sprite.Flags = (SPRITEF_BILLBOARD
						| SPRITEF_SETCOLOR
						| SPRITEF_SETTEXTURE
						| SPRITEF_DRAW);
		Sprite_Draw(&Sprite);
		Sprite.Texture = *(VClip->CurrTextureName+1);
		if (!Sprite.Texture)
			if (VClip->Flags & VCLIPF_LOOPED)
				Sprite.Texture = *(VClip->BaseTextureName);
			else
				continue;
		NewAlpha = (unsigned char)(255.0f * Fraction);
		Sprite.Color = (VClip->Color + (NewAlpha << 0x18));
		Sprite.Flags = (SPRITEF_SETCOLOR
						| SPRITEF_SETTEXTURE
						| SPRITEF_DRAW);
		Sprite_Draw(&Sprite);	
	}
	Sprite.Flags = SPRITEF_RESETRENDERSTATE;
	Sprite_Draw(&Sprite);
	D3D_SetRenderState(D3DRENDERSTATE_ZWRITEENABLE, true);
}
VClip_t* VClip_Create(Vector3 Position, float Width, float Height, 
					 float TotalPlayTime, char** BaseTextureName, int IsLooped)
{
	VClip_t* VClip = gs->VClips;
	int i;
	for (i=0; i<MAX_VCLIPS; i++, VClip++)
		if (!(VClip->Flags & VCLIPF_INUSE))
			break;
	if (i == MAX_VCLIPS)
		Error("VClip_Create()");
	VClip->Flags = VCLIPF_INUSE;
	if (IsLooped)
		VClip->Flags |= VCLIPF_LOOPED;
	VectorCopy(VClip->Position, Position);
	VClip->Width = Width;
	VClip->Height = Height;
	VClip->Color = 0xffffff;
	VClip->CurrFrameTime = 0.0f;
	VClip->CurrTextureName = VClip->BaseTextureName = BaseTextureName;
	int NumFrames = 0;
	char** ppTextureName = VClip->BaseTextureName;
	while (*ppTextureName != 0)
	{
		NumFrames++;
		ppTextureName++;
	}
	VClip->TotalFrameTime = TotalPlayTime / NumFrames;
	return VClip;
}
