////////////////////////////////////////////////////////////////////////////
//	write your comments to : loadall@hotmail.com
//  chat with the author (loadall) on IRCNet, channel #coders
////////////////////////////////////////////////////////////////////////////
#include "game.hpp"
void Tunnel_Draw()
{
	Tunnel_t* Tunnel = &gs->Tunnel;
	Matrix4x3 Matrix;
	int i;
    D3D_SetRenderState(D3DRENDERSTATE_ZFUNC,D3DCMP_ALWAYS);
	Matrix_SetIdentity(Matrix);
	Matrix[3][2] = gs->Player.Position[2];
	D3D_SetTransform(D3DTRANSFORMSTATE_WORLD, (float*)&Matrix);
	D3D_SetTexture(0, Texture_Get("White.gif"));
	D3D_DrawPrimitive(D3DPT_TRIANGLESTRIP, D3DFVF_LVERTEX, Tunnel->HorizonFront, 4, 0);
	D3D_DrawPrimitive(D3DPT_TRIANGLESTRIP, D3DFVF_LVERTEX, Tunnel->HorizonBack, 4, 0);
	float v0 = M_fmod(gs->Fps.GameTime * gs->Speed * 0.015f, 1.0f);
	float v1 = v0 + 20.0f;
	LVERTEX* pVertex = &Tunnel->Walls[0];
	for (i=0; i<5; i++)
	{
		pVertex->tv = v0;
		pVertex++;
		pVertex->tv = v1;
		pVertex++;
	}
	D3D_SetTexture(0, Texture_Get("3.gif"));
	D3D_DrawPrimitive(D3DPT_TRIANGLESTRIP, D3DFVF_LVERTEX, Tunnel->Walls, 10, 0);
	D3D_SetRenderState(D3DRENDERSTATE_ALPHABLENDENABLE, true);
	D3D_SetRenderState(D3DRENDERSTATE_SRCBLEND,D3DBLEND_ONE);
	D3D_SetRenderState(D3DRENDERSTATE_DESTBLEND,D3DBLEND_ONE);
	pVertex = &Tunnel->Walls[0];
	for (i=0; i<5; i++)
	{
		pVertex->tv = 0.0f;
		pVertex++;
		pVertex->tv = 1.0f;
		pVertex++;
	}
	D3D_SetTexture(0, Texture_Get("4.gif"));
	D3D_DrawPrimitive(D3DPT_TRIANGLESTRIP, D3DFVF_LVERTEX, Tunnel->Walls, 10, 0);
	D3D_SetRenderState(D3DRENDERSTATE_ALPHABLENDENABLE, false);
    D3D_SetRenderState(D3DRENDERSTATE_ZFUNC,D3DCMP_LESSEQUAL);
}
void Tunnel_ClipPosition(Vector3 Position)
{
	Tunnel_t* Tunnel = &gs->Tunnel;
	float w = Tunnel->Width - 1.0f;
	float h = Tunnel->Height - 1.0f;
	if (Position[0] < -w)
		Position[0] = -w;
	else if (Position[0] > w)
		Position[0] = w;
	if (Position[1] < -h)
		Position[1] = -h;
	else if (Position[1] > h)
		Position[1] = h;
}
void Tunnel_Init()
{
	
	Tunnel_t* Tunnel = &gs->Tunnel;
	float w = Tunnel->Width = 100.0f;
	float h = Tunnel->Height = 50.0f;
	const static float l = 1000.0f;
	static const int Color = 0xffa0a0a0;
	LVERTEX_Set(&Tunnel->Walls[0], -w,  h, -l, Color, 0.0f, 1.0f);
	LVERTEX_Set(&Tunnel->Walls[1], -w,  h,  l, Color, 0.0f, 0.0f);
	LVERTEX_Set(&Tunnel->Walls[2],  w,  h, -l, Color, 1.0f, 1.0f);
	LVERTEX_Set(&Tunnel->Walls[3],  w,  h,  l, Color, 1.0f, 0.0f);
	LVERTEX_Set(&Tunnel->Walls[4],  w, -h, -l, Color, 2.0f, 1.0f);
	LVERTEX_Set(&Tunnel->Walls[5],  w, -h,  l, Color, 2.0f, 0.0f);
	LVERTEX_Set(&Tunnel->Walls[6], -w, -h, -l, Color, 3.0f, 1.0f);
	LVERTEX_Set(&Tunnel->Walls[7], -w, -h,  l, Color, 3.0f, 0.0f);
	LVERTEX_Set(&Tunnel->Walls[8], -w,  h, -l, Color, 4.0f, 1.0f);
	LVERTEX_Set(&Tunnel->Walls[9], -w,  h,  l, Color, 4.0f, 0.0f);
	LVERTEX_Set(&Tunnel->HorizonFront[0], -w,  h, l, Color, 0.0f, 0.0f);
	LVERTEX_Set(&Tunnel->HorizonFront[1], -w, -h, l, Color, 0.0f, 1.0f);
	LVERTEX_Set(&Tunnel->HorizonFront[2],  w,  h, l, Color, 1.0f, 0.0f);
	LVERTEX_Set(&Tunnel->HorizonFront[3],  w, -h, l, Color, 1.0f, 1.0f);
	LVERTEX_Set(&Tunnel->HorizonBack[0], -w, -h, -l, Color, 0.0f, 1.0f);
	LVERTEX_Set(&Tunnel->HorizonBack[1], -w,  h, -l, Color, 0.0f, 0.0f);
	LVERTEX_Set(&Tunnel->HorizonBack[2],  w, -h, -l, Color, 1.0f, 1.0f);
	LVERTEX_Set(&Tunnel->HorizonBack[3],  w,  h, -l, Color, 1.0f, 0.0f);

}
