////////////////////////////////////////////////////////////////////////////
//	write your comments to : loadall@hotmail.com
//  chat with the author (loadall) on IRCNet, channel #coders
////////////////////////////////////////////////////////////////////////////
#include <windows.h>
#include "system.hpp"

void Sys_WindowCreate();
void Sys_HeapCreate(int size);
void Sys_HeapRelease();

#define RESOURCES_FILENAME "data.pak"
#define HEAP_SIZE		(2 * 1024 * 1024)
#define MAX_TMP_HEAP	 1000
#define MAX_MALLOC_BLOCKS 1000

typedef struct {
	char* lpFreeBottom;
	char* lpFreeTop;
	int numTmp;
	char* lpOldFreeTop[MAX_TMP_HEAP];
	char* lpTmpData[MAX_TMP_HEAP];
} HeapStruc;

typedef struct {
	int MaxAllocatedMemory;
	int CurrentAllocatedMemory;
	void* BlockAddress[MAX_MALLOC_BLOCKS];
	int BlockSize[MAX_MALLOC_BLOCKS];
} MemAllocStruc_t;

int  hAppInstance;
int  hMainWnd;
int  hLogFile;
char szLogFileName[0x20];
HeapStruc* lpHeap = 0;
MemAllocStruc_t* MemAllocData = 0;

int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow)
{
	init();
	run();
	release();
	Sys_Exit();
	return 1;
}
void Sys_Init(int Flags)
{
	hAppInstance = (int) GetModuleHandle(NULL);
	Sys_WindowCreate();
	Sys_HeapCreate(HEAP_SIZE);
	Sys_logOpen("log.txt");	
	if (Flags & SYSF_DOPAK)
		Pak();
	Input_Create(hMainWnd,hAppInstance);
	D3D_Create(hMainWnd, Flags & SYSF_DOD3D);
	Sound_Create(hMainWnd, Flags & SYSF_DOSOUND);
	Resources_Create(RESOURCES_FILENAME);
}

void Sys_WindowCreate()
{
	hMainWnd = (int) CreateWindowEx(WS_EX_TOPMOST,\
			 "static",\
			 "un titre pour la fenetre ? ben...",\
			 (WS_VISIBLE | WS_POPUP),\
			 CW_USEDEFAULT,\
			 CW_USEDEFAULT,\
			 CW_USEDEFAULT,\
			 CW_USEDEFAULT,\
			 0, 0, (HINSTANCE)hAppInstance, 0);
	SetFocus((HWND)hMainWnd);
	ShowWindow((HWND)hMainWnd, SW_NORMAL);
	UpdateWindow((HWND)hMainWnd);
}
void Sys_Exit()
{
	Input_Release();
	Sound_Release();
	D3D_Release();
	Sys_logPrintf("max RAM totale utilise : %i octets", MemAllocData->MaxAllocatedMemory);
	Sys_logClose();
	Sys_HeapRelease();
	ExitProcess(0);
}
void Error(char* szFormat,...)
{
	char buffer[0x100];
	release();
	D3D_Release();
	if (hMainWnd)
		DestroyWindow((HWND)hMainWnd);
	hMainWnd = 0;
	wvsprintf(buffer,szFormat,(char*)&szFormat + sizeof(char*));
	MessageBox(0,buffer,"y'a une erreur", MB_ICONERROR);
	Sys_Exit();
}
int Sys_pumpMsg()
{
	MSG msg;
	if (!PeekMessage(&msg, 0, 0, 0, PM_REMOVE))
		return 1;
	TranslateMessage(&msg);
	DispatchMessage(&msg);
	if (msg.message == WM_QUIT)
		return 0;
	return 1;
}
int Sys_GetTickCount()
{
	return GetTickCount();
}
void* Sys_FileLoad(char* szFileName,int* lpFileSize)
{
	int hFile, fileSize;
	void* lpDest;
	hFile = Sys_FileOpen(szFileName);
	fileSize = Sys_FileGetSize(hFile);
	(*lpFileSize) = fileSize;
	lpDest = Sys_MemAlloc(fileSize);
	Sys_FileRead(szFileName, hFile, lpDest, fileSize);
	Sys_FileClose(hFile);
	return lpDest;
}
int Sys_FileOpen(char* lpszFileName)
{
	HANDLE hFile;
	if ((hFile = CreateFile(\
			lpszFileName, \
			(GENERIC_READ | GENERIC_WRITE),\
			(FILE_SHARE_READ | FILE_SHARE_WRITE),\
			0, OPEN_EXISTING,\
			FILE_FLAG_RANDOM_ACCESS, 0)) == INVALID_HANDLE_VALUE)
	Error("Sys_FileOpen(%s)",lpszFileName);
	return (int)hFile;
}
int Sys_FileCreate(char* lpszFileName)
{
	HANDLE hFile;
	if ((hFile = CreateFile(\
			lpszFileName, \
			(GENERIC_READ | GENERIC_WRITE),\
			(FILE_SHARE_READ | FILE_SHARE_WRITE),\
			0, CREATE_ALWAYS,\
			FILE_FLAG_RANDOM_ACCESS, 0)) == INVALID_HANDLE_VALUE)
		Error("Sys_FileCreate(%s)",lpszFileName);
	return (int)hFile;
}
void Sys_FileClose(int hFile)
{
	CloseHandle((HANDLE)hFile);
}
void Sys_FileRead(char* szFileName, int hFile, void* lpDest, int size)
{
	int tmp;
	if (!ReadFile((HANDLE)hFile, lpDest, size, (LPDWORD)&tmp, 0))
		Error("Sys_FileRead(%s)",szFileName);
}
void Sys_FileWrite(char* szFileName, int hFile, void* lpSrc, int size)
{
	int tmp;
	if (!WriteFile((HANDLE)hFile, lpSrc, size, (LPDWORD)&tmp, 0))
		Error("Sys_FileWrite(%s)", szFileName);
}
int Sys_FileGetSize(int hFile)
{
	return	GetFileSize((HANDLE)hFile, 0);
}
void Sys_FileSeekBegin(int hFile, int offset)
{
	SetFilePointer((HANDLE)hFile, offset, 0, FILE_BEGIN);
}
int Sys_FileExists(char* szFileName)
{
	HANDLE hFile = CreateFile(szFileName,0,0,0,OPEN_EXISTING,FILE_FLAG_RANDOM_ACCESS,0);
	if (hFile != INVALID_HANDLE_VALUE)
		Sys_FileClose((int)hFile);
	return (hFile != INVALID_HANDLE_VALUE);
}
void* Sys_MemAlloc(int size)
{
	int i;
	if (!MemAllocData)
	{
		MemAllocData = (MemAllocStruc_t*)VirtualAlloc(0, sizeof(*MemAllocData),
						(MEM_COMMIT | MEM_RESERVE),PAGE_READWRITE);
		Sys_memClear(MemAllocData, sizeof(*MemAllocData));
	}
	void* BlockAddress = VirtualAlloc(0, size,(MEM_COMMIT | MEM_RESERVE),PAGE_READWRITE);
	int BlockSize = ((size + 4095) & (~4095));
	for (i=0; i<MAX_MALLOC_BLOCKS; i++)
		if (!MemAllocData->BlockAddress[i])
			break;
	if (i == MAX_MALLOC_BLOCKS)
		Error("Sys_MemAlloc()");
	MemAllocData->BlockAddress[i] = BlockAddress;
	MemAllocData->BlockSize[i] = BlockSize;
	MemAllocData->CurrentAllocatedMemory += BlockSize;
	if (MemAllocData->CurrentAllocatedMemory > MemAllocData->MaxAllocatedMemory)
		MemAllocData->MaxAllocatedMemory = MemAllocData->CurrentAllocatedMemory;
	return BlockAddress;
}
void Sys_MemFree(void* lpData)
{
	int i;
	if (lpData)
		VirtualFree(lpData, 0, MEM_RELEASE);
	for (i=0; i<MAX_MALLOC_BLOCKS; i++)
		if (MemAllocData->BlockAddress[i] == lpData)
			break;
	if (i == MAX_MALLOC_BLOCKS)
		Error("Sys_MemFree(%x)",lpData);
	MemAllocData->BlockAddress[i] = 0;
	MemAllocData->CurrentAllocatedMemory -= MemAllocData->BlockSize[i];
}	
void Sys_memClear(void* lpDest, int size)
{
	unsigned char* dest = (unsigned char*)lpDest;
	for (int i=0; i<size; i++)
		*(dest++) = 0;
}
void Sys_memCopy(void* pDest, void* pSrc, int size)
{
	unsigned char* dest, *src;
	dest = (unsigned char*)pDest;
	src = (unsigned char*)pSrc;
	for (int i=0; i<size; i++)
		*(dest++) = *(src++);
}
void Sys_HeapCreate(int size)
{
	lpHeap = (HeapStruc*)Sys_MemAlloc(size);
	Sys_memClear(lpHeap, size);
	lpHeap->lpFreeBottom = (char*)lpHeap + sizeof(HeapStruc);
	lpHeap->lpFreeTop = (char*)lpHeap + size;
	lpHeap->numTmp = 0;
}
void Sys_HeapRelease()
{
	Sys_MemFree(lpHeap);
	lpHeap = 0;
}
void* Sys_HeapAlloc(int size)
{
	void* pData;
	size = ((size + 4) & (~4));
	if (lpHeap->lpFreeBottom + size > lpHeap->lpFreeTop)
		Error("HeapAlloc()");
	pData = lpHeap->lpFreeBottom;
	lpHeap->lpFreeBottom += size;
	return pData;
}
void* Sys_HeapAllocTemp(int size)
{
	size = ((size + 4) & (~4));
	if (lpHeap->numTmp >= MAX_TMP_HEAP)
		goto failure;
	if (lpHeap->lpFreeTop - size < lpHeap->lpFreeBottom)
		goto failure;
	lpHeap->lpOldFreeTop[lpHeap->numTmp] = lpHeap->lpFreeTop;
	lpHeap->lpFreeTop -= size;
	lpHeap->lpTmpData[lpHeap->numTmp++] = lpHeap->lpFreeTop;
	return lpHeap->lpFreeTop;
	failure:
	{
		Error("HeapAlloc()");
		return 0;
	}
}
void Sys_HeapFreeTemp(void* data)
{
	int i;
	for (i = lpHeap->numTmp;((i) && (lpHeap->lpTmpData[i - 1] != data));i--);
	if (!i)
		Error("Sys_HeapFreeTemp(%x)",data);
	if (i < lpHeap->numTmp)
		lpHeap->lpTmpData[i - 1] = 0;
	else
	{
		for (i--;(i > 0) && (!lpHeap->lpTmpData[i - 1]);i--);
		lpHeap->lpFreeTop = lpHeap->lpOldFreeTop[i];
		lpHeap->numTmp = i;
	}	
}
int Sys_strlen(char* string)
{
	int length = 0;
	while ((*(string++)) != 0)
		length++;
	return length;
}
void Sys_strcat(char* dest, char* src)
{
	dest += Sys_strlen(dest);
	Sys_strcpy(dest, src);
}
void Sys_strcpy(char* dest, char* src)
{
	for (;(*(dest++)) = (*(src++));(*src)) ;
}
void Sys_sprintf(char* dest,char* szFormat,...)
{
	wvsprintf(dest,szFormat,(char*)&szFormat + sizeof(char*));
}
void Sys_vsprintf(char* dest, char* szFormat, char* pArgList)
{
	wvsprintf(dest,szFormat,pArgList);
}
int Sys_strcmp(char* string1, char* string2)
{
	for (; (*string1 == *string2) && (*string1 != 0); string1++, string2++);
	return ((*string1 == 0) && (*string2 == 0));
}
int Sys_strncmp(char* string1, char* string2, int count)
{
	int i;
	for (i = 0;((string1[i] == string2[i]) && (i < count));i++);
	return (i == count);
}
char* Sys_strchr(char* string, int chr)
{
	do {
		if ((*string) == (char)chr)
			return string;
	} while ((*string++) != 0);
	return 0;
}
void Sys_StrToUpper(char* string)
{
	while (*string != 0)
	{
		if ((*string >= 'a') && (*string <= 'z'))
			*string += ('A' - 'a');
		string++;
	}
}
int Sys_atoi(char* szSrc)
{
	int retValue;
	_asm {	
	pushad
	mov	esi, [szSrc]
	xor	eax, eax
	xor	edx, edx
	WW100:
	mov	al, [esi]
	inc	esi
	cmp	al, 0
	je	WW900
	imul	edx, 0ah
	sub	al, '0'
	add	edx, eax
	jmp	WW100
	WW900:
	mov	[retValue], edx
	popad
	}
	return retValue;
}
void Sys_logOpen(char* szLogFile)
{
	if (hLogFile)
		Sys_FileClose(hLogFile);
	hLogFile = Sys_FileCreate(szLogFile);
	Sys_strcpy(szLogFileName,szLogFile);
}
void Sys_logClose()
{
	if (hLogFile)
		Sys_FileClose(hLogFile);
	hLogFile = 0;
}
void Sys_logPrintf(char* szFormat,...)
{
	char buffer[0x100];
	if (!hLogFile)
		return;
	wvsprintf(buffer,szFormat,(char*)&szFormat + sizeof(char*));
	strcat(buffer, "\r\n");
	Sys_FileWrite(szLogFileName, hLogFile, buffer, strlen(buffer));
}
