////////////////////////////////////////////////////////////////////////////
//	write your comments to : loadall@hotmail.com
//  chat with the author (loadall) on IRCNet, channel #coders
////////////////////////////////////////////////////////////////////////////
#include "system.hpp"
#include "pak.hpp"

Mesh_t* pMeshes = 0;

int MAKE_RGBA(float r, float g, float b, float a)
{
	return ( ((int)(a * 255.0f) << 24) | ((int)(r * 255.0f) << 16) | \
			 ((int)(g * 255.0f) << 8) | ((int)(b * 255.0f)));
}
DirFile_t* FindPakDirectory(PakHeader_t* pPakFile, char* szName, int* pNumFiles)
{
	DirHeader_t* pDirectory = (DirHeader_t*)((char*)pPakFile + pPakFile->dirOffset);
	for (int i = pPakFile->numDirs; i > 0; i--)
	{
		if (Sys_strcmp(szName, pDirectory->szDirName))
			break;
		else pDirectory = (DirHeader_t*)(((char*)(pDirectory)) + pDirectory->numFiles * sizeof(DirFile_t) + sizeof(DirHeader_t));
	}
	if (!i)
		Error("FindPakDirectory(%s)",szName);
	(*pNumFiles) = pDirectory->numFiles;
	return (DirFile_t*)(++pDirectory);
}
Mesh_t* Mesh_Get(char* name)
{
	Mesh_t* pMesh = pMeshes;
	if (!pMesh)
		goto failure;
	while (1)
	{
		if (Sys_strcmp(name, pMesh->szName))
			break;
		if (!(pMesh = pMesh->pNext))
			goto failure;
	}
	return pMesh;
	failure:
	{
		Error("Mesh_Get(%s)", name);
		return 0;
	}
}
void Resources_LoadBitmaps(PakHeader_t* pPakFile)
{
	int numBitmaps;
	int totalVideoMemoryRequired = 0;
	BitmapHeader_t* pSrcBitmap;
	DirFile_t* pFileHeader = FindPakDirectory(pPakFile,BITMAPS_DIR_NAME,&numBitmaps);
	Sys_logPrintf("[%s] * %i",BITMAPS_DIR_NAME, numBitmaps);
	for (; numBitmaps > 0; numBitmaps--, pFileHeader++)
	{
		pSrcBitmap = (BitmapHeader_t*)((char*)pPakFile + pFileHeader->offset);
		if (pSrcBitmap->id != BMP_SIGNATURE)
			Error("Le format du bitmap %s est invalide", pFileHeader->szFileName);
		Texture_Load(pFileHeader->szFileName,\
					 (char*)pSrcBitmap + sizeof(BitmapHeader_t),\
					(char*)pSrcBitmap->palette,\
					pSrcBitmap->width,\
					pSrcBitmap->height,\
					pSrcBitmap->mipMapCount);
		totalVideoMemoryRequired += Texture_CalcMemRequired(pSrcBitmap->width,
															pSrcBitmap->height,
															pSrcBitmap->mipMapCount);
	}
	Sys_logPrintf("  Mmoire Vido occupe par les textures = %i octets",totalVideoMemoryRequired);
}
void Resources_LoadSounds(PakHeader_t* pPakFile)
{
	int NumSounds;
	SoundHeader_t* pSrcSound;
	DirFile_t* pFileHeader = FindPakDirectory(pPakFile,SOUNDS_DIR_NAME,&NumSounds);
	Sys_logPrintf("[%s] * %i",SOUNDS_DIR_NAME, NumSounds);
	for (int i=0; i<NumSounds; i++, pFileHeader++)
	{
		pSrcSound = (SoundHeader_t*)((char*)pPakFile + pFileHeader->offset);
		if (pSrcSound->Signature != WAV_SIGNATURE)
			Error("Le format du son %s est invalide", pFileHeader->szFileName);
		Sys_logPrintf("   %s : %i Hz, %i bits/sample, %i canaux, %i octets", 
					pFileHeader->szFileName, pSrcSound->nSamplesPerSec, 
					pSrcSound->wBitsPerSample, pSrcSound->nChannels, pSrcSound->DataSize);
		Sound_Load(pFileHeader->szFileName, &pSrcSound->wFormatTag, pSrcSound+1, pSrcSound->DataSize);
	}
}
void Mesh_FixCoords(Mesh_t* mesh)
{
	char* pDest = mesh->pTriangles;
	for (int i=0; i<mesh->NumTriGroups; i++)
	{
		TriGroup_t* pTriGroup = (TriGroup_t*)pDest;
		pDest += sizeof(TriGroup_t);
		for (int j=0; j<pTriGroup->NumVertices; j++)
		{
			LVERTEX* pVertex = (LVERTEX*)pDest;
			float tmp = pVertex->y;
			pVertex->y = pVertex->z;
			pVertex->z = tmp;
			pVertex->tv = 1.0f - pVertex->tv;
//			pVertex->tu = 1.0f - pVertex->tu;
//			tmp = pVertex->tu;
//			pVertex->tu = pVertex->tv;
//			pVertex->tv = tmp;
			pDest += sizeof(LVERTEX);
		}
	}
}
void Resources_LoadMeshes(PakHeader_t* pPakFile)
{
	int numMeshes;
	Mesh_t** ppNextMesh = 0;
	DirFile_t* pFileHeader = FindPakDirectory(pPakFile,MESHES_DIR_NAME,&numMeshes);
	Sys_logPrintf("[%s] * %i",MESHES_DIR_NAME,numMeshes);
	for (int i=0; i<numMeshes; i++)
	{
		char* pSrcMesh = (char*)pPakFile + pFileHeader[i].offset;
		if (*(int*)pSrcMesh != MESH_SIGNATURE)
			Error("Le format du mesh %s est invalide", pFileHeader[i].szFileName);
		pSrcMesh += sizeof(int);

		Mesh_t* pDestMesh = (Mesh_t*)Sys_HeapAlloc(sizeof(*pDestMesh));
		if (!pMeshes)
			pMeshes = pDestMesh;
		if (ppNextMesh)
			*ppNextMesh = pDestMesh;
		ppNextMesh = &pDestMesh->pNext;
		pDestMesh->pNext = 0;

		Sys_strcpy(pDestMesh->szName, pFileHeader[i].szFileName);

		int numTexCoords = *(int*)pSrcMesh;
		pSrcMesh += sizeof(int);
		TexCoords_t* pSrcTexCoords = (TexCoords_t*)pSrcMesh;
		pSrcMesh += (numTexCoords * sizeof(TexCoords_t));
		int numSrcVertices = *(int*)pSrcMesh;
		pSrcMesh += sizeof(int);
		VertexCoords_t* pSrcVertices = (VertexCoords_t*)pSrcMesh;
		pSrcMesh += numSrcVertices * sizeof(VertexCoords_t);

		pDestMesh->NumSubMeshes = *(int*)pSrcMesh;
		pSrcMesh += sizeof(int);
		pDestMesh->pSubMeshes = (SubMeshDesc_t*)Sys_HeapAlloc(
				pDestMesh->NumSubMeshes * sizeof(*pDestMesh->pSubMeshes));
		Sys_memCopy(pDestMesh->pSubMeshes, pSrcMesh,
				pDestMesh->NumSubMeshes * sizeof(*pDestMesh->pSubMeshes));
		pSrcMesh += pDestMesh->NumSubMeshes * sizeof(*pDestMesh->pSubMeshes);

		pDestMesh->NumTriangles = *(int*)pSrcMesh;
		pSrcMesh += sizeof(int);
		pDestMesh->NumTriGroups = *(int*)pSrcMesh;
		pSrcMesh += sizeof(int);
		int memRequired = sizeof(TriGroup_t)*pDestMesh->NumTriGroups
						 +sizeof(LVERTEX)*pDestMesh->NumTriangles*3
						 +sizeof(TriangleDesc_t)*pDestMesh->NumTriangles;
		pDestMesh->pTriDesc = (TriangleDesc_t*)Sys_HeapAlloc(memRequired);
		pDestMesh->pTriangles = ((char*)pDestMesh->pTriDesc)
								+sizeof(TriangleDesc_t)*pDestMesh->NumTriangles;
		char* pDestTriangles = pDestMesh->pTriangles;
		for (int j=0; j<pDestMesh->NumTriGroups; j++)
		{
			int numTriGroupVertices = ((TriGroupDesc_t*)pSrcMesh)->numTriangles * 3;
			((TriGroup_t*)pDestTriangles)->NumVertices = numTriGroupVertices;
			((TriGroup_t*)pDestTriangles)->pTexture = Texture_Get(((TriGroupDesc_t*)pSrcMesh)->textureName);
			pSrcMesh += sizeof(TriGroupDesc_t);
			pDestTriangles += sizeof(TriGroup_t);
			for (int k=0; k<numTriGroupVertices; k++)
			{
				int vertexIndex = *((unsigned short*)pSrcMesh);
				pSrcMesh += sizeof(unsigned short);
				int texCoordIndex = *((unsigned short*)pSrcMesh);
				pSrcMesh += sizeof(unsigned short);
				LVERTEX* pDestVertex = (LVERTEX*)pDestTriangles;
				pDestVertex->x = pSrcVertices[vertexIndex].coords[0];
				pDestVertex->y = pSrcVertices[vertexIndex].coords[1];
				pDestVertex->z = pSrcVertices[vertexIndex].coords[2];
				pDestVertex->color = 0xffffffff;
				pDestVertex->tu = pSrcTexCoords[texCoordIndex].coords[0];
				pDestVertex->tv = pSrcTexCoords[texCoordIndex].coords[1];
				pDestTriangles += sizeof(LVERTEX);
			}
		}
		Mesh_FixCoords(pDestMesh);
		Mesh_SetTrianglesDesc(pDestMesh);
		Sys_logPrintf("  %s : %i triangles, %i triGroups, %i octets,"\
					  " radius = %i, mins = %s, maxs = %s",
						pDestMesh->szName,
						pDestMesh->NumTriangles,
						pDestMesh->NumTriGroups,
						memRequired+sizeof(*pDestMesh),
						(int)pDestMesh->Radius,
						VectorToString(pDestMesh->Mins),
						VectorToString(pDestMesh->Maxs));
	}
}
void Mesh_Draw(Mesh_t* mesh, Matrix4x3 matrix, Vector3 scaling)
{
	Matrix4x3 tmpMatrix;
	Matrix4x3* pMatrix = (Matrix4x3*)(&matrix[0]);
	if ((matrix) && (scaling))
	{
		Matrix_Scale(tmpMatrix, matrix, scaling);
		pMatrix = &tmpMatrix;
	}
	if (pMatrix)
		D3D_SetTransform(D3DTRANSFORMSTATE_WORLD, (float*)(*pMatrix));
	char* pSrc = mesh->pTriangles;
	for (int i=0; i < mesh->NumTriGroups; i++)
	{
		TriGroup_t* pTriGroup = (TriGroup_t*)pSrc;
		pSrc += sizeof(TriGroup_t);
		D3D_SetTexture(0,pTriGroup->pTexture);
		D3D_DrawPrimitive(D3DPT_TRIANGLELIST, D3DFVF_LVERTEX,
							pSrc, pTriGroup->NumVertices, 0);
		pSrc += pTriGroup->NumVertices * sizeof(LVERTEX);
	}
}
void Sprite_Draw(Sprite_t* Sprite)
{
	int i;
	if (Sprite->Flags & SPRITEF_INITRENDERSTATE)
	{
		D3D_SetRenderState(D3DRENDERSTATE_ALPHABLENDENABLE, true);
		D3D_SetRenderState(D3DRENDERSTATE_SRCBLEND, Sprite->SrcBlend);
		D3D_SetRenderState(D3DRENDERSTATE_DESTBLEND, Sprite->DestBlend);
	}
	if (Sprite->Flags & SPRITEF_SETTEXTURE)
		D3D_SetTexture(0, Texture_Get(Sprite->Texture));
	if (Sprite->Flags & SPRITEF_SETIDENTITYMATRIX)
		D3D_SetTransform(D3DTRANSFORMSTATE_WORLD, (float*)MatrixIdentity);
	else if (Sprite->Flags & SPRITEF_SETMATRIX)
		D3D_SetTransform(D3DTRANSFORMSTATE_WORLD, (float*)Sprite->Matrix);
	if (Sprite->Flags & SPRITEF_2D)
	{
		if (Sprite->Flags & SPRITEF_INITRENDERSTATE)
			D3D_SetRenderState(D3DRENDERSTATE_ZFUNC, D3DCMP_ALWAYS);
		if (Sprite->Flags & SPRITEF_SETDEFAULTCOLOR)
			Sprite->Vertices2d[0].color = Sprite->Vertices2d[1].color = 
			Sprite->Vertices2d[2].color = Sprite->Vertices2d[3].color = 0xffffffff;
		else if (Sprite->Flags & SPRITEF_SETCOLOR)
			Sprite->Vertices2d[0].color = Sprite->Vertices2d[1].color = 
			Sprite->Vertices2d[2].color = Sprite->Vertices2d[3].color = Sprite->Color;
		if (Sprite->Flags & SPRITEF_SETDEFAULTUV)
		{
			Sprite->Vertices2d[0].tu = Sprite->Vertices2d[1].tu = 
			Sprite->Vertices2d[0].tv = Sprite->Vertices2d[2].tv = 0.0f;
			Sprite->Vertices2d[1].tv = Sprite->Vertices2d[2].tu = 
			Sprite->Vertices2d[3].tu = Sprite->Vertices2d[3].tv = 1.0f;
		}
		else if (Sprite->Flags & SPRITEF_SETUV)
		{
			Sprite->Vertices2d[0].tu = Sprite->Vertices2d[1].tu = Sprite->u0;
			Sprite->Vertices2d[0].tv = Sprite->Vertices2d[2].tv = Sprite->v0;
			Sprite->Vertices2d[2].tu = Sprite->Vertices2d[3].tu = Sprite->u1;
			Sprite->Vertices2d[1].tv = Sprite->Vertices2d[3].tv = Sprite->v1;
		}
		if (Sprite->Flags & SPRITEF_SETDEFAULTZW)
		{
			Sprite->Vertices2d[0].sz = Sprite->Vertices2d[1].sz = 
			Sprite->Vertices2d[2].sz = Sprite->Vertices2d[3].sz = 0.01f;
			Sprite->Vertices2d[0].rhw = Sprite->Vertices2d[1].rhw = 
			Sprite->Vertices2d[2].rhw = Sprite->Vertices2d[3].rhw = 10.0f;
		}
		if (Sprite->Flags & SPRITEF_SETXY)
		{
			Sprite->Vertices2d[0].sx = Sprite->Vertices2d[1].sx = Sprite->x0;
			Sprite->Vertices2d[0].sy = Sprite->Vertices2d[2].sy = Sprite->y0;
			Sprite->Vertices2d[2].sx = Sprite->Vertices2d[3].sx = Sprite->x1;
			Sprite->Vertices2d[1].sy = Sprite->Vertices2d[3].sy = Sprite->y1;
		}
		if (!(Sprite->Flags & SPRITEF_NOSCALEXY))
		{
			D3D_VIEWPORT2* Viewport = D3D_GetViewport2();
			for (i=0; i<4; i++)
			{
				Sprite->Vertices2d[i].sx = 
					Viewport->dwX + (Sprite->Vertices2d[i].sx * Viewport->dwWidth);
				Sprite->Vertices2d[i].sy = 
					Viewport->dwY + (Sprite->Vertices2d[i].sy * Viewport->dwHeight);
			}
		}
		if (Sprite->Flags & SPRITEF_DRAW)
			D3D_DrawPrimitive(D3DPT_TRIANGLESTRIP, D3DFVF_TLVERTEX, Sprite->Vertices2d, 4, 0);
		if (Sprite->Flags & SPRITEF_RESETRENDERSTATE)
			D3D_SetRenderState(D3DRENDERSTATE_ZFUNC, D3DCMP_LESSEQUAL);
	}
	else
	{
		if (Sprite->Flags & SPRITEF_SETDEFAULTCOLOR)
			Sprite->Vertices3d[0].color = Sprite->Vertices3d[1].color = 
			Sprite->Vertices3d[2].color = Sprite->Vertices3d[3].color = 0xffffffff;
		else if (Sprite->Flags & SPRITEF_SETCOLOR)
			Sprite->Vertices3d[0].color = Sprite->Vertices3d[1].color = 
			Sprite->Vertices3d[2].color = Sprite->Vertices3d[3].color = Sprite->Color;
		if (Sprite->Flags & SPRITEF_SETDEFAULTUV)
		{
			Sprite->Vertices3d[0].tu = Sprite->Vertices3d[1].tu = 
			Sprite->Vertices3d[0].tv = Sprite->Vertices3d[2].tv = 0.0f;
			Sprite->Vertices3d[1].tv = Sprite->Vertices3d[2].tu = 
			Sprite->Vertices3d[3].tu = Sprite->Vertices3d[3].tv = 1.0f;
		}
		else if (Sprite->Flags & SPRITEF_SETUV)
		{
			Sprite->Vertices3d[0].tu = Sprite->Vertices3d[1].tu = Sprite->u0;
			Sprite->Vertices3d[0].tv = Sprite->Vertices3d[2].tv = Sprite->v0;
			Sprite->Vertices3d[2].tu = Sprite->Vertices3d[3].tu = Sprite->u1;
			Sprite->Vertices3d[1].tv = Sprite->Vertices3d[3].tv = Sprite->v1;
		}
		if (Sprite->Flags & SPRITEF_BILLBOARD)
		{
			Vector3 Width, Height;
			VectorScale(Width, (*Sprite->Matrix)[0], Sprite->Width);
			VectorScale(Height, (*Sprite->Matrix)[1], Sprite->Height);
			VectorSub(&Sprite->Vertices3d[0].x, Height, Width);
			VectorAdd(&Sprite->Vertices3d[2].x, Width, Height);
			VectorSub(&Sprite->Vertices3d[3].x, Width, Height);
			VectorNegate2(Width);
			VectorSub(&Sprite->Vertices3d[1].x, Width, Height);
			for (i=0; i<4; i++)
				VectorAdd2(&Sprite->Vertices3d[i].x, *Sprite->Position);
		}
		else
		{
			if (Sprite->Flags & SPRITEF_SETDEFAULTZW)
			{
				Sprite->Vertices3d[0].z = Sprite->Vertices3d[1].z = 
				Sprite->Vertices3d[2].z = Sprite->Vertices3d[3].z = 0.0f;
			}
			if (Sprite->Flags & SPRITEF_SETXY)
			{
				Sprite->Vertices3d[0].x = Sprite->Vertices3d[1].x = Sprite->x0;
				Sprite->Vertices3d[0].y = Sprite->Vertices3d[2].y = Sprite->y0;
				Sprite->Vertices3d[2].x = Sprite->Vertices3d[3].x = Sprite->x1;
				Sprite->Vertices3d[1].y = Sprite->Vertices3d[3].y = Sprite->y1;
			}
		}
		if (Sprite->Flags & SPRITEF_DRAW)
			D3D_DrawPrimitive(D3DPT_TRIANGLESTRIP, D3DFVF_LVERTEX, Sprite->Vertices3d, 4, 0);
	}
	if (Sprite->Flags & SPRITEF_RESETRENDERSTATE)
		D3D_SetRenderState(D3DRENDERSTATE_ALPHABLENDENABLE, false);
}
void Resources_Create(char* szFileName)
{
	PakHeader_t* pPakFile = (PakHeader_t*)LZW_decode(szFileName);
	if (pPakFile->pakId != PAK_SIGNATURE)
		Error("Resources_Create(%s)", szFileName);
	Resources_LoadBitmaps(pPakFile);
	Resources_LoadMeshes(pPakFile);
	Resources_LoadSounds(pPakFile);
	Sys_MemFree(pPakFile);
}
