////////////////////////////////////////////////////////////////////////////
//	write your comments to : loadall@hotmail.com
//  chat with the author (loadall) on IRCNet, channel #coders
////////////////////////////////////////////////////////////////////////////
#include "game.hpp"
#define POWERUPF_INUSE 1
#define POWERUPF_NODRAWFLARES 2
void PowerUp_Release(PowerUp_t* PowerUp)
{
	Sys_memClear(PowerUp, sizeof(*PowerUp));
}
PowerUp_t* PowerUps_CheckCollision(Vector3 Position)
{
	int i;
	Vector3 Mins, Maxs;
	PowerUp_t* PowerUp = gs->PowerUps;
	for (i=0; i<MAX_POWERUPS; i++, PowerUp++)
	{
		if (!(PowerUp->Flags & POWERUPF_INUSE))
			continue;
		Mesh_GetBBox(Mesh_Get(PowerUp->Mesh), Mins, Maxs, 
					 PowerUp->Matrix, 0, 0, PowerUp->Scaling);
		if (W_CollidePoint2BBox(Position, Mins, Maxs))
			return PowerUp;
	}
	return 0;
}
void PowerUps_UpdateAll()
{
	PowerUp_t* PowerUp = gs->PowerUps;
	int i, j;
	Matrix4x3 Mat;
	Vector3 v;
	for (i=0; i<MAX_POWERUPS; i++, PowerUp++)
	{
		if (!(PowerUp->Flags & POWERUPF_INUSE))
			continue;
		VectorScale(v, PowerUp->AngularVelocity, gs->Fps.FrameTime);
		Matrix_Set(Mat, 0, v, 0);
		Matrix_MultiplyRotations(PowerUp->Matrix, Mat, PowerUp->Matrix);
		PowerUp->Matrix[3][2] -= (gs->Speed * gs->Fps.FrameTime);
		if (PowerUp->Matrix[3][2] < -10.0f)
		{	
			PowerUp_Release(PowerUp);
			continue;
		}
		Light_Add(PowerUp->Matrix[3], 0xffffff00);
		PowerUp->Flags &= ~POWERUPF_NODRAWFLARES;
		PowerUpFlare_t* PowerUpFlare = PowerUp->Flares;
		for (j=0; j<NUM_POWERUP_FLARES; j++)
		{
			VectorScale(v, PowerUpFlare->AngularVelocity, gs->Fps.FrameTime);
			VectorAdd2(PowerUpFlare->Angles, v);
			M_AnglesVectorMod(PowerUpFlare->Angles);
			Matrix_Set(Mat, PowerUp->Matrix[3], PowerUpFlare->Angles, 0);
			VectorSet(v, 10.0f, 0.0f, 0.0f);
			VectorTransform(Mat, PowerUpFlare->Position, v);
			PowerUpFlare++;
		}
	}
}
void PowerUps_DrawAll()
{
	PowerUp_t* PowerUp = gs->PowerUps;
	int i, j;
	Sprite_t Sprite;
	for (i=0; i<MAX_POWERUPS; i++, PowerUp++)
	{
		if (!(PowerUp->Flags & POWERUPF_INUSE))
			continue;
		Mesh_Draw(Mesh_Get(PowerUp->Mesh), PowerUp->Matrix, PowerUp->Scaling);
	}
	D3D_SetRenderState(D3DRENDERSTATE_ZWRITEENABLE, false);
	D3D_SetRenderState(D3DRENDERSTATE_CULLMODE, D3DCULL_NONE);
	Sprite.SrcBlend = D3DBLEND_ONE;
	Sprite.DestBlend = D3DBLEND_ONE;
	Sprite.Texture = "flare_blue.gif";
	Sprite.Flags = (SPRITEF_INITRENDERSTATE
					| SPRITEF_SETIDENTITYMATRIX
					| SPRITEF_SETTEXTURE
					| SPRITEF_SETDEFAULTUV);
	Sprite_Draw(&Sprite);
	Sprite.Flags = (SPRITEF_DRAW
					| SPRITEF_BILLBOARD
					| SPRITEF_SETCOLOR);
	Sprite.Matrix = &gs->Camera;
	Sprite.Width = 8.0f;
	Sprite.Height = 8.0f;
	PowerUp = gs->PowerUps;
	for (i=0; i<MAX_POWERUPS; i++, PowerUp++)
	{
		if ((!(PowerUp->Flags & POWERUPF_INUSE))
			|| (PowerUp->Flags & POWERUPF_NODRAWFLARES))
			continue;
		PowerUpFlare_t* PowerUpFlare = PowerUp->Flares;
		for (j=0; j<NUM_POWERUP_FLARES; j++)
		{
			Sprite.Position = &PowerUpFlare->Position;
			Sprite.Color = PowerUpFlare->Color;
			Sprite_Draw(&Sprite);
			PowerUpFlare++;
		}
	}
	Sprite.Flags = SPRITEF_RESETRENDERSTATE;
	Sprite_Draw(&Sprite);
	D3D_SetRenderState(D3DRENDERSTATE_ZWRITEENABLE, true);
	D3D_SetRenderState(D3DRENDERSTATE_CULLMODE, D3DCULL_CW);
}
PowerUp_t* PowerUp_Create()
{
	PowerUp_t* PowerUp = gs->PowerUps;
	int i;
	for (i=0; i<MAX_POWERUPS; i++)
		if (!(PowerUp->Flags & POWERUPF_INUSE))
			break;
		else
			PowerUp++;
	if (i == MAX_POWERUPS)
		Error("PowerUp_Create()");
	PowerUp->Flags = (POWERUPF_INUSE | POWERUPF_NODRAWFLARES);
	Matrix_SetIdentity(PowerUp->Matrix);
	PowerUp->Mesh =  "PowerUp1.OBJ";
	VectorSet(PowerUp->Scaling, 1.0f, 1.0f, 1.0f);
	VectorClear(PowerUp->AngularVelocity);
	PowerUpFlare_t* PowerUpFlare = PowerUp->Flares;
	for (i=0; i<NUM_POWERUP_FLARES; i++)
	{
		VectorRandom(PowerUpFlare->Angles);
		VectorScale2(PowerUpFlare->Angles, 2.0f * F_PI);
		PowerUpFlare->Color = MAKE_RGBA(0.6f + 0.4f*M_Rand(), 
										0.6f + 0.4f*M_Rand(), 
										0.6f + 0.4f*M_Rand(), 
										1.0f);
		VectorRandom(PowerUpFlare->AngularVelocity);
		VectorScale2(PowerUpFlare->AngularVelocity, 2.0f * F_PI);
		PowerUpFlare++;
	}
	return PowerUp;
}
