////////////////////////////////////////////////////////////////////////////
//	write your comments to : loadall@hotmail.com
//  chat with the author (loadall) on IRCNet, channel #coders
////////////////////////////////////////////////////////////////////////////
///////////////
int AddBitmapFile(int hOutputFile, char* szSrcFile);
///////////////
int AddMeshFile(int hOutputFile, char* szSrcFile);
///////////////
int AddSoundFile(int hOutputFile, char* szSrcFile);
///////////////
void LZW_encode(char* szDest, char* szSrc);
///////////////
char* LZW_decode(char* szSrcFile);
///////////////
#define MAKE_CODE(a, b, c, d) ((a<<0)|(b<<8)|(c<<0x10)|(d<<0x18))
#define WAV_SIGNATURE MAKE_CODE('W', 'A', 'V', 'E')
typedef struct {
	int Signature;
	int DataSize;
    unsigned short wFormatTag;
    unsigned short nChannels; 
    unsigned int nSamplesPerSec;    
	unsigned int nAvgBytesPerSec;  
	unsigned short nBlockAlign; 
    unsigned short wBitsPerSample;    
	unsigned short cbSize;
} SoundHeader_t;
///////////////
#define BMP_SIGNATURE MAKE_CODE('B', 'M', 'P', '0')
typedef struct {
	int id;
	int width;
	int height;
	int mipMapCount;
	char palette [0x100][4];
}BitmapHeader_t;
///////////////
#define MESH_SIGNATURE MAKE_CODE('M', 'E', 'S', 'H')
typedef struct {
	char textureName[0x80];
	unsigned short numTriangles;
} TriGroupDesc_t;
typedef struct {
	unsigned short vertexIndices[3][2];
} Triangle_t;
typedef struct {
	float coords[2];
} TexCoords_t;
typedef struct {
	float coords[3];
} VertexCoords_t;
/*
  format du mesh :
	int id;
	int numTexCoords;
	TexCoords_t texCoords[numTexCoords];
	int	numVertices;
	VertexCoords_t vertices[numVertices];
	int numSubMeshes;
	SubMeshDesc_t subMeshes[numSubMeshes];
	int numTriangles;
	int numTriGroups;
	TriGroupDesc_t triGroup01;
	Triangle_t tri01;
	Triangle_t tri02;
	Triangle_t tri03;
		(...)
	Triangle_t tri0[triGroup01.numTriangles];
	TriGroupDesc_t triGroup02;
	Triangle_t tri01;
	Triangle_t tri02;
	Triangle_t tri03;
		(...)
	Triangle_t tri0[triGroup02.numTriangles];
		(...)
*/
///////////////
#define PAK_SIGNATURE MAKE_CODE('P', 'A', 'C', 'K')
#define DIRECTORY_BITMAP 0
#define DIRECTORY_MESH   1
#define DIRECTORY_SOUND 2
#define MAX_PAK_DIRS		 3
#define MAX_DIR_FILES	   600
#define BITMAPS_DIR_NAME	"Bitmap"
#define MESHES_DIR_NAME		"Mesh"
#define SOUNDS_DIR_NAME     "Sound"
/*
	struture du fichier *.pak :
	PakHeader_t pakHeader;
		(...data...)
	DirHeader_t dirHeader01;
	DirFile_t dirFiles01[dirHeader01.numFiles];
	DirHeader_t dirHeader02;
	DirFile_t dirFiles01[dirHeader02.numFiles];
			(...)
	DirHeader_t dirHeader0n; // ou  n = pakHeader.numDirs
	DirFile_t dirFiles0n[dirHeader0n.numFiles];
	
*/
typedef struct {
	int  pakId;
	int	 numDirs;
	int	 dirOffset;
	int	 dirSize;
} PakHeader_t;
typedef struct {
	char szDirName[0x10];
	int	 numFiles;
} DirHeader_t;
typedef struct {
	char szFileName[0x80];
	int	 offset;
	int	 size;
} DirFile_t;

typedef struct {
	char         szBitmapsDir[0x100];
	char         szMeshesDir[0x100];
	char         szSoundsDir[0x100];
	char		 szOutputDir[0x100];
	char         szOutputFile[0x100];
	int	         currentDirectory;
	int			 hOutputFile;
	int			 outputOffset;
	PakHeader_t  pakHeader;
	DirHeader_t	 dirHeaders[MAX_PAK_DIRS];
	DirFile_t	 dirFiles[MAX_PAK_DIRS][MAX_DIR_FILES];
} PakStruc_t;

