////////////////////////////////////////////////////////////////////////////
//	write your comments to : loadall@hotmail.com
//  chat with the author (loadall) on IRCNet, channel #coders
////////////////////////////////////////////////////////////////////////////
#include <windows.h>
#include "system.hpp"
#include "pak.hpp"

PakStruc_t* pPak;

void Pak_ParseDir(char* szDirName, char* szSubDirName)
{
	HANDLE hSearch;
	WIN32_FIND_DATA findData;
	char buffer[0x100];
	char buffer2[0x100];
	DirFile_t* pFileHeader;
	int	size;
	Sys_logPrintf("**** %s ****",szDirName);
	SetCurrentDirectory(szDirName);
	hSearch = FindFirstFile("*.*",&findData);
	if (hSearch == INVALID_HANDLE_VALUE)
		return;
	do
	{
		if (findData.cFileName[0] == '.') ;
		else if (findData.dwFileAttributes == FILE_ATTRIBUTE_DIRECTORY)
		{
			Sys_sprintf(buffer,"%s%s\\",szDirName,findData.cFileName);
			Sys_sprintf(buffer2,"%s%s\\",szSubDirName,findData.cFileName);
			Pak_ParseDir(buffer,buffer2);
		}
		else if ((pPak->currentDirectory == DIRECTORY_BITMAP)
		    && (findData.cFileName[Sys_strlen(findData.cFileName)-6] == '_')
		    && (findData.cFileName[Sys_strlen(findData.cFileName)-5] >= '0')
		    && (findData.cFileName[Sys_strlen(findData.cFileName)-5] <= '9'));
		else if ((pPak->currentDirectory == DIRECTORY_BITMAP)
		    && (Sys_strcmp(&findData.cFileName[Sys_strlen(findData.cFileName)-3],"pal")));
		else
		{
			Sys_sprintf(buffer,"%s%s",szSubDirName,findData.cFileName);
			Sys_logPrintf(buffer);
			pFileHeader = &pPak->dirFiles[pPak->currentDirectory][pPak->dirHeaders[pPak->currentDirectory].numFiles++];
			if (pPak->dirHeaders[pPak->currentDirectory].numFiles > MAX_DIR_FILES)
				Error("Il y trop de fichiers de ce type (maximum = %i)", MAX_DIR_FILES);
			pFileHeader->offset = pPak->outputOffset;
			Sys_strcpy(pFileHeader->szFileName,buffer);
			Sys_sprintf(buffer2,"%s%s",szDirName,findData.cFileName);
			switch (pPak->currentDirectory)
			{
				case DIRECTORY_BITMAP:
					size = AddBitmapFile(pPak->hOutputFile,buffer2);
					break;
				case DIRECTORY_MESH:
					size = AddMeshFile(pPak->hOutputFile,buffer2);
					break;
				case DIRECTORY_SOUND:
					size = AddSoundFile(pPak->hOutputFile,buffer2);
					break;		
			}
			pFileHeader->size = size;
			pPak->outputOffset += size;
		}
	} while (FindNextFile(hSearch,&findData));
	FindClose(hSearch);
	Sys_logPrintf("**** ****");
}
void Pak_Init()
{
	pPak = (PakStruc_t*)Sys_HeapAllocTemp(sizeof(PakStruc_t));
	GetPrivateProfileString("Directories",BITMAPS_DIR_NAME,"",\
			pPak->szBitmapsDir,sizeof(pPak->szBitmapsDir),"pak.ini");
	GetPrivateProfileString("Directories",MESHES_DIR_NAME,"",\
			pPak->szMeshesDir, sizeof(pPak->szMeshesDir),"pak.ini");
	GetPrivateProfileString("Directories",SOUNDS_DIR_NAME,"",\
			pPak->szSoundsDir, sizeof(pPak->szSoundsDir),"pak.ini");
	GetCurrentDirectory(sizeof(pPak->szOutputDir),pPak->szOutputDir);
	Sys_strcpy(pPak->szOutputFile,pPak->szOutputDir);
	Sys_strcat(pPak->szOutputFile, "\\data.pak");
	pPak->hOutputFile = Sys_FileCreate(pPak->szOutputFile);
	pPak->pakHeader.numDirs=0;
	Sys_FileWrite(pPak->szOutputFile,pPak->hOutputFile,\
		&pPak->pakHeader,sizeof(PakHeader_t));
	pPak->outputOffset = sizeof(PakHeader_t);
}
void Pak_CleanUp()
{
	int numFiles, i;
	pPak->pakHeader.pakId = PAK_SIGNATURE;
	for (i = numFiles = 0;i < pPak->pakHeader.numDirs;i++)
			numFiles += pPak->dirHeaders[i].numFiles;
	pPak->pakHeader.dirSize = (pPak->pakHeader.numDirs * sizeof(DirHeader_t)) \
							+ (numFiles * sizeof(DirFile_t));
	pPak->pakHeader.dirOffset = pPak->outputOffset;
	Sys_FileSeekBegin(pPak->hOutputFile, 0);
	Sys_FileWrite(pPak->szOutputFile,pPak->hOutputFile,\
			   &pPak->pakHeader,sizeof(PakHeader_t));
	Sys_FileSeekBegin(pPak->hOutputFile,pPak->outputOffset);
	for (i = 0;i < pPak->pakHeader.numDirs;i++)
	{
		Sys_FileWrite(pPak->szOutputFile,pPak->hOutputFile,\
			&pPak->dirHeaders[i],\
			sizeof(DirHeader_t));
		Sys_FileWrite(pPak->szOutputFile,pPak->hOutputFile,\
			&pPak->dirFiles[i][0],\
			sizeof(DirFile_t)*pPak->dirHeaders[i].numFiles);
	}
	Sys_FileClose(pPak->hOutputFile);
	SetCurrentDirectory(pPak->szOutputDir);
	LZW_encode(pPak->szOutputFile, pPak->szOutputFile);
	Sys_HeapFreeTemp(pPak);
}
void Pak_Parse()
{
	pPak->currentDirectory = DIRECTORY_BITMAP;
	Sys_logPrintf("[%s]",BITMAPS_DIR_NAME);
	pPak->dirHeaders[DIRECTORY_BITMAP].numFiles = 0;
	Sys_strcpy(pPak->dirHeaders[DIRECTORY_BITMAP].szDirName,\
			   BITMAPS_DIR_NAME);
	Pak_ParseDir(pPak->szBitmapsDir, "");

	pPak->currentDirectory = DIRECTORY_MESH;
	Sys_logPrintf("[%s]",MESHES_DIR_NAME);
	pPak->dirHeaders[DIRECTORY_MESH].numFiles = 0;
	Sys_strcpy(pPak->dirHeaders[DIRECTORY_MESH].szDirName,\
			   MESHES_DIR_NAME);
	Pak_ParseDir(pPak->szMeshesDir, "");

	pPak->currentDirectory = DIRECTORY_SOUND;
	Sys_logPrintf("[%s]",SOUNDS_DIR_NAME);
	pPak->dirHeaders[DIRECTORY_SOUND].numFiles = 0;
	Sys_strcpy(pPak->dirHeaders[DIRECTORY_SOUND].szDirName,\
			   SOUNDS_DIR_NAME);
	Pak_ParseDir(pPak->szSoundsDir, "");

	pPak->pakHeader.numDirs = 3;
}
void Pak()
{
	Pak_Init();
	Pak_Parse();
	Pak_CleanUp();
}
