////////////////////////////////////////////////////////////////////////////
//	write your comments to : loadall@hotmail.com
//  chat with the author (loadall) on IRCNet, channel #coders
////////////////////////////////////////////////////////////////////////////
#include "game.hpp"

GameState_t* gs = 0;

void Scene_Update()
{
	float ElapsedTime = gs->Fps.GameTime - gs->Fps.StartTime;
	if ((ElapsedTime > 5.0f) && (gs->Flags & GAMEF_SOUND_CROWD))
	{
		Sound_Stop("CROWD.WAV", 0);
		gs->Flags &= ~GAMEF_SOUND_CROWD;
	}
	if (gs->Flags & GAMEF_DRAWHELP)
	{
		if (ElapsedTime > 4.0f)
		{
			gs->Speed = 140.0f;
			gs->Flags = GAMEF_SOUND_CROWD;
		}
		else if (ElapsedTime > 3.0f)
		{
			if (gs->Flags & GAMEF_SOUND_THREE)
			{
				gs->Flags &= ~GAMEF_SOUND_THREE;
				Sound_Play("GO.WAV", 0, 0, 0, 0);
			}
		}
		else if (ElapsedTime > 2.0f)
		{
				if (gs->Flags & GAMEF_SOUND_TWO)
				{
					gs->Flags &= ~GAMEF_SOUND_TWO;
					gs->Flags |= GAMEF_SOUND_THREE;
					Sound_Play("THREE.WAV", 0, 0, 0, 0);
				}
		}
		else if (ElapsedTime > 1.0f)
		{
				if (gs->Flags & GAMEF_SOUND_ONE)
				{
					gs->Flags &= ~GAMEF_SOUND_ONE;
					gs->Flags |= GAMEF_SOUND_TWO;
					Sound_Play("TWO.WAV", 0, 0, 0, 0);
				}
		}
		else if (!(gs->Flags & GAMEF_SOUND_ONE))
		{
			gs->Flags |= GAMEF_SOUND_ONE;
			Sound_Play("ONE.WAV", 0, 0, 0, 0);
		}
	}
	Lights_UpdateAll();
	ThunderBolts_UpdateAll();
	FPS_Update();
	Player_Update();
	Camera_Update();
	BlockWalls_UpdateAll();
	ProximityBombs_UpdateAll();
	PowerUps_UpdateAll();
	Lasers_UpdateAll();
	ScreenBlend_Update();
	VClips_UpdateAll();
	Debris_UpdateAll();
	Ricochets_UpdateAll();
	Shop_Update();
}
void Scene_Draw()
{
	Tunnel_Draw();
	BlockWalls_DrawAll();
	ProximityBombs_DrawAll();
	PowerUps_DrawAll();
	Debris_DrawAll();
	VClips_DrawAll();
	Ricochets_DrawAll();
	ThunderBolts_DrawAll();
	Lasers_DrawAll();
	Lights_DrawAll();
	Player_DrawScore();
	Shop_Draw();
	FPS_Draw();
	ScreenBlend_Draw();
	Help_Draw();
}
void Scene_Init()
{
	gs = (GameState_t*) Sys_HeapAlloc(sizeof(*gs));
	gs->Speed = 5.0f;
	gs->Flags = (GAMEF_DRAWHELP|GAMEF_NODRAWSCORE|GAMEF_SOUND_CROWD);
	Sound_Play("CROWD.WAV", 0, 0, 0, SOUND_LOOPED);
	FPS_Init();
	Camera_Init();
	Player_Init();
	Tunnel_Init();
	BlockWalls_InitAll();
}
void run()
{
	Vector3 v;
	while ((Sys_pumpMsg()) && (!Keyboard[DIK_ESCAPE]))
	{
		Input_Update();
		VectorSet(v, 0.0f, 0.0f, -gs->Speed*gs->Fps.FrameTime);
		Sound_UpdateAll(v);
		Scene_Update();
//		D3D_ViewportClear2(1,&(D3D_GetViewport2())->dwX,D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER,0xffff0000,1.0f,0);
		D3D_BeginScene();
		Scene_Draw();	
		D3D_EndScene();
		D3D_Flip();
	}
}
void init()
{
//	Sys_Init(SYSF_DOPAK|SYSF_DOD3D|SYSF_DOSOUND);
//	Sys_Init(SYSF_DOSOUND);
	Sys_Init(SYSF_DOD3D|SYSF_DOSOUND);
//	Sys_Init(SYSF_DOD3D);
//	Sys_Init(0);
//	Sys_Init(SYSF_DOD3D|SYSF_DOPAK);

	D3D_SetRenderState(D3DRENDERSTATE_DITHERENABLE, true);
    D3D_SetRenderState(D3DRENDERSTATE_ZFUNC,D3DCMP_LESSEQUAL);
    D3D_SetRenderState(D3DRENDERSTATE_ZWRITEENABLE, true);
	D3D_SetRenderState(D3DRENDERSTATE_CULLMODE,D3DCULL_CW);
	D3D_SetTextureStageState(0, D3DTSS_ADDRESS, D3DTADDRESS_WRAP);

	D3D_SetRenderState(D3DRENDERSTATE_FOGENABLE, false);
	D3D_SetRenderState(D3DRENDERSTATE_COLORKEYENABLE,false);
	D3D_SetRenderState(D3DRENDERSTATE_ALPHABLENDENABLE, false);

	D3D_SetTextureStageState(0,D3DTSS_ALPHAARG1, D3DTA_TEXTURE);
	D3D_SetTextureStageState(0,D3DTSS_ALPHAARG2, D3DTA_DIFFUSE);
	D3D_SetTextureStageState(0,D3DTSS_ALPHAOP, D3DTOP_MODULATE);
	D3D_SetTextureStageState(0,D3DTSS_COLORARG1,D3DTA_TEXTURE);
	D3D_SetTextureStageState(0,D3DTSS_COLORARG2,D3DTA_DIFFUSE);
	D3D_SetTextureStageState(0,D3DTSS_COLOROP,D3DTOP_MODULATE);
	
	D3D_SetTextureStageState(0,D3DTSS_MINFILTER,D3DTFN_LINEAR);
	D3D_SetTextureStageState(0,D3DTSS_MAGFILTER,D3DTFG_LINEAR);
    D3D_SetTextureStageState(0,D3DTSS_MIPFILTER,D3DTFP_LINEAR);

	D3D_SetRenderState(D3DRENDERSTATE_ALPHATESTENABLE,true);
	D3D_SetRenderState(D3DRENDERSTATE_ALPHAREF, 7);
	D3D_SetRenderState(D3DRENDERSTATE_ALPHAFUNC, D3DCMP_GREATER);
	
	float matProj[16];
	Matrix_SetProjectionTransform(matProj, F_PI / 2.0f, 1.0f, 1.0f, 1000.0f);
	D3D_SetTransform(D3DTRANSFORMSTATE_PROJECTION, matProj);
	M_Randomize(Sys_GetTickCount());
	Scene_Init();
}
void release()
{
}
