////////////////////////////////////////////////////////////////////////////
//	write your comments to : loadall@hotmail.com
//  chat with the author (loadall) on IRCNet, channel #coders
////////////////////////////////////////////////////////////////////////////
#include "game.hpp"

#define LASERF_INUSE 1
#define LASER_ZRANGE 700.0f

void Laser_Release(Laser_t* Laser)
{
	Sys_memClear(Laser, sizeof(*Laser));
}
void Lasers_UpdateAll()
{
	Laser_t* Laser = gs->Lasers;
	int i;
	Vector3 v, LastPosition;
	ProximityBomb_t* ProxBomb;
	for (i=0; i<MAX_LASERS; i++, Laser++)
	{
		if (!(Laser->Flags & LASERF_INUSE))
			continue;
		VectorCopy(LastPosition, Laser->Position);
		VectorScale(v, Laser->Velocity, gs->Fps.FrameTime);
		VectorAdd2(Laser->Position, v);
		if (Laser->Position[2] > LASER_ZRANGE)
		{
			Laser_Release(Laser);
			continue;
		}
		if (BlockWalls_CheckCollision(Laser->Position))
		{
			VClip_Create(LastPosition, 15.0f, 15.0f, 1.0f + 20.0f/gs->Speed, VClip_Explosion01, false);
			Ricochet_Create(LastPosition);
			Sound_Play("MImpact.wav",LastPosition, 0, 0, SOUND_3D);
			Laser_Release(Laser);
			continue;
		}
		if (ProxBomb = ProximityBombs_CheckCollision(Laser->Position))
		{
			VClip_Create(LastPosition, 20.0f, 20.0f, 2.0f + 20.0f/gs->Speed, VClip_Explosion02, false);
			Sound_Play("EXPLOSION.WAV",LastPosition, 0, 0, SOUND_3D);
			Debris_CreateFromMesh(ProxBomb->Mesh, ProxBomb->Matrix, ProxBomb->Scaling);
			ProximityBomb_Release(ProxBomb);
			Laser_Release(Laser);
			Player_AddToScore(2);
			continue;
		}
		Light_Add(Laser->Position, 0xffffffff);
	}
}
void Lasers_DrawAll()
{
	Laser_t* Laser = gs->Lasers;
	Sprite_t Sprite;
	Sprite.Texture = "acid-front.gif";
	Sprite.SrcBlend = D3DBLEND_ONE;
	Sprite.DestBlend = D3DBLEND_ONE;
	Sprite.Flags = (SPRITEF_INITRENDERSTATE
					| SPRITEF_SETIDENTITYMATRIX
					| SPRITEF_SETTEXTURE
					| SPRITEF_SETDEFAULTUV
					| SPRITEF_SETDEFAULTCOLOR);
	Sprite_Draw(&Sprite);
	Sprite.Flags = (SPRITEF_BILLBOARD
					| SPRITEF_DRAW);
	Sprite.Matrix = &gs->Camera;
	for (int i=0; i<MAX_LASERS; i++, Laser++)
	{
		if (!(Laser->Flags & LASERF_INUSE))
			continue;
		Sprite.Position = &Laser->Position;
		Sprite.Width = Laser->Width;
		Sprite.Height = Laser->Height;
		Sprite_Draw(&Sprite);
	}
	Sprite.Flags = SPRITEF_RESETRENDERSTATE;
	Sprite_Draw(&Sprite);
}
Laser_t* Laser_Create()
{
	Laser_t* Laser = gs->Lasers;
	int i;
	for (i=0; i<MAX_LASERS; i++, Laser++)
		if (!(Laser->Flags & LASERF_INUSE))
			break;
	if (i == MAX_LASERS)
		Error("Laser_Create()");
	Laser->Flags = LASERF_INUSE;
	return Laser;
}
