////////////////////////////////////////////////////////////////////////////
//	write your comments to : loadall@hotmail.com
//  chat with the author (loadall) on IRCNet, channel #coders
////////////////////////////////////////////////////////////////////////////
#include "game.hpp"
#define DEBRISF_INUSE 1
Debris_t* Debris_Create()
{
	Debris_t* Debris = gs->Debris;
	Vector3 Velocity, AngularVelocity;
	int i;
	for (i=0; i<MAX_DEBRIS; i++, Debris++)
		if (!(Debris->Flags & DEBRISF_INUSE))
			break;
	if (i == MAX_DEBRIS)
		Error("Debris_Create()");
	Sys_memClear(Debris, sizeof(*Debris));
	Debris->Flags = DEBRISF_INUSE;
	VectorRandom(Velocity);
	VectorRandom(AngularVelocity);
	Velocity[1]+=1.0f;
	VectorScale(Debris->Velocity, Velocity, 10.0f);
	VectorScale(Debris->AngularVelocity, AngularVelocity, 2.5f);
	return Debris;
}
void Debris_Release(Debris_t* Debris)
{
	Sys_memClear(Debris, sizeof(*Debris));
}
void Debris_CreateFromMesh(char* MeshName, Matrix4x3 Matrix, Vector3 Scaling)
{
	int i, j, k, NumTriangles;
	Debris_t* Debris;
	TriGroup_t* TriangleGroup;
	Matrix4x3 MatrixMeshToWorld;
	Mesh_t* Mesh = Mesh_Get(MeshName);
	char* Src = Mesh->pTriangles;
	if (Scaling)
		Matrix_Scale(MatrixMeshToWorld, Matrix, Scaling);
	else
		Matrix_Copy(MatrixMeshToWorld, Matrix);
	for (i=0; i<Mesh->NumTriGroups; i++)
	{
		TriangleGroup = (TriGroup_t*)Src;
		Src += sizeof(*TriangleGroup);
		NumTriangles = TriangleGroup->NumVertices / 3; 
		for (j=0; j<NumTriangles; j++)
		{
			Debris = Debris_Create();
			Debris->Texture = TriangleGroup->pTexture;
			Sys_memCopy(Debris->Mesh, Src, 3*sizeof(LVERTEX));
			for (k=0; k<3; k++)
				VectorTransform(MatrixMeshToWorld, &Debris->Mesh[k].x, &Debris->Mesh[k].x);
			Src += (3 * sizeof(LVERTEX));
		}
	}
}
void Debris_UpdateAll()
{
	Debris_t* Debris = gs->Debris;
	int i, j;
	Matrix4x3 Mat;
	Vector3 Position, DeltaPosition, DeltaAngle;
	for (i=0; i<MAX_DEBRIS; i++, Debris++)
	{
		if (!(Debris->Flags & DEBRISF_INUSE))
			continue;
		VectorAdd(Position, &Debris->Mesh[0].x, &Debris->Mesh[1].x);
		VectorAdd2(Position, &Debris->Mesh[2].x);
		VectorScale2(Position, 1.0f/3.0f);
		VectorCopy(DeltaPosition, Debris->Velocity);
		DeltaPosition[2] -= gs->Speed;
		VectorScale2(DeltaPosition, gs->Fps.FrameTime);
		VectorScale(DeltaAngle, Debris->AngularVelocity, gs->Fps.FrameTime);
		Matrix_Set(Mat, Position, DeltaAngle, 0);
		VectorAdd2(Position, DeltaPosition);
		for (j=0; j<3; j++)
		{
			VectorInverseTransform(Mat, &Debris->Mesh[j].x, &Debris->Mesh[j].x);
			VectorAdd2(&Debris->Mesh[j].x, Position);
		}
		if (Position[2] < -10.0f)
			Debris_Release(Debris);
	}
}
void Debris_DrawAll()
{
	Debris_t* Debris = gs->Debris;
	int i;
	D3D_SetTransform(D3DTRANSFORMSTATE_WORLD, (float*)MatrixIdentity);
	D3D_SetRenderState(D3DRENDERSTATE_CULLMODE, D3DCULL_NONE);
	for (i=0; i<MAX_DEBRIS; i++, Debris++)
	{
		if (!(Debris->Flags & DEBRISF_INUSE))
			continue;
		D3D_SetTexture(0, Debris->Texture);
		D3D_DrawPrimitive(D3DPT_TRIANGLELIST, D3DFVF_LVERTEX, Debris->Mesh, 3, 0);
	}
	D3D_SetRenderState(D3DRENDERSTATE_CULLMODE, D3DCULL_CW);
}
