////////////////////////////////////////////////////////////////////////////
//	write your comments to : loadall@hotmail.com
//  chat with the author (loadall) on IRCNet, channel #coders
////////////////////////////////////////////////////////////////////////////
#define D3D_INCLUDED
#include <ddraw.h>
#include <d3d.h>
#include "system.hpp"

#define SCREEN_WIDTH 640
#define SCREEN_HEIGHT 480
#define SCREEN_BPP 16

int D3D_doD3D = 0;
IDirect3DDevice3*		pd3dDevice = 0;
IDirect3DViewport3*		pvViewport = 0;
IDirectDraw*			pDD1 = 0;
IDirectDrawSurface4*	pddsPrimary = 0;
IDirectDrawSurface4*    pddsBackBuffer =0;
IDirectDrawSurface4*	pddsZBuffer = 0;
IDirect3D3*				pD3D = 0;
IDirectDraw4*			pDD4 = 0;
DDCAPS*					pDDrawCaps = 0;
char*					pDriverName = 0;
char*					pDriverDescription = 0;
D3DVIEWPORT2*			pViewportData = 0;
void*					lpCurrentTexture=0; 

void DX_release(IUnknown** ppObject)
{
	if ((*ppObject))
		(*ppObject)->Release();
	(*ppObject) = 0;
}
BOOL WINAPI DDEnumCallback(GUID* lpGUID,
  char* lpDriverDescription,char* lpDriverName,
  void* lpContext)
{
	if (DirectDrawCreate(lpGUID, &pDD1, 0))
		goto fail;
	if (pDD1->QueryInterface(IID_IDirectDraw4,(void**)&pDD4))
		goto fail;
	pDDrawCaps = (DDCAPS*)Sys_HeapAlloc(sizeof(*pDDrawCaps));
	Sys_memClear(pDDrawCaps,sizeof(*pDDrawCaps));
	pDDrawCaps->dwSize = sizeof(*pDDrawCaps);
	if (pDD4->GetCaps(pDDrawCaps, 0))
		goto fail;
	if ((!(pDDrawCaps->dwCaps & DDCAPS_3D)) \
		|| (pDDrawCaps->dwCaps & DDCAPS_NOHARDWARE))
		goto fail;
	pDriverName = (char*)Sys_HeapAlloc(Sys_strlen(lpDriverName) + 1);
	pDriverDescription = (char*)Sys_HeapAlloc(Sys_strlen(lpDriverDescription) + 1);
	Sys_strcpy(pDriverName,lpDriverName);
	Sys_strcpy(pDriverDescription,lpDriverDescription);
	return false;
	fail:
	DX_release((IUnknown**)&pDD4);
	DX_release((IUnknown**)&pDD1);
	return true;
}
HRESULT CALLBACK D3DEnumZBufferCallback(DDPIXELFORMAT* lpDDPixFmt,void* lpContext)
{
	if ((lpDDPixFmt->dwFlags & DDPF_ZBUFFER)\
		&&(lpDDPixFmt->dwZBufferBitDepth > ((DDPIXELFORMAT*)lpContext)->dwZBufferBitDepth))
		Sys_memCopy(lpContext,lpDDPixFmt,sizeof(*lpDDPixFmt));
	return 1;
}
void D3D_Create(int hWnd, int doD3D)
{
	DDSURFACEDESC2 ddsd;
	DDSCAPS2 ddsCaps;
	int depthBufferBitDepth, depthBufferType;
	D3D_doD3D = doD3D;
	pViewportData = (D3DVIEWPORT2*)Sys_HeapAlloc(sizeof(*pViewportData));
	pViewportData->dwSize = sizeof(*pViewportData);
	pViewportData->dwX = 0;
	pViewportData->dwY = 0;
	pViewportData->dwWidth = SCREEN_WIDTH;
	pViewportData->dwHeight = SCREEN_HEIGHT;
	pViewportData->dvClipX = -1.0;
	pViewportData->dvClipY = ((float)pViewportData->dwHeight / (float)pViewportData->dwWidth);
	pViewportData->dvClipWidth = 2.0;
	pViewportData->dvClipHeight = (float)2.0 * pViewportData->dvClipY;
	pViewportData->dvMinZ = 0.0;
	pViewportData->dvMaxZ = 1.0;
	if (!D3D_doD3D)
		return;
	if (DirectDrawEnumerate(DDEnumCallback, 0))
		Error("DirectDrawEnumerate()");
	if (!pDriverName)
		Error(" Aucun driver3d valable trouv");
	Sys_logPrintf("****** D3D_init() ******\r\n\r\n"\
				  "nom du driver : %s \r\ndescription : %s",
				   pDriverName,pDriverDescription);
	if (pDD4->SetCooperativeLevel((HWND)hWnd,\
	(DDSCL_FULLSCREEN+DDSCL_EXCLUSIVE+DDSCL_FPUSETUP+DDSCL_ALLOWREBOOT)))
		Error("DDraw_SetCooperativeLevel()");
	Sys_logPrintf("SetDisplayMode(%i * %i * %i)", SCREEN_WIDTH, SCREEN_HEIGHT, SCREEN_BPP);
	if (pDD4->SetDisplayMode(SCREEN_WIDTH,SCREEN_HEIGHT,SCREEN_BPP,0,0))
		Error("DDraw_SetDisplayMode()");
	Sys_memClear(&ddsd,sizeof(ddsd));
	ddsd.dwSize = sizeof(ddsd);
	ddsd.dwFlags = (DDSD_CAPS|DDSD_BACKBUFFERCOUNT);
	ddsd.ddsCaps.dwCaps = \
	(DDSCAPS_PRIMARYSURFACE|DDSCAPS_3DDEVICE|DDSCAPS_FLIP|DDSCAPS_COMPLEX);
	ddsd.ddsCaps.dwCaps2 = 0;
	ddsd.dwBackBufferCount = 2;
	if (pDD4->CreateSurface(&ddsd,&pddsPrimary,0))
	{
		Sys_memClear(&ddsd,sizeof(ddsd));
		ddsd.dwSize = sizeof(ddsd);
		ddsd.dwFlags = (DDSD_CAPS|DDSD_BACKBUFFERCOUNT);
		ddsd.ddsCaps.dwCaps = \
		(DDSCAPS_PRIMARYSURFACE|DDSCAPS_3DDEVICE|DDSCAPS_FLIP|DDSCAPS_COMPLEX);
		ddsd.ddsCaps.dwCaps2 = 0;
		ddsd.dwBackBufferCount = 1;
		if (pDD4->CreateSurface(&ddsd,&pddsPrimary,0))
			Error("DDraw_CreateSurface(primary)");
		Sys_logPrintf("double-buffered");
	}
	else Sys_logPrintf("triple-buffered");
	ddsCaps.dwCaps = DDSCAPS_BACKBUFFER;
	if (pddsPrimary->GetAttachedSurface(&ddsCaps,&pddsBackBuffer))
		Error("IDirectDrawSurface4_GetAttachedSurface(backbuffer)");
	if (pDD4->QueryInterface(IID_IDirect3D3,(void**)&pD3D))
		Error("DDraw_QueryInterface(Direct3D3)");
	Sys_memClear(&ddsd,sizeof(ddsd));
	ddsd.dwSize = sizeof(ddsd);
	ddsd.dwFlags = (DDSD_CAPS+DDSD_WIDTH+DDSD_HEIGHT+DDSD_PIXELFORMAT);
	ddsd.ddsCaps.dwCaps = (DDSCAPS_ZBUFFER+DDSCAPS_VIDEOMEMORY);
	ddsd.dwWidth = SCREEN_WIDTH;
	ddsd.dwHeight = SCREEN_HEIGHT;
	if (pD3D->EnumZBufferFormats(IID_IDirect3DHALDevice,\
			D3DEnumZBufferCallback,(void*)&ddsd.ddpfPixelFormat))
		Error("D3D3_EnumZBufferFormats()");
	depthBufferBitDepth = ddsd.ddpfPixelFormat.dwZBufferBitDepth;
	if (pDD4->CreateSurface(&ddsd,&pddsZBuffer,0))
		Error("DDraw4_CreateSurface(ZBuffer)");
	if (pddsBackBuffer->AddAttachedSurface(pddsZBuffer))
		Error("DDraw4_AddAttachedSurface(ZBuffer)");
	if (pD3D->CreateDevice(IID_IDirect3DHALDevice,pddsBackBuffer,&pd3dDevice,0))
		Error("D3D3_CreateDevice()");
	if (pD3D->CreateViewport(&pvViewport,0))
		Error("D3D3_CreateViewport()");
	if (pd3dDevice->AddViewport(pvViewport))
		Error("D3DDevice3_AddViewport()");
	if (pvViewport->SetViewport2(pViewportData))
		Error("IViewport3_SetViewport2()");
	if (pd3dDevice->SetCurrentViewport(pvViewport))
		Error("D3DDevice3_SetCurrentViewport()");
    D3DDEVICEDESC ddHwDesc, ddSwDesc;
    ddHwDesc.dwSize = sizeof(D3DDEVICEDESC);
    ddSwDesc.dwSize = sizeof(D3DDEVICEDESC);
    if (pd3dDevice->GetCaps( &ddHwDesc, &ddSwDesc))
		Error("D3DDevice3_GetCaps()");
//    if((ddHwDesc.dpcTriCaps.dwRasterCaps & D3DPRASTERCAPS_WBUFFER))
//		depthBufferType = D3DZB_USEW;
//	else 
		depthBufferType = D3DZB_TRUE;
	Sys_logPrintf("%s %i bit",
		(depthBufferType == D3DZB_TRUE)?"Z-Buffer":"W-Buffer",
		depthBufferBitDepth);
	Sys_logPrintf("\r\n************************");
    D3D_SetRenderState(D3DRENDERSTATE_ZENABLE,depthBufferType);
}
void D3D_Release()
{
	DX_release((IUnknown**)&pvViewport);
	DX_release((IUnknown**)&pd3dDevice);
	DX_release((IUnknown**)&pddsZBuffer);
	DX_release((IUnknown**)&pddsPrimary);
	DX_release((IUnknown**)&pD3D);
	DX_release((IUnknown**)&pDD4);
	DX_release((IUnknown**)&pDD1);
}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
int D3D_SetTexture(int stage, void* lpTexture)
{
	if ((D3D_doD3D) && (lpTexture != lpCurrentTexture))
	{
		lpCurrentTexture = lpTexture;
		return (int)pd3dDevice->SetTexture(stage, (IDirect3DTexture2*)lpTexture);
	}
	else
		return 0;
}
int D3D_SetTransform(int transformStateType, float* pMatrix)
{
	float matrix[4][4];
	Matrix4x3 ViewMatrix;
	switch (transformStateType)
	{
		case D3DTRANSFORMSTATE_WORLD:
			VectorCopy(matrix[0], &pMatrix[3*0]);
			VectorCopy(matrix[1], &pMatrix[3*1]);
			VectorCopy(matrix[2], &pMatrix[3*2]);
			VectorCopy(matrix[3], &pMatrix[3*3]);
			matrix[0][3] = matrix[1][3] = matrix[2][3] = 0.0f;
			matrix[3][3] = 1.0f;
			break;
		case D3DTRANSFORMSTATE_VIEW:
			Matrix_Transpose(ViewMatrix, *((Matrix4x3*)pMatrix));
			VectorCopy(matrix[0], ViewMatrix[0]);
			VectorCopy(matrix[1], ViewMatrix[1]);
			VectorCopy(matrix[2], ViewMatrix[2]);
			VectorCopy(matrix[3], ViewMatrix[3]);
			matrix[0][3] = matrix[1][3] = matrix[2][3] = 0.0f;
			matrix[3][3] = 1.0f;
			break;
		case D3DTRANSFORMSTATE_PROJECTION:
			Sys_memCopy(matrix, pMatrix, sizeof(matrix));
			break;
	}
	return (D3D_doD3D)?((int)pd3dDevice->SetTransform((D3DTRANSFORMSTATETYPE)transformStateType, (D3DMATRIX*)&matrix)):0;
}
int D3D_DrawPrimitive(int primitiveType, int vertexType, void* lpVertices, int vertexCount, int flags)
{
	return (D3D_doD3D)?((int)pd3dDevice->DrawPrimitive((D3DPRIMITIVETYPE)primitiveType, vertexType, lpVertices, vertexCount, flags)):0;
}
int D3D_SetRenderState(int renderStateType, int renderState)
{
	return (D3D_doD3D)?((int)pd3dDevice->SetRenderState((D3DRENDERSTATETYPE)renderStateType, renderState)):0;
}
int D3D_ViewportClear2(int count, int* pRectangles, int flags, int color, float z, int stencil)
{
	return (D3D_doD3D)?((int)pvViewport->Clear2(count,(D3DRECT*)pRectangles,flags,color,z,stencil)):0;
}
int D3D_BeginScene()
{
	return (D3D_doD3D)?((int)pd3dDevice->BeginScene()):0;
}
int D3D_EndScene()
{
	return (D3D_doD3D)?((int)pd3dDevice->EndScene()):0;
}
int D3D_Flip()
{
	return (D3D_doD3D)?((int)pddsPrimary->Flip(0, DDFLIP_WAIT)):0;
}
int D3D_SetTextureStageState(int stage, int state, int value)
{
	return (D3D_doD3D)?((int)pd3dDevice->SetTextureStageState(stage, (D3DTEXTURESTAGESTATETYPE)state, value)):0;
}
D3D_VIEWPORT2* D3D_GetViewport2()
{
	return (D3D_VIEWPORT2*)pViewportData;
}
/////////////////////////////////////////////////////////////////////////////

#define MAX_BITMAPS 600

typedef struct {
	IDirectDrawSurface4* pDDSystemSurface;
	IDirectDrawSurface4* pDDVideoSurface;
	IDirect3DTexture2* pD3DVideoTexture;
	IDirectDrawPalette* pDDPalette;
	char Name[0x80];
} Bitmap_t;

Bitmap_t* Bitmaps = 0;

Bitmap_t* Texture_GetBitmap(char* Name)
{
	Bitmap_t* Bitmap = Bitmaps;
	int i;
	for (i=0 ; i<MAX_BITMAPS; i++, Bitmap++)
		if (Sys_strcmp(Name, Bitmap->Name))
			break;
	if (i == MAX_BITMAPS)
		Error("Texture_GetBitmap(%s)", Name);
	return Bitmap;
}
void* Texture_Get(char* Name)
{
	return (void*)(Texture_GetBitmap(Name))->pD3DVideoTexture;
}
void Texture_GetPalette(char* Name, int FirstIndex, int LastIndex, unsigned char* Palette)
{
	if (!D3D_doD3D)
		return;
	Bitmap_t* Bitmap = Texture_GetBitmap(Name);
	Bitmap->pDDPalette->GetEntries(0, FirstIndex, LastIndex-FirstIndex+1, (PALETTEENTRY*)Palette);
}
void Texture_SetPalette(char* Name, int FirstIndex, int LastIndex, unsigned char* Palette)
{
	if (!D3D_doD3D)
		return;
	Bitmap_t* Bitmap = Texture_GetBitmap(Name);
	Bitmap->pDDPalette->SetEntries(0, FirstIndex, LastIndex-FirstIndex+1, (PALETTEENTRY*)Palette);
}
bool Texture_CheckDims(int Width, int Height)
{
	return !(((Width-1) & Width) | ((Height-1) & Height));
}
void Texture_Load(char* Name, char* SrcData, char* Palette, int Width, int Height, int NumMipMapLevels)
{
	Bitmap_t* Bitmap;
	DDSURFACEDESC2 ddsd;
	DDSCAPS2 ddsCaps;
	IDirectDrawSurface4 *pDDLevel;
	IDirect3DTexture2* pSystemTexture;
	int i, j, k, LevelWidth, LevelHeight;
	char* Dest;
	Sys_logPrintf("  %s : %i * %i * %i",Name,Width,Height,NumMipMapLevels);
	if (Sys_strlen(Name) > sizeof(Bitmap->Name))
		goto failure;
	if (!Texture_CheckDims(Width, Height))
		goto failure;
	if (!Bitmaps)
		Bitmaps = (Bitmap_t*)Sys_HeapAlloc(MAX_BITMAPS * sizeof(*Bitmaps));
	Bitmap = Bitmaps;
	for (i=0; i<MAX_BITMAPS; i++, Bitmap++)
		if (!Bitmap->pD3DVideoTexture)
			break;
	if (i == MAX_BITMAPS)
		goto failure;
	Sys_memClear(Bitmap,sizeof(*Bitmap));
	Sys_strcpy(Bitmap->Name,Name);
	if (!D3D_doD3D)
	{
		Bitmap->pD3DVideoTexture = (IDirect3DTexture2*)0xffffffff;
		Bitmap->pDDPalette = (IDirectDrawPalette*)Sys_HeapAlloc(0x100 * 4);
		return;
	}
	Sys_memClear(&ddsd,sizeof(ddsd));
	ddsd.dwSize = sizeof(ddsd);
	ddsd.dwFlags = (DDSD_CAPS|DDSD_HEIGHT|DDSD_PIXELFORMAT|DDSD_WIDTH);
	ddsd.ddsCaps.dwCaps = (DDSCAPS_TEXTURE|DDSCAPS_SYSTEMMEMORY);
	ddsd.dwWidth = Width;
	ddsd.dwHeight = Height;
	if (NumMipMapLevels > 1)
	{
		ddsd.dwFlags |= DDSD_MIPMAPCOUNT;
		ddsd.ddsCaps.dwCaps |= (DDSCAPS_COMPLEX|DDSCAPS_MIPMAP);
		ddsd.dwMipMapCount = NumMipMapLevels;
	}
	ddsd.ddpfPixelFormat.dwSize = sizeof(ddsd.ddpfPixelFormat);
	ddsd.ddpfPixelFormat.dwFlags = (DDPF_PALETTEINDEXED8|DDPF_RGB);
	ddsd.ddpfPixelFormat.dwRGBBitCount = 8;
	if (pDD4->CreateSurface(&ddsd, &Bitmap->pDDSystemSurface, 0))
		Error("DDraw4_CreateSurface(systemSurface)");
	if (pDD4->CreatePalette((DDPCAPS_ALPHA|DDPCAPS_8BIT|DDPCAPS_ALLOW256|DDPCAPS_INITIALIZE),\
						(PALETTEENTRY*)Palette, &(Bitmap->pDDPalette), 0))
		Error("DDraw4_CreatePalette()");
	if (Bitmap->pDDSystemSurface->SetPalette(Bitmap->pDDPalette))
		Error("IDirectDrawSurface4_SetPalette()");
    pDDLevel = Bitmap->pDDSystemSurface;
    LevelWidth = Width;
    LevelHeight = Height;
	for (i=NumMipMapLevels; i>=0; i--)
	{
		Sys_memClear(&ddsd, sizeof(ddsd));
		ddsd.dwSize = sizeof(ddsd);
		if (pDDLevel->Lock(0, &ddsd, DDLOCK_WAIT, 0))
			Error("IDirectDrawSurface4_Lock(systemLevel)");
		Dest = (char*)ddsd.lpSurface;
		for (j=0; j<LevelHeight; j++, Dest+=ddsd.lPitch)
			for (k=0; k<LevelWidth; k++)
					Dest[k] = *(SrcData++);
		if (pDDLevel->Unlock(0))
			Error("IDirectDrawSurface4_Unlock(systemLevel)");
		if (i == 1)
			break;
		ddsCaps.dwCaps = (DDSCAPS_TEXTURE|DDSCAPS_MIPMAP|DDSCAPS_SYSTEMMEMORY);
		ddsCaps.dwCaps2 = 0;
		if (pDDLevel->GetAttachedSurface(&ddsCaps, &pDDLevel))
			Error("IDirectDrawSurface4_GetAttachedSurface(systemLevel)");
		pDDLevel->Release();
		LevelWidth >>= 1;
		LevelHeight >>= 1;
	}
	Sys_memClear(&ddsd,sizeof(ddsd));
	ddsd.dwSize = sizeof(ddsd);
	ddsd.dwWidth = Width;
	ddsd.dwHeight = Height;
	ddsd.dwFlags = (DDSD_CAPS|DDSD_HEIGHT|DDSD_PIXELFORMAT|DDSD_WIDTH);
	ddsd.ddsCaps.dwCaps = 	(DDSCAPS_TEXTURE|DDSCAPS_VIDEOMEMORY|DDSCAPS_ALLOCONLOAD);
	if (NumMipMapLevels > 1)
	{
		ddsd.dwFlags |= DDSD_MIPMAPCOUNT;
		ddsd.ddsCaps.dwCaps |= (DDSCAPS_COMPLEX|DDSCAPS_MIPMAP);
		ddsd.dwMipMapCount = NumMipMapLevels;
	}
	ddsd.ddpfPixelFormat.dwSize = sizeof(ddsd.ddpfPixelFormat);
	ddsd.ddpfPixelFormat.dwFlags = (DDPF_PALETTEINDEXED8|DDPF_RGB);
	ddsd.ddpfPixelFormat.dwRGBBitCount = 8;
	if (pDD4->CreateSurface(&ddsd, &Bitmap->pDDVideoSurface, 0))
		Error("DDraw4_CreateSurface(videoSurface)");
	if (Bitmap->pDDVideoSurface->SetPalette(Bitmap->pDDPalette))
		Error("IDirectDrawSurface4_SetPalette()");
	if (Bitmap->pDDSystemSurface->QueryInterface(IID_IDirect3DTexture2, (void**)&pSystemTexture))
		Error("IDirectDrawSurface4_QueryInterface(IID_IDirect3DTexture2)(systemTexture)");
	if (Bitmap->pDDVideoSurface->QueryInterface(IID_IDirect3DTexture2,\
										(void**)&Bitmap->pD3DVideoTexture))
		Error("IDirectDrawSurface4_QueryInterface(IID_IDirect3DTexture2)(videoTexture)");
	if (Bitmap->pD3DVideoTexture->Load(pSystemTexture))
		Error("IDirect3DTexture2_Load()");
	pSystemTexture->Release();
	return;
	failure:
	{
		Error("Texture_create(%s)",Name);
	}
}
int Texture_CalcMemRequired(int Width,int Height, int MipMapCount)
{
	int Size = 0;
	while (MipMapCount > 0)
	{
		MipMapCount--;
		Size += (Width * Height);
		Width >>= 1;
		Height >>= 1;
	}
	return Size;
}
