#!/usr/bin/python
# -*- coding: utf-8 -*-
#

# The original author of this script is below. This script is heavily altered
# from XQTR of Another Droid BBS (andr01d.zapto.org:9999) for creating a micro
# blog platform for MysticBBS Software.

'''
   _            _   _              ___          _    _       
  /_\  _ _  ___| |_| |_  ___ _ _  |   \ _ _ ___(_)__| |               8888
 / _ \| ' \/ _ \  _| ' \/ -_) '_| | |) | '_/ _ \ / _` |            8 888888 8
/_/ \_\_||_\___/\__|_||_\___|_|   |___/|_| \___/_\__,_|            8888888888
                                                                   8888888888
         DoNt Be aNoTHeR DrOiD fOR tHe SySteM                      88 8888 88
                                                                   8888888888
    .o HaM RaDiO    .o ANSi ARt!       .o MySTiC MoDS              "88||||88"
    .o NeWS         .o WeATheR         .o FiLEs                     ""8888""
    .o GaMeS        .o TeXtFiLeS       .o PrEPardNeSS                  88
    .o TuTors       .o bOOkS/PdFs      .o SuRVaViLiSM          8 8 88888888888
    .o FsxNet       .o SurvNet         .o More...            888 8888][][][888
                                                               8 888888##88888
   TeLNeT : andr01d.zapto.org:9999 [UTC 11:00 - 20:00]         8 8888.####.888
   SySoP  : xqtr                   eMAiL: xqtr.xqtr@gmail.com  8 8888##88##888
'''

# author: alexander.poslavsky@gmail.com
# version: 1.0.3 (14-12-2012)
# license: BSD
#
# post to wordpress from the command-line
#
# Changelog:
# - 1.0.0 dependencies:  Install from PyPI using easy_install
#   python-wordpress-xmlrpc or pip install python-wordpress-xmlrpc.
# - 1.0.1 load config from file
# - 1.0.2 added [TOC] and headerid
#   http://packages.python.org/Markdown/extensions/index.html
# - 1.0.3 fix odd charcters (decode('utf-8'))

from wordpress_xmlrpc import Client, WordPressPost
from wordpress_xmlrpc.methods.posts import GetPosts, NewPost, EditPost
from wordpress_xmlrpc.methods import posts
from wordpress_xmlrpc.methods import taxonomies
from wordpress_xmlrpc import WordPressTerm
import textwrap
import datetime, xmlrpclib
import argparse
import sys
import os
import string

# This file contains Wordpress.com login info, edit first.
from wpblog import *

#This code allows to translate foreign languages to english-like text
#In the example is used for Greek.
poolGR = 'αβγδεζηθικλμνξοπρσςτυφχυωάέήίϊΐόύϋΰώΑΒΓΔΕΖΗΘΙΚΛΜΝΞΟΠΡΣΤΥΦΧΨΩΆΈΉΊΪΌΎΫΏ'
poolGL = 'abgdezh8iklmn3oprsstufxywaehiiiouuuwABGDEZH8IKLMNJOPRSTYFXCWAEHIIOUUW'
gr = poolGR.decode('utf-8')
gr = gr.encode( 'iso-8859-7', 'replace' )
en = poolGL.decode('utf-8')
en = en.encode( 'iso-8859-7', 'replace' )

def gr2en(text):
    global en, gr
    input_string = text
    input_string = input_string.decode('utf-8')
    input_string = input_string.encode( 'iso-8859-7', 'replace' )
    translation_table = string.maketrans( gr, en )
    input_string = string.translate( input_string, translation_table )
    return input_string

def find_id(tag):
     p = wp.call(taxonomies.GetTerms('post_tag'))
     if len(p) == 0:
          return(False)
     for thetags in p:
         print 'looking for tag : ' , tag , ' in thetags : ' , str(thetags)
         if str(thetags) in tag:
            return(True)
     return(False)
     
def find_id_c(content):
        offset = 0
        increment = 20
        while True:
                filter = { 'offset' : offset }
                p = wp.call(GetPosts(filter))
                if len(p) == 0:
                        break # no more posts returned
                for post in p:
                        if post.content.find(content) != -1:
                                post.post_status = 'unpublish'
                                # We remove the post if its found, but you 
                                # could do anything
                                wp.call(posts.EditPost(post.id, post))
                                return(post.id)
                offset = offset + increment
        return(False)

def find_id_t(title):
    offset = 0
    increment = 10
    while True:
        filter = { 'offset' : offset }
        allposts = wp.call(GetPosts(filter))
        if len(allposts) == 0:
                break
        for p_item in allposts:
            if p_item.title == title:
                return(p_item.id)
        offset = offset + increment
    return(False)
    
def getpost(pid,folder):
    p_item = wp.call(posts.GetPost(pid))
    if p_item.id:
        file = open(folder+os.sep+'draft'+os.sep+pid+".txt","w") 
        file.write('|16|15Title     : |07'+gr2en(p_item.title.encode('utf-8'))+ '\n')
        file.write('|16|15ID        : |07'+p_item.id+ '\n')
        file.write('|16|15Written By: |07'+gr2en(p_item.user)+ '\n')
        file.write('|16|15Status    : |07'+gr2en(p_item.post_status)+ '\n')
        file.write('|16|15Date      : |07'+str(p_item.date)+ '\n')
        file.write('|16|15Link      : |07'+gr2en(p_item.link)+ '\n')
        file.write('============================================================================'+ '\n')
        #file.write(p_item.content.encode('utf-8')+ '\n')
        body = gr2en(p_item.content.encode('utf-8'))
        body = '\n'.join(['\n'.join(textwrap.wrap(line, 90, break_long_words=False, replace_whitespace=False))
        for line in body.splitlines() if line.strip() != ''])
        file.write(body)
        file.close() 
    
def getall(folder):
    offset = 0
    increment = 10
    os.system('rm '+folder+'posts'+os.sep+'*.txt')
    #os.system('rm '+folder+'draft'+os.sep+'*.txt')
    while True:
        filter = { 'offset' : offset }
        allposts = wp.call(GetPosts(filter))
        if len(allposts) == 0:
                break
        for p_item in allposts:
            if p_item.post_status == 'publish':
                file = open(folder+"posts/"+p_item.id+".txt","w") 
                file.write('|16|15Title     : |07'+gr2en(p_item.title.encode('utf-8'))+ '\n')
                file.write('|16|15ID        : |07'+p_item.id+ '\n')
                file.write('|16|15Written By: |07'+gr2en(p_item.user)+ '\n')
                file.write('|16|15Status    : |07'+gr2en(p_item.post_status)+ '\n')
                file.write('|16|15Date      : |07'+str(p_item.date)+ '\n')
                file.write('|16|15Link      : |07'+gr2en(p_item.link)+ '\n')
                file.write('============================================================================'+ '\n')
                #file.write(p_item.content.encode('utf-8')+ '\n')
                
                body = gr2en(p_item.content.encode('utf-8'))
                body = '\n'.join(['\n'.join(textwrap.wrap(line, 90, break_long_words=False, replace_whitespace=False))
                for line in body.splitlines() if line.strip() != ''])


                #file.write(textwrap.fill(gr2en(p_item.content.encode('utf-8')), width=79))
                file.write(body)
                file.close() 
            else:
                file = open(folder+"draft/"+p_item.id+".txt","w") 
                file.write('|16|15Title     : |07'+gr2en(p_item.title.encode('utf-8'))+ '\n')
                file.write('|16|15ID        : |07'+p_item.id+ '\n')
                file.write('|16|15Written By: |07'+gr2en(p_item.user)+ '\n')
                file.write('|16|15Status    : |07'+gr2en(p_item.post_status)+ '\n')
                file.write('|16|15Date      : |07'+str(p_item.date)+ '\n')
                file.write('|16|15Link      : |07'+gr2en(p_item.link)+ '\n')
                file.write('============================================================================'+ '\n')
                #file.write(p_item.content.encode('utf-8')+ '\n')
                body = gr2en(p_item.content.encode('utf-8'))
                body = '\n'.join(['\n'.join(textwrap.wrap(line, 90, break_long_words=False, replace_whitespace=False))
                for line in body.splitlines() if line.strip() != ''])
                #file.write(textwrap.fill(gr2en(p_item.content.encode('utf-8')), width=79))
                file.write(body)
                file.close() 
        offset = offset + increment
    return(False)
    
def makeindex():
    offset = 0
    increment = 10
    #file = open("index.txt","w") 
    while True:
        filter = { 'orderby': 'post_modified' , 'offset' : offset }
        allposts = wp.call(GetPosts(filter))

        if len(allposts) == 0:
                break
        for p_item in allposts:   
            #file.write(p_item.id+';'+p_item.title.encode('utf-8')+ '\n')
            print gr2en((p_item.id+';'+p_item.title.encode('utf-8')))
        offset = offset + increment
    #file.close()
    return(False)
    
def getcategories():
    offset = 0
    increment = 10
    #file = open("categories.txt","w") 
    
    categories = wp.call(taxonomies.GetTerms('category'))

    if len(categories) <> 0:
        for cat in categories:   
            print gr2en((str(cat)))
    #file.close()
    return(False)  
    
def gettags():
    categories = wp.call(taxonomies.GetTerms('post_tag'))

    if len(categories) <> 0:
        for cat in categories:   
            print gr2en((str(cat)))
    return(False)     
    
def deletepost(pid):
    wp.call(posts.DeletePost(pid))
    
def addnewtag(newtag):
    tag = WordPressTerm()
    tag.taxonomy = 'post_tag'
    tag.name = newtag
    tag.id = wp.call(taxonomies.NewTerm(tag))
    
def addnewcategory(cat):
    #parent_cat = wp.call(taxonomies.GetTerm('category', 0))
    child_cat = WordPressTerm()
    child_cat.taxonomy = 'category'
    #child_cat.parent = nil #parent_cat.id
    child_cat.name = cat
    child_cat.id = wp.call(taxonomies.NewTerm(child_cat))

def post2wp():
    if post.id:
        wp.call(EditPost(post.id, post))
        if args.verbose:
            print "Updated post"
    else:
        post_id=find_id(post.title)
        if post_id:
            if args.updateid:
                update_id(post_id)
            else:
                print "Sorry, we already have such a post (or at least a post with such a title):", post_id,", use -u to update the id"
        else:
            if args.publish:
                post.post_status = 'publish'
            else:
                post.post_status = 'draft'
            post_id = wp.call(NewPost(post))
            if args.verbose:
                print "Placed new post ( %s )" % post_id
            update_id(post_id)

def main():

    global args, rawText, post, wp

    parser = argparse.ArgumentParser(description='Work on your blog, posts default to draft')
    parser.add_argument('filePath', nargs='?')
    parser.add_argument('--updateid','-u', dest='updateid', action='store_true',
                       help='update the id of the post by title')
    parser.add_argument('--publish','-p', dest='publish', action='store_true',
                       help='publish straight away (don\'t save as draft)')
    parser.add_argument('--list-config','-l', dest='list_config', action='store_true',
                       help='list configurations')
    parser.add_argument('--verbose','-v', dest='verbose', action='store_true',
                       help='print return messages')
    parser.add_argument('--debug','-d', dest='debug', action='store_true',
                       help='print all messages')
    parser.add_argument('--get-all','-a', dest='getall', action='store',
                       help='Get All posts and save to files by id.')
    parser.add_argument('--index','-i', dest='index', action='store_true',
                       help='Create Index File.')
    parser.add_argument('--categories','-c', dest='categories', action='store_true',
                       help='Get all Categories.')
    parser.add_argument('--tags','-t', dest='tags', action='store_true',
                       help='Get all Tags.')
    parser.add_argument('--new-tag','-nt', dest='newtag', action='store',
                       help='Add new tag.')
    parser.add_argument('--new-category','-nc', dest='newcat', action='store',
                       help='Add new category.')
    parser.add_argument('--erase-post','-e', dest='delpost', action='store',
                       help='Erase complete post.')
    parser.add_argument('--get-post','-g', dest='postid', action='store',
                       help='Retrieve Post by ID.')

    args = parser.parse_args()
    if args.debug:
        args.verbose=True
        print(parser.parse_args())

    try:
        BLOG_URL = "https://%s.wordpress.com/xmlrpc.php" % wp_name
        
        if args.debug:
            print "Posting to %s with user: %s" % (BLOG_URL, wp_username)
        wp = Client(BLOG_URL, wp_username, wp_password)
    except:
        print("Cannot find configuration!")
        exit(1)

    if args.list_config:
        print config.sections()
        exit()
    
    if args.postid:
        getpost(args.postid,sys.path[0])
        exit()
    
    if args.getall:
        getall(args.getall)
        exit()
        
    if args.newtag:
        addnewtag(args.newtag)
        #print args.newtag
        exit()
        
    if args.delpost:
        deletepost(args.delpost)
        #print args.newtag
        exit()
        
    if args.newcat:
        addnewcategory(args.newcat)
        #print args.newtag
        exit()
    
    if args.categories:    
        getcategories()
        exit()
    
    if args.tags:    
        gettags()
        exit()
        
    if args.index:
        makeindex()
        exit()

    if args.filePath is None:
        #parser.print_help()
        exit(1)

    try:
        myFile = open(args.filePath, "r")
        rawText = myFile.read()
        rawText = rawText.decode('utf-8')
        myFile.close()
    except Exception, e:
        print("Sorry, could not open your markdown file")
        exit(1)
    
    with open(args.filePath+'.tag', "r") as ins:
        ttags = []
        for line in ins:
            line = line.strip('\n')
            if line <> '':
                ttags.append(line)
    
    with open(args.filePath+'.cat', "r") as ins:
        ccats = []
        for line in ins:
            line = line.strip('\n') 
            if line <> '':
                ccats.append(line)
    
    
    print ttags
    print ccats
     
        
    tfile = open(args.filePath+'.tit', "r")
    title = tfile.readline()
    tfile.close()
    
    post = WordPressPost()
    post.content = rawText
    post.title = title.decode('utf-8')
    post.content = rawText
    post.post_status = 'publish'
    post.terms_names = { 'post_tag': ttags, 'category': ccats }
    
    wp.call(NewPost(post))
    
reload(sys)
sys.setdefaultencoding('utf-8')
if __name__ == '__main__':
    main()
