#!/usr/bin/python3

import sys
#sys.path.append("/home/pi/pycrt")

from datetime import datetime
import pyjam
from configparser import SafeConfigParser
from rfeed import *
import os
import re

_bbs = "Another Droid BBS"
_author = "andr01d"
appdir = os.path.dirname(sys.argv[0])
ini = SafeConfigParser()

def additem(_title,_link,_description,_guid,_date):
  global _author
  itema = Item( \
          title = _title,\
          link = _link,\
          description = _description,\
          author = _author,\
          guid = Guid(_guid),\
          pubDate = _date)
  return itema

def showhelp():
  print("-"*79)
  print("  JAM2RSS Feed Creator v1.0")
  print("-"*79)
  print("")
  print("  Create RSS feeds from your message bases (JAM) in your BBS.")
  print("")
  print('  Usage: ')
  print("          "+sys.argv[0]+' <inifile>')
  print("")
  print("  For an example of the INI structure, view the file included.")
  print("")
  print("-"*79)
  print("      Another Droid BBS  ::  andr01d.zapto.org:9999  ::  XQTR  /  2019")
  print("-"*79)
  print("")
  

# === MAIN BLOCK ===


if len(sys.argv)<2:
  showhelp()
  exit()

if os.path.exists(sys.argv[1]):
  ini.read(sys.argv[1])
  if len(ini.sections()) ==0:
    print("No Sections to parse. Quiting...")
    quit(-1)
else:
  print("Configuration file not found. Quiting...")
  quit()

feedd = []

for section in ini.sections():
  if section.lower() != "feed" and section.lower() != "default":
    if ini.get(section,"type").lower() == "jam":
      if os.path.exists(ini.get(section,"jambase")+".jhr"):
        print("Found: "+ ini.get(section,"jambase"))
        if pyjam.get_msg_base_hdr(ini.get(section,"jambase")) == 0:
          i = int(pyjam.mbase_header["activemsgs"])
          a = i - int(ini.get(section,"items"))
          if a < 0: a=0
          feedd.clear()
          for cnt in range(a,i):
            k = 0
            pyjam.read_msg_header(ini.get(section,"jambase"),cnt)
            sender = pyjam.msg_header["sender"]
            receiver = pyjam.msg_header["receiver"]
            subject = pyjam.msg_header["subject"]
            #msgdate = pyjam.unix2str(pyjam.msg_header["datewritten"])
            msgdate = datetime.fromtimestamp(pyjam.msg_header["datewritten"])
            #msgdate =datetime.now()
            msgtext = pyjam.msg_read_text().replace("\n","<br>")
            msgtext = re.sub(r'\|..', '',msgtext)
            item = additem(subject,"From: "+sender+" To: "+receiver,msgtext,"guid",msgdate)
            feedd.append(additem(subject,"From: "+sender+" To: "+receiver,msgtext,"guid",msgdate))  
            k += 1
          feed = Feed(
            title = ini.get(section,"title"),
            link = ini.get(section,"link"),
            description = ini.get(section,"description"),
            language = "en-US",
            lastBuildDate = datetime.now(),
            items=feedd)
          fw = open(ini.get(section,"export"),"w")
          fw.write(feed.rss())
          fw.close()
          print("Wrote RSS to: "+ini.get(section,"export"))
        else:
          print("JamBase file seems corrupt or is not in the proper format")
      
