# coding: CP437

from mystic_bbs import *


box1=(chr(218),chr(196),chr(191),chr(179),chr(179),chr(192),chr(196),chr(217),' ')
box2=(chr(201),chr(205),chr(187),chr(186),chr(186),chr(200),chr(205),chr(188),' ')
box3=(chr(214),chr(196),chr(183),chr(186),chr(186),chr(211),chr(196),chr(189),' ')
box4=(chr(213),chr(205),chr(184),chr(179),chr(179),chr(212),chr(205),chr(190),' ')
box5=(chr(178),chr(223),chr(178),chr(178),chr(178),chr(178),chr(220),chr(178),' ')
box6=(chr(178),chr(223),chr(220),chr(178),chr(178),chr(223),chr(220),chr(178),' ')
box7=(' ',' ',' ',' ',' ',' ',' ',' ',' ')
box8=('.','-','.','|','|','`','-','\'',' ')

KEY_UP       = chr(72)    
KEY_DOWN     = chr(80)
KEY_ESCAPE   = chr(27)
KEY_ENTER    = chr(13)
KEY_TAB      = chr(9)
KEY_LEFT     = chr(75)
KEY_RIGHT    = chr(77)
KEY_PGUP    = chr(73)
KEY_PGDN    = chr(81)
KEY_END     = chr(79)
KEY_HOME    = chr(71)
KEY_SPACE   = chr(32)

color_box_on = 11
color_box_off = 8

exit_keys = []
exit_code = ""

separ = []
separ.append('+++------------------------------------- --  ----  -- - - -   -')
separ.append('.:*~*:._.:*~*:._.:*~*:._.:*~*:._.:*~*:._.:*~*:._.:*~*:._.:*~*:.')
separ.append('_."._."._."._."._."._."._."._."._."._."._."._."._."._."._."._')
separ.append('=^..^=   =^..^=   =^..^=    =^..^=    =^..^=    =^..^=    =^..^=')
separ.append("_,.-'~'-.,__,.-'~'-.,__,.-'~'-.,__,.-'~'-.,__,.-'~'-.,_")
separ.append('_/~\_/~\_/~\_/~\_/~\_/~\_/~\_/~\_/~\_/~\_/~\_/~\_/~\_/~\_')
separ.append('.oOo.oOo.oOo.oOo.oOo.oOo.oOo.oOo.oOo.oOo.oOo.oOo.oOo.oOo.oOo.')
separ.append('-=x=-=x=-=x=-=x=-=x=-=x=-=x=-=x=-=x=-=x=-=x=-=x=-=x=-=x=-=x=-')
separ.append('~^~^~^~^~^~^~^~^~^~^~^~^~^~^~^~^~^~^~^~^~^~^~^~^~^~^~^~^~^~^~')
separ.append('pdbqpdbqpdbqpdbqpdbqpdbqpdbqpdbqpdbqpdbqpdbqpdbqpdbqpdbqpdbqp')
separ.append('6969696969696969696969696969696969696969696969696969696969696')
separ.append('^V^V^V^V^V^V^V^V^V^V^V^V^V^V^V^V^V^V^V^V^V^V^V^V^V^V^V^V^V^V^')
separ.append('^v^v^v^v^v^v^v^v^v^v^v^v^v^v^v^v^v^v^v^v^v^v^v^v^v^v^v^v^v^v^')
separ.append('nunununununununununununununununununununununununununununununun')
separ.append('----------------8<-------------[ cut here ]------------------')
separ.append('<<>><<>><<>><<>><<>><<>><<>><<>><<>><<>><<>><<>><<>><<>><<>>')
separ.append('>< >< >< >< >< >< >< >< >< >< >< >< >< >< >< >< >< >< >< ><')
separ.append('<:>:<:>:<:>:<:>:<:>:<:>:<:>:<:>:<:>:<:>:<:>:<:>:<:>:<:>:<:>')
separ.append('^-^-^-^-^-^-^-^-^-^-^-^-^-^-^-^-^-^-^-^-^-^-^-^-^-^-^-^-^-^-^')
separ.append('+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+')
separ.append('--<>--<>--<>--<>--<>--<>--<>--<>--')
separ.append('oo1oo oo1oo oo1oo oo1oo oo1oo oo1oo oo1oo oo1oo oo1oo oo1oo')
separ.append('<+><+><+><+><+><+><+><+><+><+><+><+><+><+><+><+><+><+><+><+>')
separ.append('<*><*><*><*><*><*><*><*><*><*><*><*><*><*><*><*><*><*><*><*>')
separ.append('->->->->->->->->->->->->->->->->->->->->->->->->->->->->->->')

def clrscr():
  write('|07|16|CL')
  
def cleararea(x1,y1,x2,y2,bg):
    for i in range(y2-y1):
        gotoxy(x1,y1+i)
        write(bg*(x2-x1))

def writexy(x,y,a,s):
    gotoxy(x,y)
    #textattr(a)
    textcolor(a)
    write(s)
    
def ansibox(x1,y1,x2,y2,box):
    gotoxy(x1,y1)
    write(box[0]+box[1]*(x2-x1-1)+box[2])
    gotoxy(x1,y2)
    write(box[5]+box[6]*(x2-x1-1)+box[7])
    for i in range(y2-y1-1):
        gotoxy(x1,y1+1+i)
        write(box[3])
        gotoxy(x2,y1+1+i)
        write(box[4])
    
def getyesno(x,y,trueat,falseat,offat,default):
    """
    Function to get a Yes/No answer
    trueat  : color in byte value for the No button
    falseat : color in byte value for the Yes button
    default : True/False to begin with 
    """
    global exit_keys
    global exit_code
    key = ""
    val = {0:'No ',1:'Yes'}
    res = default
    while key != "#enter":
        writexy(x,y,offat,val[True]+' '+val[False])
        if res == True:
            writexy(x,y,trueat,val[res])
        else:
            writexy(x+4,y,falseat,val[res])
        gotoxy(1,25)
        key, extended = getkey()
        if key == KEY_LEFT or key == KEY_RIGHT or key == KEY_SPACE:
            res = not res
        elif key == KEY_ENTER:
            break
        elif key in 'yY':
            return val[True].lower().strip(" ")
        elif key in 'nN':
            return val[False].lower().strip(" ")
    return val[res].lower().strip(" ")
    
def boxgetstr(title,default):
  d = len(title)
  d2 = d // 2
  global exit_keys
  
  textcolor(color_box_on)
  cleararea(38-d2,10,42+d2,13," ")
  ansibox(38-d2,10,42+d2,13,box2)
  writexy(40-d2,11,7,title)
  gotoxy(40-d2,12)
  s=getstr(1, d, 120, default)
  if s == None:
    s = ""
  return s
    
def boxyesno(s):
  d = len(s)
  d2 = d // 2
  global exit_keys
  
  textcolor(color_box_on)
  cleararea(38-d2,10,42+d2,13," ")
  ansibox(38-d2,10,42+d2,13,box2)
  writexy(40-d2,11,7,s)
  if getyesno(37,12,31,15+4*16,7,False) == "yes":
    return True
  else:
    return False
    
def boxpopup(text):
  d = len(text)
  d2 = d // 2
  
  textcolor(color_box_on)
  #cleararea(38-d2,10,42+d2,13," ")
  if d < 25:
    cleararea(26,10,54,13," ")
    ansibox(26,10,54,13,box2)
  else:
    cleararea(38-d2,10,42+d2,13," ")
    ansibox(38-d2,10,42+d2,13,box2)
  writexy(40-d2,11,15,text)
  writexy(28,12,7,'Press key to continue...|PN')
  
def getync(x,y,trueat,offat,default,yes=" Yes ",no=" No ",cancel=" Cancel "):
    """
    Function to get a Yes/No/Cancel answer
    trueat  : color in byte value for the No button
    falseat : color in byte value for the Yes button
    default : True/False to begin with 
    """
    global exit_code
    exit_code = ""
    key = ""
    val = {1:no, 0:yes, 2:cancel}
    res = default
    while key != KEY_ENTER:
        writexy(x,y,offat,val[0]+val[1]+val[2])
        if res == 1:
            writexy(x+len(val[0]),y,trueat,val[res])
        elif res == 0:
            writexy(x,y,trueat,val[res])
        elif res == 2:
            writexy(x+len(val[1])+len(val[0]),y,trueat,val[res])
        gotoxy(1,25)
        key, extended = getkey()
        if key == KEY_LEFT: 
            res -= 1
            if res < 0:
                res = 2
        elif key == KEY_RIGHT or key == KEY_SPACE:
            res += 1
            if res > 2:
                res = 0
        elif key in exit_keys:
            exit_code = key
            break
        
    return res
  
    
def pause():
  write('|PN')
  
def savescreen():
  write('|SS')  

def restorescreen():
  write('|RS')  