#!/usr/bin/python3

# coding: CP437

import os
import re
import requests
import subprocess
import sys
from bs4 import BeautifulSoup

appdir = os.path.dirname(sys.argv[0])
sys.path.append(appdir+os.sep+"pycrt")
from pycrt import *
import xbox
import xinput

# internal variables. do not change!
exit_keys = []
itemlist = []
exit_code = ""
scrollbar = {"enable":True,"hichar":"▓","lochar":"░","hiatt":7,"loatt":8}
alttext = False
help_cl = 30
header = "Tootle - Terminal TPB... v1.0"

# the site to use for scraping. it has to be a TPB like site.
tmp_url = 'https://unblocktheship.org'

# the root directory for the file list
base_dir = "/media"

# used in the aria2c command line to limit the download speed, in case
# you use this option.
max_speed = "150k"

# the command to execute after adding/saving a torrent
torrent_command = "/home/pi/torrents.sh &"


# the search/feeling lucky "buttons" are not used. there are only for the looks
# if you want the top 100 use the search keywords below, like 100/m for top 100
# for movies.

def bg():
  gotoxy(1,6)
  textcolor(15)
  writeln("               _______ _______ _______ _______ ___     _______ ")
  writeln("              |       |   _   |   _   |       |   |   |   _   |")
  writeln("              |.|   | |.  |   |.  |   |.|   | |.  |   |.  1___|")
  writeln("              `-|.  |-|.  |   |.  |   `-|.  |-|.  |___|.  __)_ ")
  writeln("                |:  | |:  1   |:  1   | |:  | |:  1   |:  1   |")
  writeln("                |::.| |::.. . |::.. . | |::.| |::.. . |::.. . |")
  writeln("                 `---' `-------`-------' `---' `-------`-------'")

  writeln(" ")
  writeln(" ")
  textcolor(7)
  writeln('        /-------------------------------------------------------------\\')
  writeln("        :                                                             :")
  writeln("        \-------------------------------------------------------------/")
  textcolor(8)
  writeln("                  [ search ]                [ feeling lucky? ]") 
  writeln(" ")
  writeln("           100/m : top 100 movies          100/a : top 100 android apps")
  writeln("           100/s : top 100 music           100/w : top 100 windows apps")
  writeln(" ")


def menulist(items,x1,y1,x2,y2,hc=15,nc=7,sel=0,sb=scrollbar):
    """
    Displays a menu with lightbar, to select from
    items   : list of items to display
    x1,x2,
    y1,y2   : box area to display the menu
    hc      : Highlight/On color
    nc      : Normal text/off color
    sel     : default value to begin with.
    sb      : a dictionary, with values to display a scrollbar in the 
              right side of the menu
    """
    global exit_keys
    global exit_code
    global alttext
    
    alttext = False
    
    def updatebar():
        if sb["enable"] == False: Return
        for i in range(0,y2-y1+1):
            swritexy(x2,y1+i,sb["loatt"],sb["lochar"])
        if len(items) < 2:
            y = 0
        else:
            y = (selbar * (y2-y1)) // (len(items)-1)
        swritexy(x2,y1+y,sb["hiatt"],sb["hichar"])
    
    if len(items)<1:
      return -1
    exit_code = ""
    key = ""
    value = -1
    done = False
    if sel <= len(items):
        top = sel-(y2-y1)
        if top < 1: top = 0
    else:
        top = 0
    if sel <= len(items):
        selbar = sel
    else:
        selbar = 0
    if alttext:
        writexy(1,2,7*16,(" Date".ljust(22," ")+"Seeders".ljust(15," ")+"Leechers".ljust(15," ")).ljust(79," "))
    else:
        writexy(1,2,7*16," Title".ljust(69," ")+"Size".ljust(10," "))
    
    while done == False:
        #writexy(1,1,7,str(top)+"/"+str(selbar)+"/"+str(len(items)))
        gotoxy(x1,y1)
        y = top
        while y1+y-top<=y2:
            if y<len(items):
                if alttext:
                    s = "Date: "+items[y][2].ljust(14, " ")+" Seeders: "+items[y][4].ljust(5, " ")+" Leechers: "+items[y][5].ljust(5, " ")
                    s = s.ljust(x2-x1," ")
                else:
                    s = items[y][0].ljust(x2-x1, " ")[:x2-x1-10]+items[y][3].rjust(10, " ")[:10]
                writexy(x1,y1+y-top,nc,s)
            else:
                writexy(x1,y1+y-top,nc," ".ljust(x2-x1, " ")[:x2-x1])
            y += 1
        if alttext:
            s = "Date: "+items[selbar][2].ljust(14, " ")+" Seeders: "+items[selbar][4].ljust(5, " ")+" Leechers: "+items[selbar][5].ljust(5, " ")
            s = s.ljust(x2-x1," ")
        else:
            s = items[selbar][0].ljust(x2-x1, " ")[:x2-x1-10]+items[selbar][3].rjust(10, " ")[:10]
        writexy(x1,y1+selbar-top,hc,s)
        updatebar()
        gotoxy(1,25)
        
        key = readkey()
        
        if key == "#up":
            selbar=selbar-1
            if selbar < 1:
                selbar = 0
            if selbar < top:
                top = selbar
        elif key == "#pgup":
            selbar = selbar - (y2-y1)
            if selbar < 0:
                selbar = 0
                top = 0
            else:
                top = top - (y2-y1)
                if top < 0:
                    top = 0
        elif key == "#pgdn":
            selbar = selbar+(y2-y1)
            if selbar > len(items)-1:
                selbar = len(items)-1
            top = top+(y2-y1)
            if top > len(items)-1-(y2-y1):
                top = len(items)-1-(y2-y1)
                if top < 0:
                    top = 0
        elif key == "#space":
            alttext = not alttext
            if alttext:
                writexy(1,2,7*16," Date".ljust(22," ")+"Seeders".ljust(15," ")+"Leechers".ljust(15," "))
            else:
                writexy(1,2,7*16," Title".ljust(69," ")+"Size".ljust(10," "))
        elif key == "#end":
            selbar=len(items)-1
            if len(items)-(y2-y1)-1 > 0:
                top = len(items)-(y2-y1)-1
            else:
                top = 0
        elif key == "#home":
            selbar=0
            top = 0
        elif key == "#down": 
            selbar=selbar+1
            if selbar > len(items)-1:
                selbar = len(items)-1
            if selbar > top+y2-y1:
                top += 1
        elif key == "#enter":
            value = selbar
            exit_code = "#enter"
            done = True
        elif key in exit_keys:
            exit_code = key
            value = selbar
            done = True
        
            
    return value
    
def getlink(idx):
  global itemlist
  global max_speed
  url = tmp_url+itemlist[idx][1]
  
  try:
    cont = requests.get(url)
  except requests.exceptions.RequestException as e:
    raise SystemExit('\n' + str(e))
    
  searchObj =re.findall("magnet:\?xt=urn:btih:[a-zA-Z0-9]*", str(cont.content), re.M|re.I)
  if searchObj:
    writexy(5, 2,7, 'Magnet Link for:')
    writexy(5,3,7, itemlist[idx][0][:70])
    writexy(10,4,14, searchObj[0])
    
    writexy(10,6,7,"Save link to file?")
    if xinput.getyesno(29,6,30,30,7,True) == "yes":
      writexy(5,8,3,'Select directory:')
      writexy(1,24,help_cl,'ENTER // Select Dir | INS or F10 or CTRL+D // Choose dir.'.ljust(79," "))
      textcolor(3)
      xbox.ansibox(4,9,76,18,xbox.box8)
      magdir = xinput.dirselect(base_dir,5,10,75,17,14+3*16,7)
      if magdir != "":
        f = open(magdir+itemlist[idx][0][:70]+".mag",'w+')
        f.write(searchObj[0])
        f.write("\n")
        f.close()
        writexy(5,19,13,'File saved as:')
        writexy(5,20,13,magdir+itemlist[idx][0][:70]+".mag")
      
        writexy(10,21,7,"Start downloading?")
        if xinput.getyesno(29,21,30,30,7,True) == "yes":
          #writexy(10,22,14,"Press CTRL-A, D, to send process in background.")
          #os.system("screen -dmS aria aria2c -i '"+magdir+itemlist[idx][0][:70]+".mag' --max-overall-download-limit="+max_speed+" --dir="+magdir)
          os.system(torrent_command)
      
      writexy(40-13,23,7,"Press a key to continue...")
      readkey()
    
    
  else:
    writexy(30,10,13,"Nothing found. Press a key...")
    readkey()
    return
  

def search(s): 
  if s == "100/m":
    url = tmp_url+'/'+"top/201"
  elif s == "100/s":
    url = tmp_url+'/'+"top/101"
  elif s == "100/a":
    url = tmp_url+'/'+"top/306"
  elif s == "100/w":
    url = tmp_url+'/'+"top/301"
  else:
    url = tmp_url+'/'+"s/?q="+s.replace(" ","+")+"&category=0&page=0&orderby=99"

  try:
    cont = requests.get(url)
  except requests.exceptions.RequestException as e:
    raise SystemExit('\n' + str(e))
  
  if "top" in url:
    return cont.content
  else:    
    if not re.findall(r'Displaying hits from', str(cont.content)):
      return -1
    else:    
      return cont.content

def getresults(s):
  global itemlist
  itemlist.clear()
  r = search(s)
  if r == -1:
    return -1
  else:
    soup = BeautifulSoup(r, 'html.parser')
    
    t = soup.find_all('div',attrs={'class': 'detName'})
    if t is None or len(t) == 0:
      writeln('No results')
    else:
      total = len(t)
    
    i = 1
    for d in soup.find_all('div',attrs={'class': 'detName'}):
      #if d is not None:
      title = d.get_text().strip()
      a = d.find_all('a')[0]
      f = soup.find_all('font')[0]
      desc = f.get_text().strip() 
      link = a.get('href')
      item = [title,link,"","","",""]
      i += 1
      itemlist.append(item)
      
    i = 0
    for f in soup.find_all('font',attrs={'class': 'detDesc'}):
      text = f.get_text()
      date = text.split(',')[0].split(' ')[1]
      size = text.split(',')[1].split(' ')[2]
      size = bytes(size.encode())
      size = str(size).replace("b'","").replace("\\xc2\\xa0"," ")[:-1]
      
      itemlist[i][2]=date
      itemlist[i][3]=size
      i +=1
    
    i = 0 
    s = True
    for f in soup.find_all('td',attrs={'align': 'right'}):
      if s:
        itemlist[i][4] = f.get_text()
        s = False
      else:
        itemlist[i][5] = f.get_text()
        s = True
        i += 1
  return 0
  
def showresults():
  global itemlist
  sel = 0
  exit_keys.append("#esc")
  textcolor(7)
  clrscr()
  
  while True:
    writexy(1,1,30,header.ljust(79," "))
    writexy(1,24,help_cl,"ESC // Exit | SPACE // More Info".ljust(79," "))
    sel = menulist(itemlist,1,3,79,23,14+3*16,7,sel)
    if exit_code == "#enter":
      clrscr()
      getlink(sel)
    elif exit_code == "#esc":
      break
  
done = True  
xinput.exit_keys.append("#esc")
while done:
  textcolor(7)
  clrscr()
  bg()
  writexy(1,1,30,header.ljust(79," "))
  writexy(1,24,help_cl,"ESC // Exit | ENTER // Search".ljust(79," "))
  sstring = xinput.input(11,16,15,11,xinput.cs_printable,38,255," ","")
  if xinput.exit_code == "#esc":
    done = False
  if sstring.strip() != "":
    wait = "Please Wait..."
    writexy(40-len(wait) // 2,22,14,wait)
    if getresults(sstring.strip()) == 0:
      writexy(1,24,help_cl,"ESC // Exit | SPACE // More Info".ljust(79," "))
      showresults()
    else:
      writexy(20,13,5,"No results found. Press any key...")
      readkey()
    
textcolor(7)
clrscr()    
