#include <ddlib.h>
#include <time.h>
#include <string.h>
#include <stdio.h>

struct userinfo {
  char name[26];
  char location[26];
  char activity[80];
  int  rate;
};

struct wholist {
  UBYTE node;
  int nodetype;
  struct userinfo user;
  struct wholist *next;
};

int nodenumber;

struct userbase *finduserbynumber(int unum) {
  struct userbase *tmpuser=(struct userbase *)malloc(sizeof(struct userbase));
  FILE *uf;
  char *tmp;

  sprintf(tmp,"%s/data/userbase.dat",getenv("DAYDREAM"));
  uf=fopen(tmp,"rb");
  fseek(uf,unum*sizeof(struct userbase),SEEK_SET);
  fread(tmpuser,sizeof(struct userbase),1,uf);
  fclose(uf);
  return tmpuser;
};

struct userinfo *makedefault() {
  struct userinfo *tmp=(struct userinfo *)malloc(sizeof(struct userinfo));

  sprintf((char *)&tmp->name,"-> Awaiting Caller <-");
  sprintf((char *)&tmp->location,"nO lOCATION");
  sprintf((char *)&tmp->activity,"");
  tmp->rate=-1;

  return tmp;
};

struct wholist *insertwlist(UBYTE node,struct DayDream_MainConfig *c,struct wholist *list,int ntype) {
  FILE *nf;
  struct DayDream_NodeInfo *info=(struct DayDream_NodeInfo *)malloc(sizeof(struct DayDream_NodeInfo));
  struct wholist *tmp=(struct wholist *)malloc(sizeof(struct wholist));
  struct userbase *user;
  char *tmpstr=(char *)malloc(255);

  sprintf(tmpstr,"/tmp/dd/nodeinfo%d.data",node);
  if ((nf=fopen(tmpstr,"rb"))!=NULL) {
    fread(info,sizeof(struct DayDream_NodeInfo),1,nf);
    fclose(nf);
    if (info->ddn_userslot!=-1) {
      user=finduserbynumber(info->ddn_userslot);
      if (nodenumber==node) {
        sprintf((char *)&tmp->user.name,"----> YOUR NODE <----");
      } else {
        sprintf((char *)&tmp->user.name,"-> Node is Active! <-");
      }
      strcpy((char *)&tmp->user.location,(char *)&user->user_organization);
      strcpy((char *)&tmp->user.activity,(char *)&info->ddn_activity);
      tmp->user.rate=info->ddn_bpsrate;
    } else {
      memcpy((struct userinfo *)&tmp->user,makedefault(),sizeof(struct userinfo));
      if (nodenumber==node) {
        sprintf((char *)&tmp->user.name,"----> YOUR NODE <----");
        sprintf((char *)&tmp->user.activity,"Loggin in.");
      }
    }
  } else {
    memcpy((struct userinfo *)&tmp->user,makedefault(),sizeof(struct userinfo));
  }
  tmp->nodetype=ntype;
  tmp->node=node;
  tmp->next=list;

  free(tmpstr);
  return tmp;
};

struct wholist *createtelnet(struct DayDream_MainConfig *c,struct wholist *list) {
  UBYTE i;

  for (i=c->CFG_TELNET1ST;i<(c->CFG_TELNET1ST+c->CFG_TELNETMAX);i++) {
    list=insertwlist(i,c,list,1);
  }
  return list;
};

struct wholist *createlocal(struct DayDream_MainConfig *c,struct wholist *list) {
  UBYTE i;

  for (i=c->CFG_LOCAL1ST;i<(c->CFG_LOCAL1ST+c->CFG_LOCALMAX);i++) {
    list=insertwlist(i,c,list,0);
  }
  return list;
};

struct wholist *buildwholist(struct DayDream_MainConfig *c) {
  FILE *mnodefile;
  struct wholist *nlist=NULL;
  struct DayDream_Multinode *tmpentry;
  char *tmp=(char *)malloc(255);

  sprintf(tmp,"%s/data/multinode.dat",getenv("DAYDREAM"));
  mnodefile=fopen(tmp,"rb");
  while (fread(tmpentry,sizeof(struct DayDream_Multinode),1,mnodefile)!=0) {
    switch (tmpentry->MULTI_NODE) {
      case 253 : nlist=createtelnet(c,nlist);
                 break;
      case 254 : nlist=createlocal(c,nlist);
                 break;
      default : nlist=insertwlist(tmpentry->MULTI_NODE,c,nlist,2);
                break;
    };
  }
  fclose(mnodefile);
  free(tmp);
  return nlist;
};

char *arrangestr(char *instr,int flen) {
  char *outstr=(char *)malloc(80);

  while (strlen(instr)<flen) {
    if (strlen(instr)<flen) {
      strcpy(outstr,instr);
      strcpy(instr,">");
      strcat(instr,outstr);
    }
    if (strlen(instr)<flen) {
      strcat(instr,"<");
    }
  }
  free(outstr);
  return instr;
};

void outputlist(struct dif *d,struct wholist *list) {
  char *goat=(char *)malloc(255);
  char *goat1=(char *)malloc(80);

  if (list!=NULL) {
    outputlist(d,list->next);
    switch(list->nodetype) {
      case 0: sprintf(goat1,"local/",list->user.rate);
              break;
      case 1: sprintf(goat1,"telnet/",list->user.rate);
              break;
      default:sprintf(goat1,"modem/",list->user.rate);
              break;
    }
    if (list->user.rate==-1)
      sprintf(goat,"waiting");
    else
      sprintf(goat,"%d bps",list->user.rate);
    strcat(goat1,goat);

    if (list->next!=NULL)
      dd_sendstring(d,"    |----|-----------------------|---------------------|-------------------|\n");

    sprintf(goat,"    | %2.2d | %21.21s | %-19.19s | %17.17s |\n",list->node,list->user.name,list->user.activity,goat1);
    dd_sendstring(d,goat);
  }
  free(goat); free(goat1);
};

main(int argc,char *argv[]) {
  struct wholist *wlist;
  struct dif *d;
  struct DayDream_MainConfig config;
  FILE *cfgfile;
  char *tmp=(char *)malloc(255);

  sprintf(tmp,"%s/data/daydream.dat",getenv("DAYDREAM"));
  if ((argc==2) && ((cfgfile=fopen(tmp,"rb"))!=NULL)) {

    fread(&config,sizeof(struct DayDream_MainConfig),1,cfgfile);
    fclose(cfgfile);
    d=dd_initdoor(argv[1]);
    nodenumber=atoi(argv[1]);
    dd_changestatus(d,"Loggin in.");

    dd_sendstring(d,"    .----------------------------------------------------------------------.\n");
    dd_sendstring(d,"    |-Nd-+-NodeStat--------------+-Action--------------+-Connect-----------|\n");

    wlist=buildwholist(&config);
    outputlist(d,wlist);

    dd_sendstring(d,"    |----+-----------------------+---------------------+-------------------|\n");
    dd_sendstring(d,"    `--------------------------[muggifront/DD v1.2f (c) ck 1997 for sTF.]--'\n");

    dd_close(d);

  }
};
