#include <ddlib.h>
#include <time.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#define LOCAL 0
#define TELNET 1
#define FTP 2
#define MODEM 3

#define YOURNODE "----> YOUR NODE <----"
#define ACTIVE "-> Node is Active! <-"
#define LOGIN "Logging in.."

struct userinfo {
  char name[26];
  char activity[80];
  int  rate;
};

struct wholist {
  uint8_t node;
  int nodetype;
  struct userinfo user;
  struct wholist *next;
};

typedef struct wholist wholist_t;
typedef struct userinfo userinfo_t;

typedef struct DayDream_NodeInfo ddn_t;
typedef struct DayDream_MainConfig ddc_t;
typedef struct DayDream_Multinode ddm_t;
typedef struct userbase userbase_t;

userinfo_t EMPTY = {
  "-> Awaiting Caller <-",
  ":-(",
  -1
};

int nodenumber;

/*
int finduserbynumber(char* ddpath, int unum, userbase_t* user) {
  FILE* uf;
  char tmp[255];
  int rc;
  long pos;

  snprintf(tmp, 254, "%s/data/userbase.dat", ddpath);
  uf = fopen(tmp, "rb");

  if (uf == NULL) {
    return -1;
  }

  pos = unum * sizeof(userbase_t);

  // seek
  rc = fseek(uf, pos, SEEK_SET);
  if (rc != 0) {
    fclose(uf);
    return -1;
  }

  // read
  rc = fread(user, sizeof(userbase_t), 1, uf);

  // close
  fclose(uf);

  if (rc != 1) {
    return -1;
  }
  else {
    return 0;
  }
};
*/

wholist_t* add_sorted(wholist_t* list, wholist_t* item) {
  wholist_t* tmp;
  wholist_t* prev = NULL;

  if (list == NULL) {
    item->next = NULL;
    return item;
  }

  tmp = list;
  while (tmp != NULL && tmp->node < item->node) {
    prev = tmp;
    tmp = tmp->next;
  }

  if (tmp == NULL) {
    prev->next = item;
    item->next = NULL;
  }
  else {
    if (prev == NULL) {
      list = item;
      list->next = tmp;
    }
    else {
      prev->next = item;
      item->next = tmp;
    }
  }

  // return (new) head
  return list;
}

wholist_t *insertwlist(char* ddpath, uint8_t node,ddc_t *c,wholist_t *list,int ntype) {
  FILE *nf;
  wholist_t *tmp=(wholist_t*) malloc(sizeof(wholist_t));
  userbase_t user;
  ddn_t info;

  char tmpstr[255];
  int rc;

  snprintf(tmpstr, 254, "/tmp/dd/nodeinfo%d.data", node);

  // prepare empty
  memcpy((userinfo_t*) &tmp->user, &EMPTY, sizeof(userinfo_t));
  tmp->nodetype = ntype;
  tmp->node = node;

  // open
  nf = fopen(tmpstr, "rb");
  if (nf == NULL) {
    return add_sorted(list, tmp);
  }

  // read + close
  rc = fread(&info, sizeof(ddn_t), 1, nf);
  fclose(nf);

  // couldnt read?
  if (rc != 1) {
    return add_sorted(list, tmp);
  }

  // node is current node, mark it as such
  if (nodenumber == node) {
    strcpy(tmp->user.name, YOURNODE);
  }
  // node is active
  else if (info.ddn_userslot != -1) {
    strcpy(tmp->user.name, ACTIVE);
  }

  // copy activity
  strncpy(tmp->user.activity, info.ddn_activity, 80);
  tmp->user.rate = info.ddn_bpsrate;

  return add_sorted(list, tmp);
};

wholist_t* createtelnet(char* ddpath, ddc_t *c, wholist_t *list) {
  uint8_t i;

  for (i = c->CFG_TELNET1ST; i < (c->CFG_TELNET1ST + c->CFG_TELNETMAX); i++) {
    list= insertwlist(ddpath, i, c, list, TELNET);
  }
  return list;
};

wholist_t* createlocal(char* ddpath, ddc_t *c,wholist_t *list) {
  uint8_t i;

  for (i = c->CFG_LOCAL1ST; i < (c->CFG_LOCAL1ST + c->CFG_LOCALMAX); i++) {
    list = insertwlist(ddpath, i, c, list, LOCAL);
  }
  return list;
};

wholist_t *buildwholist(struct dif *d, char* ddpath, ddc_t* c) {
  FILE* mnodefile;
  wholist_t* nlist = NULL;
  ddm_t tmpentry;
  char tmp[255];
  int rc;

  snprintf(tmp, 254, "%s/data/multinode.dat", ddpath);

  mnodefile = fopen(tmp, "rb");
  if (mnodefile == NULL) {
    dd_sendstring(d, "No multinode.dat :-(\n");
    return NULL;
  }

  // local
  nlist = createlocal(ddpath, c, nlist);
  // telnet
  nlist = createtelnet(ddpath, c, nlist);

  while (1) {
    rc = fread(&tmpentry, sizeof(ddm_t), 1, mnodefile);

    if (rc < 1) {
      break;
    }

    switch (tmpentry.MULTI_NODE) {
      // telnet+local
    case 253: 
    case 254:
      break;
    default:
      nlist = insertwlist(ddpath, tmpentry.MULTI_NODE, c, nlist, MODEM);
      break;
    };
  }

  fclose(mnodefile);

  return nlist;
};

void outputlist(struct dif *d,wholist_t *list) {
  char goat[255];
  char goat1[81];
  wholist_t *current;

  current = list;

  while (current != NULL) {

    switch(current->nodetype) {
    case LOCAL: 
      snprintf(goat1, 80, "local/");
      break;
    case TELNET: 
      snprintf(goat1, 80, "telnet/");
      break;
    case FTP:
      snprintf(goat1, 80, "ftp/");
      break;
    default:
      snprintf(goat1, 80, "modem/");
      break;
    }

    if (current->user.rate == -1) {
      sprintf(goat,"waiting");
    }
    else {
      sprintf(goat,"%d bps", current->user.rate);
    }

    strcat(goat1, goat);


    snprintf(goat, 254, "    | %2.2d | %21.21s | %-19.19s | %17.17s |\n", 
	    current->node, current->user.name, current->user.activity, goat1);

    // print to daydream
    dd_sendstring(d, goat);

    if (current->next != NULL)
      dd_sendstring(d,"    |----|-----------------------|---------------------|-------------------|\n");

    // advance to next
    current = current->next;
  }
};

main(int argc,char *argv[]) {
  wholist_t *wlist;
  struct dif *d;
  ddc_t config;
  FILE *cfgfile;
  char tmp[255];
  char ddpath[255];
  int rc;

  // get dd env
  strncpy(ddpath, getenv("DAYDREAM"), 255);

  // config path
  snprintf(tmp, 255, "%s/data/daydream.dat", ddpath);

  cfgfile = fopen(tmp, "rb");

  if (cfgfile == NULL)
    exit(101);

  if (argc != 2)
    exit(102);

  rc = fread(&config, sizeof(ddc_t), 1, cfgfile);
  fclose(cfgfile);

  if (rc != 1) {
    exit(103);
  }

  d = dd_initdoor(argv[1]);
  
  nodenumber=atoi(argv[1]);

  dd_changestatus(d, LOGIN);

  dd_sendstring(d,"    .----------------------------------------------------------------------.\n");
  dd_sendstring(d,"    |-Nd-+-NodeStat--------------+-Action--------------+-Connect-----------|\n");

  wlist = buildwholist(d, ddpath, &config);

  outputlist(d, wlist);

  dd_sendstring(d,"    |----+-----------------------+---------------------+-------------------|\n");
  dd_sendstring(d,"    `--------------------------[muggifront/DD v1.2f (c) ck 1997 for sTF.]--'\n");

  dd_close(d);

};
