''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'FrontDoor Statistics Generator              Copyright (C) 1996 Scott Hall   '
'-------------------------------------------------------------------------   '
'This program is Copyright (C) 1996 Scott Hall. I grant permission for any   '
'person or company to use any of this program of portions thereof for any    '
'purpose except where the subsequent product:                                '
'                                                                            '
' a) is not available to the public free of charge.                          '
' b) is called "FrontDoor Statistics Generator" or "FDSTAT"                  '
'                                                                            '
'If you use this program, or portions thereof, you accept the above condions.'                                                         '
'                                                                            '
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

DECLARE SUB ASCIItoASL (X%)
DECLARE FUNCTION AnsiColor$ (Attr AS INTEGER)
DECLARE SUB SaveAscScrn (FileNum AS INTEGER, Title AS INTEGER)
DECLARE SUB SaveAslScrn (FileNum AS INTEGER)
DECLARE SUB SaveAnsiScrn (FileNum AS INTEGER)

DEFINT A-Z
FUNCTION AnsiColor$ (Attr AS INTEGER)

   ForeColor = Attr AND &H7
   BackColor = (Attr AND &H70) / 16

   IF Attr AND &H8 THEN
     Bold = 1
   ELSE
     Normal = 1
   END IF
   IF Attr AND &H80 THEN Blink = 1

   Fore$ = MID$("3034323631353337", (ForeColor * 2) + 1, 2)
   Back$ = MID$("4044424641454347", (BackColor * 2) + 1, 2)

   TmpStr$ = CHR$(27) + "["
   IF Normal = 1 THEN TmpStr$ = TmpStr$ + "0;"

   IF Bold THEN TmpStr$ = TmpStr$ + "1;"
   IF Blink THEN TmpStr$ = TmpStr$ + "5;"
    
   AnsiColor$ = TmpStr$ + Fore$ + ";" + Back$ + "m"

END FUNCTION

DEFSNG A-Z
SUB ASCIItoASL (X%)

        IF X% = ASC("") THEN X% = ASC(" ")
        IF X% = ASC("") THEN X% = ASC(" ")
        IF X% = ASC("") THEN X% = ASC(" ")
        IF X% = ASC("") THEN X% = ASC("|")
        IF X% = ASC("") THEN X% = ASC("+")
        IF X% = ASC("") THEN X% = ASC("+")
        IF X% = ASC("") THEN X% = ASC("+")
        IF X% = ASC("") THEN X% = ASC("+")
        IF X% = ASC("") THEN X% = ASC("+")
        IF X% = ASC("") THEN X% = ASC("+")
        IF X% = ASC("") THEN X% = ASC("|")
        IF X% = ASC("") THEN X% = ASC("+")
        IF X% = ASC("") THEN X% = ASC("+")
        IF X% = ASC("") THEN X% = ASC("+")
        IF X% = ASC("") THEN X% = ASC("+")
        IF X% = ASC("") THEN X% = ASC("+")
        IF X% = ASC("") THEN X% = ASC("+")
        IF X% = ASC("") THEN X% = ASC("+")
        IF X% = ASC("") THEN X% = ASC("+")
        IF X% = ASC("") THEN X% = ASC("+")
        IF X% = ASC("") THEN X% = ASC("+")
        IF X% = ASC("") THEN X% = ASC("-")
        IF X% = ASC("") THEN X% = ASC("+")
        IF X% = ASC("") THEN X% = ASC("+")
        IF X% = ASC("") THEN X% = ASC("+")
        IF X% = ASC("") THEN X% = ASC("+")
        IF X% = ASC("") THEN X% = ASC("+")
        IF X% = ASC("") THEN X% = ASC("+")
        IF X% = ASC("") THEN X% = ASC("+")
        IF X% = ASC("") THEN X% = ASC("+")
        IF X% = ASC("") THEN X% = ASC("-")
        IF X% = ASC("") THEN X% = ASC("+")
        IF X% = ASC("") THEN X% = ASC("+")
        IF X% = ASC("") THEN X% = ASC("+")
        IF X% = ASC("") THEN X% = ASC("+")
        IF X% = ASC("") THEN X% = ASC("+")
        IF X% = ASC("") THEN X% = ASC("+")
        IF X% = ASC("") THEN X% = ASC("+")
        IF X% = ASC("") THEN X% = ASC("+")
        IF X% = ASC("") THEN X% = ASC("+")
        IF X% = ASC("") THEN X% = ASC("+")
        IF X% = ASC("") THEN X% = ASC("+")
        IF X% = ASC("") THEN X% = ASC("+")
        IF X% = ASC("") THEN X% = ASC("+")
        IF X% = ASC("") THEN X% = ASC(" ")
        IF X% = ASC("") THEN X% = ASC("*")
        IF X% = ASC("") THEN X% = ASC("a")
        IF X% = ASC("") THEN X% = ASC("b")

END SUB

SUB BBSScreens (FDStatOut AS INTEGER, BBS AS STRING, Node AS STRING)
DEFINT A-Z

SaveAscScrn FDStatOut, 0

IF BBS <> "" THEN

   ASCF = FREEFILE
   OPEN BBS + "FDSTAT" + Node + ".ASC" FOR OUTPUT AS #ASCF
   SaveAscScrn ASCF, -1
   CLOSE #ASCF

   ANSF = FREEFILE
   SHELL "if exist " + BBS + "FDSTAT" + Node + ".ANS del " + BBS + "FDSTAT" + Node + ".ANS >NUL"
   OPEN BBS + "FDSTAT" + Node + ".ANS" FOR BINARY ACCESS WRITE AS #ANSF
   SaveAnsiScrn ANSF
   CLOSE #ANSF

   ASLF = FREEFILE
   OPEN BBS + "FDSTAT" + Node + ".ASL" FOR OUTPUT AS #ASLF
   SaveAslScrn ASLF
   CLOSE #ANSF

END IF

END SUB

DEFSNG A-Z
SUB DrawScreen (VERSION$)
'-----------------------
' Draw the main screen
'-----------------------
COLOR 5, 7: PRINT " ";
COLOR 0, 7: PRINT " FrontDoor Statistics Generator        Scott Hall 3:712/393 shall@world.net ";
COLOR 5, 7: PRINT " "
COLOR 0, 7
LOCATE 1, 35
PRINT VERSION$

COLOR 7, 0: PRINT "";
COLOR 11, 0: PRINT "";
COLOR 14, 1: PRINT " Processing Window ";
COLOR 11, 0: PRINT "͸";
COLOR 7, 0: PRINT "";
PRINT "";
COLOR 11, 0: PRINT "                                                                            ";
COLOR 7, 0: PRINT "";
PRINT "";
COLOR 11, 0: PRINT "                                                                            ";
COLOR 7, 0: PRINT "";
PRINT "";
COLOR 11, 0: PRINT "                                                                            ";
COLOR 7, 0: PRINT "";
PRINT "";
COLOR 11, 0: PRINT "";
COLOR 14, 1: PRINT " Incoming/Outgoing Polls ";
COLOR 11, 0: PRINT "͵";
COLOR 7, 0: PRINT "";
PRINT "";
COLOR 11, 0: PRINT "";
COLOR 7, 0: PRINT " ";
COLOR 13, 0: PRINT "Pollers";
COLOR 7, 0: PRINT "/";
COLOR 13, 0: PRINT "ings  TX";
COLOR 7, 0: PRINT "/";
COLOR 13, 0: PRINT "RX bytes TX";
COLOR 7, 0: PRINT "/";
COLOR 13, 0: PRINT "RX Rate";
COLOR 11, 0: PRINT "";
COLOR 7, 0: PRINT " ";
COLOR 13, 0: PRINT " Pollers";
COLOR 7, 0: PRINT "/";
COLOR 13, 0: PRINT "ings  TX";
COLOR 7, 0: PRINT "/";
COLOR 13, 0: PRINT "RX bytes TX";
COLOR 7, 0: PRINT "/";
COLOR 13, 0: PRINT "RX Rate";
COLOR 11, 0: PRINT "";
COLOR 7, 0: PRINT "";
PRINT "";
COLOR 11, 0: PRINT "";
COLOR 7, 0: PRINT "<2.4:";
COLOR 3, 0: PRINT "  0";
COLOR 7, 0: PRINT "/";
COLOR 3, 0: PRINT "  0 ";
COLOR 3, 0: PRINT "   0";
COLOR 7, 0: PRINT "k/";
COLOR 3, 0: PRINT "   0";
COLOR 7, 0: PRINT "k    ";
COLOR 3, 0: PRINT "0";
COLOR 7, 0: PRINT "/   ";
COLOR 3, 0: PRINT "0";
COLOR 7, 0: PRINT "CPS";
COLOR 11, 0: PRINT "";
COLOR 7, 0: PRINT " 19.2:";
COLOR 3, 0: PRINT "  0";
COLOR 7, 0: PRINT "/";
COLOR 3, 0: PRINT "  0";
COLOR 7, 0: PRINT "    ";
COLOR 3, 0: PRINT "0";
COLOR 7, 0: PRINT "k/   ";
COLOR 3, 0: PRINT "0";
COLOR 7, 0: PRINT "k";
COLOR 7, 0: PRINT "    ";
COLOR 3, 0: PRINT "0";
COLOR 7, 0: PRINT "/   ";
COLOR 3, 0: PRINT "0";
COLOR 7, 0: PRINT "CPS";
COLOR 11, 0: PRINT "";
COLOR 7, 0: PRINT "";
PRINT "";
COLOR 11, 0: PRINT "";
COLOR 7, 0: PRINT " 4.8:";
COLOR 3, 0: PRINT "  0";
COLOR 7, 0: PRINT "/";
COLOR 3, 0: PRINT "  0";
COLOR 3, 0: PRINT "    0";
COLOR 7, 0: PRINT "k/";
COLOR 3, 0: PRINT "   0";
COLOR 7, 0: PRINT "k  ";
COLOR 14, 0: PRINT "  ";
COLOR 3, 0: PRINT "0";
COLOR 7, 0: PRINT "/   ";
COLOR 3, 0: PRINT "0";
COLOR 7, 0: PRINT "CPS";
COLOR 11, 0: PRINT "";
COLOR 7, 0: PRINT " 21.6:";
COLOR 3, 0: PRINT "  0";
COLOR 7, 0: PRINT "/";
COLOR 3, 0: PRINT "  0";
COLOR 7, 0: PRINT "    ";
COLOR 3, 0: PRINT "0";
COLOR 7, 0: PRINT "k/   ";
COLOR 3, 0: PRINT "0";
COLOR 7, 0: PRINT "k";
COLOR 15, 0: PRINT " ";
COLOR 7, 0: PRINT "   ";
COLOR 3, 0: PRINT "0";
COLOR 7, 0: PRINT "/   ";
COLOR 3, 0: PRINT "0";
COLOR 7, 0: PRINT "CPS";
COLOR 11, 0: PRINT "";
COLOR 7, 0: PRINT "";
PRINT "";
COLOR 11, 0: PRINT "";
COLOR 7, 0: PRINT " 7.2:";
COLOR 3, 0: PRINT "  0";
COLOR 7, 0: PRINT "/";
COLOR 3, 0: PRINT "  0";
COLOR 3, 0: PRINT "    0";
COLOR 7, 0: PRINT "k/";
COLOR 3, 0: PRINT "   0";
COLOR 7, 0: PRINT "k    ";
COLOR 3, 0: PRINT "0";
COLOR 7, 0: PRINT "/   ";
COLOR 3, 0: PRINT "0";
COLOR 7, 0: PRINT "CPS";
COLOR 11, 0: PRINT "";
COLOR 7, 0: PRINT " 24.0:";
COLOR 3, 0: PRINT "  0";
COLOR 7, 0: PRINT "/";
COLOR 3, 0: PRINT "  0";
COLOR 7, 0: PRINT "    ";
COLOR 3, 0: PRINT "0";
COLOR 7, 0: PRINT "k/   ";
COLOR 3, 0: PRINT "0";
COLOR 7, 0: PRINT "k";
COLOR 15, 0: PRINT " ";
COLOR 7, 0: PRINT "   ";
COLOR 3, 0: PRINT "0";
COLOR 7, 0: PRINT "/   ";
COLOR 3, 0: PRINT "0";
COLOR 7, 0: PRINT "CPS";
COLOR 11, 0: PRINT "";
COLOR 7, 0: PRINT "";
PRINT "";
COLOR 11, 0: PRINT "";
COLOR 7, 0: PRINT " 9.6:";
COLOR 3, 0: PRINT "  0";
COLOR 7, 0: PRINT "/";
COLOR 3, 0: PRINT "  0";
COLOR 3, 0: PRINT "    0";
COLOR 7, 0: PRINT "k/";
COLOR 3, 0: PRINT "   0";
COLOR 7, 0: PRINT "k    ";
COLOR 3, 0: PRINT "0";
COLOR 7, 0: PRINT "/   ";
COLOR 3, 0: PRINT "0";
COLOR 7, 0: PRINT "CPS";
COLOR 11, 0: PRINT "";
COLOR 7, 0: PRINT " 26.4:";
COLOR 3, 0: PRINT "  0";
COLOR 7, 0: PRINT "/";
COLOR 3, 0: PRINT "  0";
COLOR 7, 0: PRINT "    ";
COLOR 3, 0: PRINT "0";
COLOR 7, 0: PRINT "k/";
COLOR 3, 0: PRINT "   0";
COLOR 7, 0: PRINT "k";
COLOR 15, 0: PRINT " ";
COLOR 7, 0: PRINT "   ";
COLOR 3, 0: PRINT "0";
COLOR 7, 0: PRINT "/   ";
COLOR 3, 0: PRINT "0";
COLOR 7, 0: PRINT "CPS";
COLOR 11, 0: PRINT "";
COLOR 7, 0: PRINT "";
PRINT "";
COLOR 11, 0: PRINT "";
COLOR 7, 0: PRINT "12.0:";
COLOR 3, 0: PRINT "  0";
COLOR 7, 0: PRINT "/";
COLOR 3, 0: PRINT "  0";
COLOR 7, 0: PRINT " ";
COLOR 3, 0: PRINT "   0";
COLOR 7, 0: PRINT "k/";
COLOR 3, 0: PRINT "   0";
COLOR 7, 0: PRINT "k    ";
COLOR 3, 0: PRINT "0";
COLOR 7, 0: PRINT "/   ";
COLOR 3, 0: PRINT "0";
COLOR 7, 0: PRINT "CPS";
COLOR 11, 0: PRINT "";
COLOR 7, 0: PRINT " 28.8:";
COLOR 3, 0: PRINT "  0";
COLOR 7, 0: PRINT "/";
COLOR 3, 0: PRINT "  0";
COLOR 7, 0: PRINT "    ";
COLOR 3, 0: PRINT "0";
COLOR 7, 0: PRINT "k/   ";
COLOR 3, 0: PRINT "0";
COLOR 7, 0: PRINT "k";
COLOR 15, 0: PRINT " ";
COLOR 7, 0: PRINT "   ";
COLOR 3, 0: PRINT "0";
COLOR 7, 0: PRINT "/   ";
COLOR 3, 0: PRINT "0";
COLOR 7, 0: PRINT "CPS";
COLOR 11, 0: PRINT "";
COLOR 7, 0: PRINT "";
PRINT "";
COLOR 11, 0: PRINT "";
COLOR 7, 0: PRINT "14.4:";
COLOR 3, 0: PRINT "  0";
COLOR 7, 0: PRINT "/";
COLOR 3, 0: PRINT "  0";
COLOR 7, 0: PRINT " ";
COLOR 3, 0: PRINT "   0";
COLOR 7, 0: PRINT "k/";
COLOR 3, 0: PRINT "   0";
COLOR 7, 0: PRINT "k    ";
COLOR 3, 0: PRINT "0";
COLOR 7, 0: PRINT "/   ";
COLOR 3, 0: PRINT "0";
COLOR 7, 0: PRINT "CPS";
COLOR 11, 0: PRINT "";
COLOR 7, 0: PRINT " 31.2:";
COLOR 3, 0: PRINT "  0";
COLOR 7, 0: PRINT "/";
COLOR 3, 0: PRINT "  0";
COLOR 7, 0: PRINT "    ";
COLOR 3, 0: PRINT "0";
COLOR 7, 0: PRINT "k/   ";
COLOR 3, 0: PRINT "0";
COLOR 7, 0: PRINT "k";
COLOR 15, 0: PRINT " ";
COLOR 7, 0: PRINT "   ";
COLOR 3, 0: PRINT "0";
COLOR 7, 0: PRINT "/   ";
COLOR 3, 0: PRINT "0";
COLOR 7, 0: PRINT "CPS";
COLOR 11, 0: PRINT "";
COLOR 7, 0: PRINT "";
'
PRINT "";
COLOR 11, 0: PRINT "";
COLOR 7, 0: PRINT "16.8:";
COLOR 3, 0: PRINT "  0";
COLOR 7, 0: PRINT "/";
COLOR 3, 0: PRINT "  0";
COLOR 7, 0: PRINT " ";
COLOR 3, 0: PRINT "   0";
COLOR 7, 0: PRINT "k/";
COLOR 3, 0: PRINT "   0";
COLOR 7, 0: PRINT "k    ";
COLOR 3, 0: PRINT "0";
COLOR 7, 0: PRINT "/   ";
COLOR 3, 0: PRINT "0";
COLOR 7, 0: PRINT "CPS";
COLOR 11, 0: PRINT "";
COLOR 7, 0: PRINT " 33.6:";
COLOR 3, 0: PRINT "  0";
COLOR 7, 0: PRINT "/";
COLOR 3, 0: PRINT "  0";
COLOR 7, 0: PRINT "    ";
COLOR 3, 0: PRINT "0";
COLOR 7, 0: PRINT "k/   ";
COLOR 3, 0: PRINT "0";
COLOR 7, 0: PRINT "k";
COLOR 15, 0: PRINT " ";
COLOR 7, 0: PRINT "   ";
COLOR 3, 0: PRINT "0";
COLOR 7, 0: PRINT "/   ";
COLOR 3, 0: PRINT "0";
COLOR 7, 0: PRINT "CPS";
COLOR 11, 0: PRINT "";
COLOR 7, 0: PRINT "";
'
PRINT "";
COLOR 11, 0: PRINT "";
COLOR 14, 1: PRINT " Callers ";
COLOR 11, 0: PRINT "";
COLOR 14, 1: PRINT " File Transfers ";
COLOR 11, 0: PRINT "͵";
COLOR 7, 0: PRINT "";
PRINT "";
COLOR 11, 0: PRINT "";
COLOR 7, 0: PRINT "0.3:  ";
COLOR 3, 0: PRINT "0";
COLOR 7, 0: PRINT "  7.2:  ";
COLOR 3, 0: PRINT "0";
COLOR 7, 0: PRINT "  16.8:  ";
COLOR 3, 0: PRINT "0";
COLOR 7, 0: PRINT "  26.4:  ";
COLOR 3, 0: PRINT "0";
COLOR 11, 0: PRINT " ";
COLOR 13, 0: PRINT " TX ";
COLOR 7, 0: PRINT "DDn: ";
COLOR 3, 0: PRINT " 0";
COLOR 7, 0: PRINT " PKT: ";
COLOR 3, 0: PRINT " 0";
COLOR 7, 0: PRINT " TIC:  ";
COLOR 3, 0: PRINT "0";
COLOR 7, 0: PRINT " Other: ";
COLOR 3, 0: PRINT " 0";
COLOR 7, 0: PRINT " ";
COLOR 11, 0: PRINT "";
COLOR 7, 0: PRINT "";
PRINT "";
COLOR 11, 0: PRINT "";
COLOR 7, 0: PRINT "1.2:  ";
COLOR 3, 0: PRINT "0";
COLOR 7, 0: PRINT "  9.6:  ";
COLOR 3, 0: PRINT "0";
COLOR 7, 0: PRINT "  19.2:  ";
COLOR 3, 0: PRINT "0";
COLOR 7, 0: PRINT "  28.8:  ";
COLOR 3, 0: PRINT "0";
COLOR 11, 0: PRINT " ";
COLOR 13, 0: PRINT " RX ";
COLOR 7, 0: PRINT "DDn:  ";
COLOR 3, 0: PRINT "0";
COLOR 7, 0: PRINT " PKT:  ";
COLOR 3, 0: PRINT "0";
COLOR 7, 0: PRINT " TIC:  ";
COLOR 3, 0: PRINT "0";
COLOR 7, 0: PRINT " Other:  ";
COLOR 3, 0: PRINT "0";
COLOR 7, 0: PRINT " ";
COLOR 11, 0: PRINT "";
COLOR 7, 0: PRINT "";
PRINT "";
COLOR 11, 0: PRINT "";
COLOR 7, 0: PRINT "2.4:  ";
COLOR 3, 0: PRINT "0";
COLOR 7, 0: PRINT " 12.0:  ";
COLOR 3, 0: PRINT "0";
COLOR 7, 0: PRINT "  21.6:  ";
COLOR 3, 0: PRINT "0";
COLOR 7, 0: PRINT "  31.2:  ";
COLOR 3, 0: PRINT "0";
COLOR 11, 0: PRINT " ";
COLOR 7, 0: PRINT " Poller:";
COLOR 3, 0: PRINT "  0:00";
COLOR 7, 0: PRINT " Polling:";
COLOR 3, 0: PRINT "  0:00";
COLOR 7, 0: PRINT " $";
COLOR 3, 0: PRINT "  0.00";
COLOR 7, 0: PRINT " ";
COLOR 11, 0: PRINT "";
COLOR 7, 0: PRINT "";
PRINT "";
COLOR 11, 0: PRINT "";
COLOR 7, 0: PRINT "4.8:  ";
COLOR 3, 0: PRINT "0";
COLOR 7, 0: PRINT " 14.4:  ";
COLOR 3, 0: PRINT "0";
COLOR 7, 0: PRINT "  24.0:  ";
COLOR 3, 0: PRINT "0";
COLOR 7, 0: PRINT "  33.6:  ";
COLOR 3, 0: PRINT "0 ";
COLOR 11, 0: PRINT "";
COLOR 14, 1: PRINT " Errors ";
COLOR 11, 0: PRINT "͵";
COLOR 7, 0: PRINT "";
PRINT "";
COLOR 11, 0: PRINT " ";
COLOR 15, 0: PRINT "     Successful Connects:   ";
COLOR 10, 0: PRINT "0";
COLOR 7, 0: PRINT "       ";
COLOR 11, 0: PRINT "";
COLOR 7, 0: PRINT " Pollers:   ";
COLOR 3, 0: PRINT "0";
COLOR 7, 0: PRINT " RX Files:  ";
COLOR 3, 0: PRINT "0";
COLOR 7, 0: PRINT " Pwords:  ";
COLOR 3, 0: PRINT "0";
COLOR 7, 0: PRINT " ";
COLOR 11, 0: PRINT "";
COLOR 7, 0: PRINT "";
PRINT "";
COLOR 11, 0: PRINT " ";
COLOR 15, 0: PRINT "     Rejects:   ";
COLOR 11, 0: PRINT "0";
COLOR 7, 0: PRINT " ";
COLOR 15, 0: PRINT "Failed:  ";
COLOR 7, 0: PRINT " ";
COLOR 12, 0: PRINT "0";
COLOR 15, 0: PRINT "  ";
COLOR 7, 0: PRINT "     ";
COLOR 11, 0: PRINT "";
COLOR 7, 0: PRINT " Polling:   ";
COLOR 3, 0: PRINT "0";
COLOR 7, 0: PRINT " TX Files:  ";
COLOR 3, 0: PRINT "0";
COLOR 7, 0: PRINT " Others:  ";
COLOR 3, 0: PRINT "0";
COLOR 7, 0: PRINT " ";
COLOR 11, 0: PRINT "";
COLOR 7, 0: PRINT "";
PRINT "";
COLOR 11, 0: PRINT ";";
COLOR 7, 0: PRINT "";
'PRINT "";
COLOR 1, 0: PRINT "                         ";
COLOR 14, 0: PRINT " to ";
COLOR 1, 0: PRINT "                         ";

END SUB

SUB PressEnter (Pause AS INTEGER, Beeps AS INTEGER)

COLOR 17, 7
LOCATE 25, 1
PRINT " Press a key ";
COLOR 0, 0
LOCATE 25, 80

DO WHILE ik$ = ""
   ik$ = INKEY$
LOOP
COLOR 7, 0

IF ik$ = CHR$(27) THEN
   CLOSE #FDLogFile, #FDStatOut
   LOCATE 24, 72
   COLOR 14, 0
   PRINT " ABORTED!";
   LOCATE 25, 1
   COLOR 7, 0
   PRINT "             ";
   LOCATE 24, 1
   END
END IF

IF ik$ = "P" OR ik$ = "p" THEN Pause = 0: Beeps = 0
IF ik$ = "B" OR ik$ = "b" THEN Beeps = 0

LOCATE 25, 1
PRINT "             ";

END SUB

DEFINT A-Z
SUB SaveAnsiScrn (FileNum AS INTEGER)

Pad$ = "[0;37;40m"     'make white on black to begin with
FOR p = 1 TO 80
    Pad$ = Pad$ + ""
NEXT p

     CurAttr = -1
     rownum = 1
     LineOut$ = "[2J"     'Clear Screen
     FOR colnum = 1 TO 80
        CharVal = SCREEN(rownum, colnum)
        Attr = SCREEN(rownum, colnum, 1)
        IF Attr <> CurAttr THEN
          CurAttr = Attr
          AnsiCode$ = AnsiColor$(Attr)
          LineOut$ = LineOut$ + AnsiCode$
        END IF
        LineOut$ = LineOut$ + CHR$(CharVal)
     NEXT
     PUT #FileNum, , LineOut$
     PUT #FileNum, , Pad$

  CurAttr = -1
  FOR rownum = 6 TO 22
     LineOut$ = ""
     FOR colnum = 1 TO 80
        CharVal = SCREEN(rownum, colnum)
        IF rownum = 6 AND colnum = 2 THEN CharVal = 213
        IF rownum = 6 AND colnum = 79 THEN CharVal = 184
        Attr = SCREEN(rownum, colnum, 1)
        IF Attr <> CurAttr THEN
          CurAttr = Attr
          AnsiCode$ = AnsiColor$(Attr)
          LineOut$ = LineOut$ + AnsiCode$
        END IF
        LineOut$ = LineOut$ + CHR$(CharVal)
     NEXT
     PUT #FileNum, , LineOut$
  NEXT
 
  PUT #FileNum, , Pad$
  
     CurAttr = -1
     rownum = 23
     LineOut$ = ""
     FOR colnum = 1 TO 80
        CharVal = SCREEN(rownum, colnum)
        Attr = SCREEN(rownum, colnum, 1)
        IF Attr <> CurAttr THEN
          CurAttr = Attr
          AnsiCode$ = AnsiColor$(Attr)
          LineOut$ = LineOut$ + AnsiCode$
        END IF
        LineOut$ = LineOut$ + CHR$(CharVal)
     NEXT
     LineOut$ = LineOut$ + "[0;37;40m"   'Make white on black at end of file
     PUT #FileNum, , LineOut$

END SUB

DEFSNG A-Z
SUB SaveAscScrn (FileNum AS INTEGER, Title AS INTEGER)

IF Title THEN
   PRINT #FileNum, "Ŀ"
   PRINT #FileNum, "";
   FOR c% = 3 TO 78
       X% = SCREEN(1, c%)
       ASCIItoASL X%
       PRINT #FileNum, CHR$(X%);
   NEXT
   PRINT #FileNum, ""
   PRINT #FileNum, ""
END IF

FOR c% = 2 TO 79
    X% = SCREEN(23, c%)
    IF Title AND X% = ASC("") THEN X% = ASC(" ")
    PRINT #FileNum, CHR$(X%);
NEXT
PRINT #FileNum,
PRINT #FileNum,

FOR R% = 6 TO 22
    FOR c% = 2 TO 79
        X% = SCREEN(R%, c%)
        IF R% = 6 AND c% = 2 THEN X% = 213
        IF R% = 6 AND c% = 79 THEN X% = 184
        PRINT #FileNum, CHR$(X%);
    NEXT
    PRINT #FileNum,
NEXT

END SUB

SUB SaveAslScrn (FileNum AS INTEGER)

PRINT #FileNum, "------------------------------------------------------------------------------"
FOR c% = 2 TO 79
    X% = SCREEN(1, c%)
    ASCIItoASL X%
    PRINT #FileNum, CHR$(X%);
NEXT
PRINT #FileNum,
PRINT #FileNum, "------------------------------------------------------------------------------"


FOR c% = 2 TO 79
    X% = SCREEN(23, c%)
    ASCIItoASL X%
    IF CHR$(X%) = "-" THEN X% = ASC(" ")
    PRINT #FileNum, CHR$(X%);
NEXT
PRINT #FileNum,
PRINT #FileNum,

FOR R% = 6 TO 22
    FOR c% = 2 TO 79
        X% = SCREEN(R%, c%)
        IF R% = 6 AND c% = 2 THEN X% = 213
        IF R% = 6 AND c% = 79 THEN X% = 184
        ASCIItoASL X%
        PRINT #FileNum, CHR$(X%);
    NEXT
    PRINT #FileNum,
NEXT
       
END SUB

