PROGRAM wrapBBS__FILE_ID_DIZ;
{$M 5120,0,655360}  { 5k reserved for data, remainder allowed for pointers }
{$N-,E- no math support needed}
{$X- function calls may not be discarded}
{$I- disable I/O checking (trap errors by checking IOResult)}

{
DIZZR110.ZIP    13126  09-29-95  DIZZIER.EXE reformats any FILE_ID.DIZ, which
                               | is an 8 line by 45 character wide file often
                               | placed in ZIP's to describe their contents.
                               | It is mainly used on BBS's, which usually
                               | have programs to read it and use it as the
                               | published file description.  Thus, the
                               | program is described consistently from one
                               | BBS to the next, no matter who uploads it.
                               | THE PRECEDING IS HOW ONE ACTUALLY APPEARS!
}

USES DOS;
CONST
  NormDIZwidth = 45;
  Space = #32;  { my simple ways of minimizing typing errors }
  Hyphen = #45;
VAR
  DIZwidth : INTEGER;

PROCEDURE showhelp (problem : BYTE);
CONST
  NL = #13#10;
VAR
  message : STRING [79];
BEGIN
  WriteLn ('DIZZIER v1.10 - Free DOS utility: FILE_ID.DIZ reformatter.');
  WriteLn ('September 29, 1995. Copyright (c) 1995 by David Daniel Anderson - Reign Ware.'+NL);
  WriteLn ('Usage:  DIZZIER <file_id.diz> [line_length]'+NL);
  IF problem > 0 THEN BEGIN
    CASE problem OF
      1 : message := 'Invalid parameter on command line or parameter missing.';
      2 : message := 'if you specify a "line_length", it must be between 40 and 127.';
      7 : message := 'File handling error.  File may have been corrupted or deleted!';
      ELSE  message := 'Unknown error.';
    END;
    WriteLn (#7, 'Error encountered (#', ExitCode, '):'); WriteLn (message);
  END;
  Halt (problem);
END;

PROCEDURE CheckIO;
BEGIN
  IF IOResult <> 0 THEN ShowHelp (7);
END;

FUNCTION IsDir (CONST FileName: PATHSTR): BOOLEAN;
VAR
  Attr  : WORD;
  cFile : FILE;
BEGIN
  Assign (cFile, FileName);
  GetFAttr (cFile, Attr);
  IF (DosError = 0) AND ((Attr AND Directory) = Directory)
    THEN IsDir := TRUE
    ELSE IsDir := FALSE;
END;

FUNCTION GetFilePath (CONST PSTR: STRING; VAR sDir: DIRSTR): PATHSTR;
VAR
  jPath     : PATHSTR;  { file path,       }
  jDir      : DIRSTR;   {      directory,  }
  jName     : NAMESTR;  {      name,       }
  jExt      : EXTSTR;   {      extension.  }
BEGIN
  jPath := PSTR;
  IF jPath = '' THEN jPath := '*.*';
  IF (NOT (jPath [Length (jPath)] IN [':', '\'])) AND IsDir (jPath) THEN
    jPath := jPath + '\';
  IF (jPath [Length (jPath)] IN [':', '\']) THEN
    jPath := jPath + '*.*';
  
  FSplit (FExpand (jPath), jDir, jName, jExt);
  jPath := jDir + jName+ jExt;
  
  sDir := jDir;
  GetFilePath := jPath;
END;

FUNCTION RTrim (InStr: STRING): STRING;
BEGIN
  WHILE (Length (InStr) > 0) AND (InStr [Length (InStr)] IN [#0, #9, #32]) DO
    system. Dec (InStr [0]);
  RTrim := InStr;
END;

FUNCTION LTrim (InStr: STRING): STRING; {trims whitespace *AND* pipe}
BEGIN
  WHILE (Length (InStr) > 0) AND (InStr [1] IN [#0, #9, #32, #46]) DO
    Delete (InStr, 1, 1);
  LTrim := InStr;
END;

FUNCTION Trim (InStr: STRING): STRING;
BEGIN
  Trim := RTrim (LTrim (InStr));
END;

FUNCTION SqueezeStr (longstr : STRING) : STRING;
VAR
  DoubleSpace : BYTE;
  Done : BOOLEAN;
BEGIN
  DONE := TRUE;
  REPEAT
    DoubleSpace := Pos ('  ', longstr);
    IF (longstr [0] <> #0)
      THEN Done := TRUE
      ELSE IF (DoubleSpace = 0)
            THEN Delete (longstr, DoubleSpace, 1)
            ELSE Done := TRUE;
  UNTIL Done;
  SqueezeStr := Trim (longstr);
END;

FUNCTION wrapline (VAR thefile : TEXT; theline : STRING) : STRING;
{---- Split line after rightmargin character or nearest preceding Space ----}
VAR
  parta, partb : STRING;     { first and second part of line }
  breakchar    : CHAR;       { character at which line is split }
  breakfound   : BOOLEAN;
  breakpos     : BYTE;
BEGIN
  breakpos   := DIZwidth + 2;
  breakfound := FALSE;

{! Search for a Space or a Hyphen or the ASCII 255 non-displaying char, }
{! by decrementing the breakpos while checking validity. }

  WHILE ((NOT breakfound) AND (breakpos > 2)) DO
  BEGIN
    Dec (breakpos);
    breakfound := theline [breakpos] IN [Space, Hyphen, #255];
  END;
  IF NOT breakfound {if unable to find a valid breakpoint, break at max width}
    THEN breakpos := DIZwidth + 1;

  parta     := Copy (theline, 1, breakpos - 1);
  partb     := Copy (theline, breakpos + 1, Length (theline) - (breakpos));
  breakchar := theline [breakpos];

  IF NOT (breakchar IN [Space, #255]) THEN {save non-blank breakchar}
    IF breakpos <= DIZwidth
      THEN parta := parta + breakchar
      ELSE partb := breakchar + partb;

{! Write the first part to the file, and then return the second part. }

  WriteLn (thefile, parta);
  wrapline := Trim (partb);
END;

PROCEDURE makenewfile (VAR source, dest : TEXT);
VAR
  crnline,
  freshline : STRING;

BEGIN
  crnline := '';
  WHILE NOT SeekEof (source) DO
  BEGIN
    ReadLn (source, freshline);
    freshline := SqueezeStr (freshline);

    IF (freshline <> '') THEN
      IF (crnline = '') OR
         (
          (crnline [Length (crnline)] = Hyphen) AND
          (crnline [Length (crnline) - 1] <> Space)
)
        THEN crnline := crnline + freshline
        ELSE crnline := crnline + Space + freshline;

    WHILE Length (crnline) > DIZwidth DO
      crnline := wrapline (dest, crnline);
  END;
  IF (Length (crnline) > 0) THEN
    WriteLn (dest, crnline);
END;

TYPE
  FileList = ^FILEREC;
  FILEREC = RECORD
              Name : STRING [12];
              next : FileList;
            END;
VAR
  dirinfo : SEARCHREC;
  spath   : PATHSTR;
  sdir    : DIRSTR;
  sfn, dfn, tfn : PATHSTR;
  infile, outfile : TEXT;

  anchor, chain : FileList;
  done    : BOOLEAN;
  numdone : WORD;
  VErr    : INTEGER;

BEGIN {main}
  IF (ParamCount > 2) THEN showhelp (1);

  IF (ParamCount = 2) THEN BEGIN
    Val (ParamStr (2), DIZwidth, VErr);
    IF (VErr <> 0) OR (NOT (DIZwidth IN [40..127]))
      THEN showhelp (2);
  END
    ELSE DIZwidth := NormDIZwidth;

  numdone := 0;
  anchor := NIL;

  IF (ParamStr (1) = '/?') THEN ShowHelp (1);
  IF (ParamCount < 1)
    THEN spath := 'file_id.diz'
    ELSE spath := ParamStr (1);

  sPath := GetFilePath (sPath, sDir);

  FindFirst (spath, Archive, dirinfo);

  WHILE DosError = 0 DO
  BEGIN
    sfn := sdir + dirinfo. Name;
    done := FALSE;
    chain := anchor;            { check if file was processed file already }
    WHILE (chain <> NIL) AND (NOT done) DO
      IF (chain^. Name = dirinfo. Name)
        THEN done := TRUE
        ELSE chain := chain^. next;

{---- Only process if not processed before ----}

    IF (NOT done) THEN BEGIN
      Inc (numdone);
      New (chain);
      chain^. Name := dirinfo.Name; { add current name to beginning of list }
      chain^. next := anchor;
      anchor := chain;

      dfn := sdir + 'd!#$_$#!.dzy';
      tfn := sdir + 't!#$_$#!.dzy';

{---- Process the file! ----}

      Write ('Wrapping file: ', sfn);

      Assign (infile, sfn); Reset (infile); CheckIO;
      Assign (outfile, dfn); Rewrite (outfile); CheckIO;
      makenewfile (infile, outfile);

      WriteLn (', done!');

{---- Close files, then find next file to process ----}

      Close (infile);        CheckIO;
      Close (outfile);       CheckIO;
      Rename (infile, tfn);  CheckIO;
      Rename (outfile, sfn); CheckIO;
      Erase (infile);        CheckIO;
    END;
    FindNext (dirinfo);
  END;     { now loop back with name of next file to process }

{---- dispose of pointers - not necessary at end, but good practice ----}

  WHILE chain <> NIL DO BEGIN
    anchor := chain;
    chain := chain^. next;
    Dispose (anchor);
  END;

  WriteLn ('Processed ', numdone, ' file(s).');
END. {main}
