/*
                 __,,---,__ _    __,,--, __ _
                 |  ___/---,,__,-|  ___//___,,----,______,,---,__ __ _
       _ __ _____|  \_   _  \_   | \\_  __  \_  __   (___)      \ tdmHz
           \\_  __  _|   ____|_ \_/  |  \|   |  \|   | \_   |__//_
            _|  \|  \__  |/  _// |   |_  |  _|   |  _|  _|   |'  _/'' '
     ==== = \\     ___// '  _|   |____/' ' \\____| \\___\__      | = ====
   - -- ---- \____// \_____/__,,-'   \\__,,---'  |____/   \\_,,--' --- -- -
            daydream bbs : saturn dreamlogin recode for glibc2 by esc
    It's just a silly litebar quicklogin menu that really is superfluous but
    looks good, and I could use the coding practice!

    Extra thanks to Mercyful Fate for helping me learn to code :)
    AAaaaan for being my principal debugger!

    Based on MCE-DL.ZIP, 15-10-98, by Skywalker/Menace
*/


#include <dd.h>
#include "ddlib.h"
#include <stdio.h>

struct dif *d;

#define LITEBAR_X_CHAT  20		// X coord for chat string
#define LITEBAR_X_1	20		// First x coord for litebar
#define LITEBAR_X_2	20		// Second x coord for litebar
#define LITEBAR_X_3	20		// Third x coord for litebar

#define LITEBAR_Y_CHAT  11		// X coord for chat string
#define LITEBAR_Y_1	5		// First y coord for litebar
#define LITEBAR_Y_2	6		// Second y coord for litebar
#define LITEBAR_Y_3	7		// Third y coord for litebar

// Next, all the litebar choices, first on, then off.  Ansi codes apply!

#define CHOICE_1_ON	"\e[0m\e[44m N \e[40m\e[37m"
#define CHOICE_2_ON	"\e[0m\e[44m F \e[40m\e[37m"
#define CHOICE_3_ON	"\e[0m\e[44m Q \e[40m\e[37m"

#define CHOICE_1_OFF	"\e[33m N \e[37m"
#define CHOICE_2_OFF	"\e[33m F \e[37m"
#define CHOICE_3_OFF	"\e[33m Q \e[37m"

// Finally, sysop chat strings for available, not available

#define CHAT_OFF	"\e[37m\e[44m SysOp is \e[36MNOT \e[37mAvailable at the moment! \e[40m\e[37m"
#define CHAT_ON 	"\e[37m\e[44m SysOp \e[36mIS \e[37mcurrently available for chat!\e[40m\e[37m"

// That should be it for strings!  Now put it into arrays

char *choices_on[] = {
	CHOICE_1_ON, CHOICE_1_ON, CHOICE_2_ON, CHOICE_3_ON,
	};

char *choices_off[] = {
	CHOICE_1_OFF, CHOICE_1_OFF, CHOICE_2_OFF, CHOICE_3_OFF,
	};

int choices_x[] = {
	LITEBAR_X_1, LITEBAR_X_1, LITEBAR_X_2, LITEBAR_X_3,
	};

int choices_y[] = {
	LITEBAR_Y_1, LITEBAR_Y_1, LITEBAR_Y_2, LITEBAR_Y_3,
	};

int choice = 2;

// dd_ansipos structure used in a lot of mods, i believe from rezine
void dd_ansipos(struct dif *d, int x, int y)
{
char tmpstring[10];
  sprintf(tmpstring,"\e[%i;%iH",y,x);
  dd_sendstring(d,tmpstring);
}

// login_choices is the main program loop
void login_choices(void)
{
  int changed=0;	// Has an arrow-key been pressed?
  int chosen=0;		// for loop - has decision been made?
  int c = 0;		// Stores our keypress

  dd_ansipos(d,1,1);	// Goes to home cursor

  // Draw the header
  dd_typefile(d,"dreamlogin",TYPE_MAKE); // Display header

  //Must draw lightbars 1 time before loop, to show the default position.
          dd_ansipos(d,choices_x[1],choices_y[1]);
          dd_sendstring(d,choices_off[1]);
          dd_ansipos(d,choices_x[2],choices_y[2]);
          dd_sendstring(d,choices_on[2]);
          dd_ansipos(d,choices_x[3],choices_y[3]);
          dd_sendstring(d,choices_off[3]);
	  dd_ansipos(d,LITEBAR_X_CHAT,LITEBAR_Y_CHAT);
	  dd_sendstring(d,CHAT_ON);

  while(chosen == 0)
  {

	dd_ansipos(d,1,1);
  	c = dd_hotkey(d, HOT_CURSOR);

  	switch(c)
	{
	  case 'N' : choice = 1; return; break;
	  case 'n' : choice = 1; return; break;
	  case 'F' : choice = 2; return; break;
	  case 'f' : choice = 2; return; break;
	  case 'Q' : choice = 3; return; break;
	  case 'q' : choice = 3; return; break;
	  case 13 : return; break;
	  case 250:	//up arrow key
	    if(choice == 1)
		choice = 3;
	    else
	        --choice;
	    changed = 1;
	    chosen = 0;
  	    break;
	  case 251:	//down arrow key
	    if(choice == 3)
		choice = 1;
	    else
	      ++choice;
	    changed = 1;
	    chosen = 0;
	    break;
	}

	// redraw changed lightbars
         if (changed != 0) {
           dd_ansipos(d,choices_x[1],choices_y[1]);
           dd_sendstring(d,choices_off[1]);
           dd_ansipos(d,choices_x[2],choices_y[2]);
           dd_sendstring(d,choices_off[2]);
           dd_ansipos(d,choices_x[3],choices_y[3]);
           dd_sendstring(d,choices_off[3]);
           dd_ansipos(d,choices_x[choice],choices_y[choice]);
           dd_sendstring(d,choices_on[choice]);
           changed = 0;
         }
	if(chosen != 0)
	break;
  }
}

int main(int argc, char *argv[])
{
  char buf[1024];
  int i;

  if (argc==1)
  {
    printf("Must be run from DayDream, foo!\n");
    exit(1);
  }

  d=dd_initdoor(argv[1]);
  if (d==0)
  {
    printf("Couldn't find socket!!\n");
    exit(1);
  }

  dd_changestatus(d, "dreamlogin!");

  login_choices();  //main program loop

  if(choice == 1)
    dd_typefile(d, "lgnorm", TYPE_MAKE|TYPE_WARN);
  else if(choice == 3)
    dd_typefile(d, "lgquick", TYPE_MAKE|TYPE_WARN);
  else
    dd_typefile(d, "lgfull", TYPE_MAKE|TYPE_WARN);

  dd_close(d); // done-zo.
}
