import struct
import sys
import os

def parse_xex(filename):
    with open(filename, "rb") as f:
        data = f.read()

    file_size = len(data)

    # Check header
    if data[0:2] != b'\xFF\xFF':
        raise ValueError("Not a valid Atari XEX/OBX file (missing $FF $FF header)")

    pos = 2
    seg_num = 1

    while pos + 4 <= len(data):
        load, end = struct.unpack_from("<HH", data, pos)
        pos += 4

        size = end - load + 1
        if size < 0:
            raise ValueError(f"Invalid segment size at {seg_num}")

        # HEX size + DECIMAL size
        print(
            f"{seg_num:03d}: "
            f"${load:>5X} ${end:>5X}: "
            f"${size:>5X} {size:>5} bytes"
            )

        # INIT vector?
        if load == 0x02E2 and end == 0x02E3:
            init_addr = struct.unpack_from("<H", data, pos)[0]
            print(f"INI: $ {init_addr:0X}")

        pos += size
        seg_num += 1

    intro_limit = 1024
    shave = file_size - intro_limit
    
    # https://vascosim.medium.com/how-to-print-colored-text-in-python-52f6244e2e30
    
    os.system("") # enable ANSII
    print(f"{filename} seems OK...")
    print(f"{file_size} bytes total...", end=" ")

    if shave > 0:
        print(f"Shave \033[41m {shave} \033[0m bytes to reach 1024!")
    elif shave < 0:
        print(f"\033[42m {-shave} \033[0m bytes free to reach 1024!")
    else:
        print(f"\033[44m Exactly 1024 bytes \033[0m – perfect intro size!")

if __name__ == "__main__":
    if len(sys.argv) != 2:
        print("Usage: python chkxex.py <file.xex>")
        sys.exit(1)

    parse_xex(sys.argv[1])
