//*************************************************************************************************
//
// Snowflake VIC20 by ssusnic, 20.12.2025.
//
// Commodore VIC20 entry for Vintage Computing Christmas Challenge 2025 (VCCC2025).
// Programmed in 6502 Assembly by using Kick Assembler.
//
// Instructions for running the program:
//  - start the VICE VIC20 emulator
//  - drag and drop "snowflake58b.prg" into it
//
// Copyright (C) 2025 by Srdjan Susnic
//
//*************************************************************************************************

*=$1001 "Basic Stub"    // Basic Startup code
BasicUpstart(init)

*=$100D "Snowflake VIC20" // Main Program starts at $100D
init:
    pha                 // push A=0 onto stack so we can quit the program when pull 0 from stack
    ldx #10             // X=current row; it goes from 10 to -10 (X=0 reprents the central row)

do_rows:
    lda #13             // A=new line char
    jsr $FFD2           // print new line char to move the cursor to the beginning of the next row
    ldy #18             // Y=current output column on the right side
    dex                 // X=X-1 so X={10 (push 0), 9, 8, ..., 1, 0, -1, ..., -8, -9, -10 (pull 0)}
    beq set_star        // if X=0, we are at the central row so print only stars; here is ZP($60)=0
    bmi pull            // if X<0, get data from stack (lower half) else from memory (upper half)
        lda flake-1, x  // A=flake[X-1]; reads snowflake data from memory from bottom to top
        pha             // push A onto stack to use fetched data in reverse order in lower half 
        pha             // since PLA is the next instruction, push A onto stack again
    pull:
        pla             // pull snowflake data from stack into A
        beq quit        // if A=0 (pulled when X=-10), quit the program
        sta quit: $60   // store snowflake data in zeropage ZP($60); note: $60 is also RTS opcode
    set_space:
        lda #' '        // A=' ' (here each row except the central row starts with ' ')
    do_columns:
        jsr $FFD2       // print char in A on the left side
        sta ($D1), y    // print char in A on the right side
        lda #6          // A=6 (setting blue color)
        sta ($F3), y    // color the char printed on the right side in blue
        dey             // Y=Y-1 to go one column left so Y={18, 17, 16, ..., 9, 8}
        cpy #9          // if Y<9
        bmi do_rows     // then go to process the next row
        asl $60         // else shift snowflake data in ZP($60) to the left
        bcs set_space   // if shifted bit in carry is set (C=1) then print space
    set_star:           // else print star
        lda #'*'        // A='*' 
        bne do_columns  // go to process the next column

flake:                  // snowflake data table of its top-left part (star=0, space=1)
    .byte %10110110     // flake[0]; loaded when X=1 (row #8)
    .byte %01101101     // flake[1]; loaded when X=2 (row #7)
    .byte %11111011     // flake[2]; loaded when X=3 (row #6)
    .byte %11110110     // flake[3]; loaded when X=4 (row #5)
    .byte %10001101     // flake[4]; loaded when X=5 (row #4)
    .byte %11001111     // flake[5]; loaded when X=6 (row #3)
    .byte %10101110     // flake[6]; loaded when X=7 (row #2)
    .byte %11111101     // flake[7]; loaded when X=8 (row #1)
    .byte %11111111     // flake[8]; loaded when X=9 (row #0)
