

;execution:
;CALL #140A

begin equ #1402

;CPC 6128 values:
TXT_CURSOR equ #B726
TXT_OUTPUT equ #BB5A



;SNOWFLAKE BITMAP:
;db 00000000*				;this one is used but not explicitly stored
org begin
db %00000010; *
db %01010001;*   * *
db %00110000;    **
db %01110010; *  ***
db %00001001;*  *
db %00000100;  *
db %10010010; *  *  *
db %01001001;*  *  *
db %11111111;*********		;the execution begins here with a harmless RST#38
;    *  *  ***  *  *
;   *  *  * * *  *  *
;        *  *  *
;       *  ***  *
;    ***  * * *  ***
;     **    *    **
;    * *   ***   * *
;         * * *
;           *

;the flake is plotted around the center 10,10 (locate 11,11 in basic)

;initial conditions:
;DE=#140A (calling address from basic)
;D=20 used to mirror the coordinates, E=10 used for initialization of loops
;H=1 because called from basic

;set coords for the 2 right/leftmost points
ld l,e					;y = 10
call plot_two_stars		;draw right/leftmost points

;run through y and x from 10 to 1
loop_y:
	ld b,e				;x = 10
	scf					;first one (x=10) is always plotted (vertical axis)
	loop_x:
		ld h,b			;h = x for plotting
		call c,plot_four_stars
		ld h,d			;h = highbyte of the bitmap table
		srl (hl)		;shift next bit, replace by 0 for outer edges
		djnz loop_x
	dec l
	jr nz,loop_y
ret

plot_four_stars:
	call mirror_y_and_plot_two_stars

mirror_y_and_plot_two_stars:
	ld a,d
	sub l
	ld l,a

plot_two_stars:
	call mirror_x_and_plot_one_star

mirror_x_and_plot_one_star:
	ld a,d
	sub h
	ld h,a

;plot one star
	ld (TXT_CURSOR),hl		;locate
	ld a,"*"
	jp TXT_OUTPUT			;plot

length equ $-begin			;48 bytes
