; A very small, size optimized assembly program
; for Vintage Computer Christmas Challenge 2025

; Use of registers
; HL: draw direction
; DE: start position
; B: steps

; Initial register state
; A = 0CH	; cassette control bits
; HL = 0A01H	; start address
; BC = 0000H	; left zero from ldir
; DE = 0A5FH	; end address

CURSO:	EQU	0B7A0H
CRT:	EQU	0E329H

X_MID:	EQU	20
Y_MID:	EQU	16

	ORG	0A01H

	; vertical arm
	LD	D,C
	LD	E,C
	LD	B,H
	LD	H,C
	CALL	DRAW_MIRROR

	; diagonal arm
	LD	B,8
	INC	H
	CALL	DRAW_MIRROR

	; small arm 1
	LD	E,3
	LD	B,E
	CALL	DRAW_MIRROR

	; small arm 2
	LD	E,6
	CALL	DRAW_MIRROR

	; small arm 3
	DEC	E
	LD	D,E
	DEC	L

; DE = position
;
DRAW_MIRROR:

	PUSH	DE
	PUSH	BC

.DRAW_MIRROR_LOOP:

	CALL	DRAW_MIRROR_H

	; diagonally
	PUSH	DE
	LD	A,D
	LD	D,E
	LD	E,A
	CALL	DRAW_MIRROR_H
	POP	DE

	; advance position
	LD	A,D
	ADD	H
	LD	D,A

	LD	A,E
	ADD	L
	LD	E,A

	DJNZ	.DRAW_MIRROR_LOOP

	POP	BC
	POP	DE

	RET

; DE = position
;
DRAW_MIRROR_H:

	CALL	DRAW_MIRROR_V

	; h axis
	PUSH	DE
	LD	A,E
	NEG	A
	LD	E,A
	CALL	DRAW_MIRROR_V
	POP	DE

	RET

DRAW_MIRROR_V:

	CALL	DRAW_TRANSFORMED

	; v axis
	PUSH	DE
	LD	A,D
	NEG	A
	LD	D,A
	CALL	DRAW_TRANSFORMED
	POP	DE

	RET

; DE = position
;
DRAW_TRANSFORMED:

	LD	A,E
	ADD	Y_MID
	LD	(CURSO+1),A
	LD	A,D
	ADD	X_MID
	LD	(CURSO),A
	LD	A,'*'
	JP	CRT
