; Copyright (C) 2025 Colin Leroy-Mira <colin@colino.net>

STAR        := $AA
CH          := $00            ; Contains zero on boot
BASL        := $28
BASCALC     := $FBC1

BOOT_SECTORS_COUNT = *
.assert * = $800, error
.byte           1

.proc vccc2025
        ldx     #9            ; Init line 9, column is 0 from clear
        jsr     put_h_stars_x ; And put the two left and right-most stars

next_line:
        ldy     #9            ; Init column 9
        sty     CH
next_col:
        bcs     :+
        jsr     put_h_stars_x ; First do left/right symmetry
        lda     mirror,x      ; mirror vertically
        jsr     put_h_stars_a ; do the other couple, vertically
:       lsr     data,x        ; Get next bit from data to carry
        dec     CH
        bne     next_col      ; Done at zero!

        dex                   ; Decrement line,
        bpl     next_line     ; continue if >= 0
done:   bmi     done

put_h_stars_x:
        txa                   ; Get current line
put_h_stars_a:                ; Draw two horizontally symmetrical stars
        jsr     BASCALC
        ldy     CH            ; First one on the left,
        lda     #STAR
        sta     (BASL),y

        lda     mirror,y      ; Mirror CH
        tay
        lda     #STAR         ; Second one on the right
        sta     (BASL),y
        rts

data:       .byte %11111111   ; Each byte represents one line in the top-left quarter
            .byte %11111101
            .byte %10101110
            .byte %11001111
            .byte %10001101
            .byte %11110110
            .byte %11111011
            .byte %01101101
            .byte %10110110
            .byte %00000000

mirror:     .byte 18,17,16,15 ; Mirror (0-9 => 18-9)
            .byte 14,13,12,11
            .byte 10,9
.endproc
