	org 0x100

start:	mov si,rowdata
	call half
	mov ax,511	; full line
	call line
	dec si
	std		; set df so half goes backwards
; fall thru
half:			; draw 9 rows
	mov cl,9
.loop:	lodsb		; al := [si++] (df=0) or [si--] (df=1)
	shl ax,1
	call line
	loop .loop
	ret

line:			; draw a row - (ax)*(ax reversed)\n
	call lbits
	mov dl,42
	call out
	call lbits
	mov dl,10
; fall thru
out:			; write a char from dl
	push ax
	mov ah,2
	int 0x21	; overwrites al
	pop ax
	ret

lbits:			; draw 9 bits from ax
	mov bl,8	; loop counter, and...
	xor byte [.loop+1],bl	; ... toggle rol/ror below (d1c8/d1c0)
.loop:	rol ax,1
	mov dl,32	; there must be a better way of doing this!
	jnc .sp
	mov dl,42
.sp:	call out
	dec bl
	jns .loop
	ret

rowdata:
	db 0,64,138,12,78,144,32,73,146
