struct VsUniforms {
    scale: f32,
    position: vec2<f32>,
    tex_start: vec2<f32>,
    tex_size: vec2<f32>,

    _pad: vec4f,
}

@group(0) @binding(0) var<uniform> vs_uniforms: VsUniforms;

struct VertexInput {
    @location(0) position: vec3<f32>,
    @location(1) normal: vec3<f32>,
    @location(2) tangent: vec3<f32>,
    @location(3) uv: vec2<f32>,
}

struct VertexOutput {
    @builtin(position) position: vec4<f32>,
    @location(0) uv: vec2<f32>,
}

struct FsUniforms {
    color: vec4<f32>,
    debug: f32,

    _pad: vec4f,

}

@group(1) @binding(0) var<uniform> uniforms: FsUniforms;
@group(1) @binding(1) var tex: texture_2d<f32>;
@group(1) @binding(2) var sampler_clamp_to_edge: sampler;


@vertex
fn vs_main(input: VertexInput) -> VertexOutput {
    let c = input.position.xz;
    let pos = c * vs_uniforms.tex_size * vs_uniforms.scale + vs_uniforms.position;
    
    var output: VertexOutput;
    output.position = vec4<f32>(pos, 0.0, 1.0);
    output.uv = input.uv * vs_uniforms.tex_size + vs_uniforms.tex_start;
    return output;
}

@fragment
fn fs_main(input: VertexOutput) -> @location(0) vec4<f32> {
    if (uniforms.debug > 0.0) {
        let tex_sample = textureSample(tex, sampler_clamp_to_edge, input.uv).r;
        return vec4<f32>(uniforms.color.rgb * vec3<f32>(0.4, 0.0, 0.1), uniforms.color.a * tex_sample + 0.4);
    }
    let tex_sample = textureSample(tex, sampler_clamp_to_edge, input.uv).r;
    return vec4<f32>(uniforms.color.rgb, uniforms.color.a * tex_sample);
}