in vec2 uv;

out vec4 C;

uniform float u_t;

#include scene_jyrevis25/common.glsl

float arrow(vec2 p){
    p*=rot(-PI/2.0);
    p.y*=-1.;
    p.y+=.5;
    vec2 q=abs(p.xy);
    float SQ2 = sqrt(2.);
    float arrow2d = min(max(q.x,p.y),max(-(p.y-1.5), (q.x+(p.y-1.5))*SQ2));
    return arrow2d-1.;
}

void main() {
    vec2 UV=vec2(uv.x*R.x/R.y, uv.y);

    vec3 col = c_red;

    float musicT = u_t/BEAT_DUR;

    float segStart = musicT/7.0/4.0 - 15.0 - 5.25/7.0;
    
    float timeKnock;
    for(float i=1.0; i<6.0; i+=1.25){ timeKnock += expease(max(0.0,fract(musicT/7.0)*7.0-i),6.0); }
    float deltaKnock;
    for(float i=1.0; i<6.0; i+=1.25){ deltaKnock += step(i,fract(musicT/7.0)*7.0); }
    deltaKnock -= timeKnock;

    vec2 p = UV*mix(2.0, 0.15, pow(clamp(segStart*5.0,0.0,1.0),9.0));
    p.x -= 1.5;
    for(int i=0; i<5; i++) {
        if (float(i)-0.5>timeKnock) break;
        p *= rot(sin(float(i)*9.9)*float(i)*0.075);
        float easeApply = step(timeKnock, float(i));
        vec3 arrCol = i%2==0?c_beige:c_red;
        col = mix(arrCol, col, step(0.0, arrow(p+vec2(float(i)*1.25+deltaKnock*easeApply,0))));
    }

    C = vec4(col, 1.0);
}
