const float PI=acos(-1.);
const float TAU=PI*2.;
const float BPM=174.0;
const float BEAT_DUR=60./BPM;

const vec3 c_beige = vec3(1.0, 0.7592993393877305, 0.7154651755316974);
const vec3 c_pink = vec3(1.0, 0.4151477194802544, 0.7226722040618297);
const vec3 c_red = vec3(0.7011692487023333, 0.032875802667638204, 0.0);
const vec3 c_yellow = vec3(0.8993844042362846, 0.5174010256584681, 0.0);
const vec3 c_blue = vec3(0.0, 0.03847262083763058, 0.08021905144146681);

float ascii(sampler2D tex, vec2 p, int ch) {
    vec2 off = vec2(float(ch%6), float(6-ch/6));
    return texture(tex, (p + vec2(0.5,-0.5) + off)/6.0).r*step(abs(p.x), 0.5)*step(abs(p.y), 0.5);
}

float sinease(float n) {
    return sin(-n*PI-PI/2.0)*0.5+0.5;
}

float expease(float n, float deg) {
    return n>0.0?1.0-exp(-n*deg):0.0;
}

//https://www.shadertoy.com/view/XlXcW4
const uint bruhSeed = 1103773245U;
vec3 hash( uvec3 x )
{
    x = ((x>>8U)^x.yzx)*bruhSeed;
    x = ((x>>8U)^x.yzx)*bruhSeed;
    x = ((x>>8U)^x.yzx)*bruhSeed;

    return vec3(x)*(1.0/float(0xffffffffU));
}
vec3 noise(vec3 st)
{
    uvec3[8] ids;
    ids[0]=uvec3(round(abs(st)+vec3(-.5,-.5,-.5))); //bl front
    ids[1]=uvec3(round(abs(st)+vec3( .5,-.5,-.5))); //br front
    ids[2]=uvec3(round(abs(st)+vec3(-.5, .5,-.5))); //tl front
    ids[3]=uvec3(round(abs(st)+vec3( .5, .5,-.5))); //tr front
    ids[4]=uvec3(round(abs(st)+vec3(-.5,-.5, .5))); //bl back
    ids[5]=uvec3(round(abs(st)+vec3( .5,-.5, .5))); //br back
    ids[6]=uvec3(round(abs(st)+vec3(-.5, .5, .5))); //tl back
    ids[7]=uvec3(round(abs(st)+vec3( .5, .5, .5))); //tr back

    vec3 st_f = fract(abs(st));
    st_f = smoothstep(0.,1.,st_f);

    return mix(
    mix(
    mix(hash(ids[0]),hash(ids[1]),st_f.x), //bottom front
    mix(hash(ids[2]),hash(ids[3]),st_f.x), //top    front
    st_f.y
    ), //front
    mix(
    mix(hash(ids[4]),hash(ids[5]),st_f.x), //bottom back
    mix(hash(ids[6]),hash(ids[7]),st_f.x), //top    back
    st_f.y
    ), //back
    st_f.z
    )*2.-1.;
}



#define _A 0
#define _B 1
#define _C 2
#define _D 3
#define _E 4
#define _F 5
#define _G 6
#define _H 7
#define _I 8
#define _J 9
#define _K 10
#define _L 11
#define _M 12
#define _N 13
#define _O 14
#define _P 15
#define _Q 16
#define _R 17
#define _S 18
#define _T 19
#define _U 20
#define _V 21
#define _W 22
#define _X 23
#define _Y 24
#define _Z 25
#define _0 26
#define _1 27
#define _2 28
#define _3 29
#define _4 30
#define _5 31
#define _6 32
#define _7 33
#define _8 34
#define _9 35