﻿#pragma once
// #include "gl/Buffer.h"
// #include "gl/Shader.h"
// #include "gl/ShaderProgram.h"


class ShaderProgram;
class Buffer;
class Texture;

struct RectDescr {
	std::optional<vec4> col = std::nullopt;
	vec2 pos = vec2(0);
	vec2 sz = vec2(0);
	vec2 from = vec2(0);
	vec2 to = vec2(0);
	std::optional<Texture*> tex = std::nullopt;
};

struct Drawer2DVert {
	vec2 pos;
	vec2 uv = vec2(1);
	vec4 color = vec4(1,1,1,1);
	int tex_idx = 0;
	bool is_tex_coloured = false;
};

class Drawer2D {
	Buffer* buff;
	float* buff_ptr;
	float* prev_buff_ptr;

	ShaderProgram* shader_prog;

	int vert_cnt = 0;
	int vert_cnt_accum = 0;

public:
	Drawer2D();

	void push_vert(Drawer2DVert v);
	void draw_rect(RectDescr desc);

	void flush_quads();
	void flush_points();

	void reset();
};
