/*

 FONT_TILES.C

 Tile Source File.

 Info:
  Form                 : All tiles as one unit.
  Format               : Gameboy 4 color.
  Compression          : GB-Compress.
  Counter              : None.
  Tile size            : 8 x 8
  Tiles                : 0 to 93

  Palette colors       : None.
  SGB Palette          : None.
  CGB Palette          : None.

  Convert to metatiles : No.

 This file was generated by GBTD v2.2

*/
#include <gb/gb.h>
#include <gb/gbdecompress.h>
#include <string.h>
#include "../utils/utils.h"
#pragma bank 255

BANKREF(font_tiles)

const char* dialogue_strings[][7] = {
  { // TEXT_STRING_TAKEOVER_WORLD
    "My Mom would      ",
    "always give me all",
    "sorts of good     ",
    "advice.           ",
  }, {
    "\"Let\'s take over  ",
    "the world!\", \"You ",
    "must murder your  ",
    "husband!\", that   ",
    "sort of thing.    ",
  }, {
    "Now that I think  ",
    "about it, most of ",
    "this advice was   ",
    "quite bad.        ",
  }, {
    "Good thing        ",
    "following it      ",
    "didn\'t have any   ",
    "dire consequences!",
  }, {
    "However, she did  ",
    "also tell me \"You ",
    "are what you eat,\"",
    "which not gonna   ",
    "lie is pretty     ",
    "valid.            ",
  }, {
    "Especially since  ",
    "yesterday I ate a ",
    "whole lot of      ",
    "swordfish steak,  ",
  }, {
    "and now I can\'t   ",
    "change out of fish",
    "form.             ",
  }, {
    // TEXT_SWORDFISH_STEAK_1
    "Got a swordfish   ",
    "steak!            "
  }, {
    // TEXT_SWORDFISH_STEAK_2
    "Got ANOTHER       ",
    "swordfish steak!  "
  }, {
    // TEXT_SWORDFISH_STEAK_3
    "WHY IS IT ALL     ",
    "SWORDFISH STEAK?! "
  }, {
    // TEXT_STRING_WARP_SUCCESS
    "Oh geez, this     ",
    "doesn\'t look      ",
    "right.            "
  }, {
    "Stupid gate.      ",
    "What\'s wrong with ",
    "it?               "
  }, {
    "Well, when all    ",
    "else fails, read  ",
    "the manual.       "
  }, {
    "Let\'s see.       "
  }, {
    "\"Under no        ",
    "circumstances are ",
    "you to open this  ",
    "warp gate...      "
  }, {
    "using precisely   ",
    "three steak as a  ",
    "power source.\"    "
  }, {
    "Huh.              "
  }, {
    "Well, joke\'s on   ",
    "them, cuz I got my",
    "legs back.        "
  }, {
    // TEXT_STRING_SEEN_LI
    "I\'m seeing him    ",
    "everywhere.       "
  }, {
    // TEXT_STRING_CLUB_SIGN
    "The sign says:    "
  }, {
    "\"This is the cool ",
    "kids club. Must be",
    "this cool to      ",
    "enter.\"           "
  }, {
    "And there\'s a     ",
    "photo of a really ",
    "rad-looking dude. "
  }, {
    "I don\'t think I   ",
    "can compete with  ",
    "that.             "
  }, {
    // TEXT_STRING_CLUB_SIGN_2
    "The sign says:    "
  }, {
    "\"This is the cool ",
    "kids club. Must be",
    "this cool to      ",
    "enter.\"           "
  }, {
    "And there\'s a     ",
    "photo of a really ",
    "rad-looking dude. "
  }, {
    "Well I\'m as rad as",
    "they come.        "
  }, {
    // TEXT_STRING_SUNGLASSES_GET
    "Oh sweet! A       ",
    "totally rad pair  ",
    "of shades.        "
  }, {
    "Only a total      ",
    "canvas would think",
    "these aren\'t cool."
  }, {
    // TEXT_STRING_CHECK_MAP
    "Rad dudes like me ",
    "know that we can  ",
    "check the map by  ",
    "holding START.    "
  }
};

const uint8_t dialogue_heights[] = {
  4, 5, 4, 4, 6, 4, 3, 2, 2, 2, 3, 3, 3, 1, 4, 3, 1, 3, 2, 1, 4, 3, 3, 1, 4, 3, 2, 3, 3, 4
};

/* Start of tile array. */
const unsigned char font_tiles[] =
{
  0x0F,0x00,0x44,0x18,0x00,0x83,0xF4,0xFF,
  0xC4,0x00,0x00,0x66,0x00,0x66,0x8C,0xDD,
  0xFF,0x83,0xF0,0xFF,0xC0,0xFF,0x83,0xFC,
  0xFF,0x86,0xE6,0xFF,0xCA,0x18,0x00,0x3E,
  0x00,0x60,0x00,0x3C,0x00,0x06,0x00,0x7C,
  0x84,0xCC,0xFF,0xE0,0x62,0x00,0x66,0x00,
  0x0C,0x00,0x18,0x00,0x30,0x00,0x66,0x00,
  0x46,0x00,0x00,0x00,0x3C,0x00,0x66,0x00,
  0x3C,0x00,0x38,0x00,0x67,0x00,0x66,0x00,
  0x3F,0x00,0x00,0x00,0x06,0x84,0xE2,0xFF,
  0x89,0x8A,0xFF,0x85,0xD4,0xFF,0xC8,0x30,
  0x00,0x30,0x00,0x18,0x00,0x0C,0x00,0x00,
  0x86,0xF8,0xFF,0xC0,0x0C,0x86,0xBC,0xFF,
  0x85,0x8E,0xFF,0xC2,0x3C,0x00,0xFF,0x84,
  0xB8,0xFF,0x89,0x5E,0xFF,0xC0,0x7E,0x86,
  0x5E,0xFF,0x8F,0x46,0xFF,0x85,0xCE,0xFF,
  0xC2,0x00,0x00,0x7E,0x12,0x00,0x87,0xCE,
  0xFF,0xC0,0x03,0x86,0x7C,0xFF,0xD2,0x30,
  0x00,0x60,0x00,0x00,0x00,0x78,0x00,0xCC,
  0x00,0xDC,0x00,0xEC,0x00,0xCC,0x00,0xCC,
  0x00,0x78,0x84,0x80,0xFF,0xC2,0x30,0x00,
  0x70,0x86,0x6E,0xFF,0xC0,0xFC,0x86,0xE0,
  0xFF,0x83,0x30,0xFF,0xC2,0x60,0x00,0xC0,
  0x8A,0xF0,0xFF,0xC2,0x38,0x00,0x0C,0x86,
  0xD0,0xFF,0xC8,0x0C,0x00,0x1C,0x00,0x3C,
  0x00,0xCC,0x00,0xFE,0x84,0x4A,0xFF,0xC6,
  0x00,0x00,0xFC,0x00,0xC0,0x00,0xF8,0x84,
  0x3E,0xFF,0x85,0xB0,0xFF,0x83,0xA0,0xFF,
  0x83,0xEE,0xFF,0x87,0xA0,0xFF,0xC2,0xFC,
  0x00,0xCC,0x88,0x0E,0xFF,0x83,0x20,0xFF,
  0x83,0x80,0xFF,0x83,0x86,0xFF,0x87,0x80,
  0xFF,0x85,0xF0,0xFF,0xC0,0x7C,0x88,0xA0,
  0xFF,0x85,0xDA,0xFF,0x83,0x5A,0xFE,0x85,
  0xD0,0xFF,0x8D,0xF0,0xFF,0xC2,0x60,0x00,
  0x1C,0x84,0x38,0xFF,0xC6,0xC0,0x00,0x60,
  0x00,0x30,0x00,0x1C,0x86,0x33,0xFE,0x83,
  0x48,0xFF,0x83,0x44,0xFF,0x83,0x24,0xFE,
  0xC0,0xE0,0x86,0xA6,0xFE,0x83,0x6E,0xFE,
  0xC0,0xE0,0x8A,0x30,0xFF,0x85,0xB4,0xFF,
  0x87,0x00,0xFF,0xC4,0xDC,0x00,0xC0,0x00,
  0xC4,0x86,0x00,0xFF,0x83,0xEE,0xFE,0x83,
  0x5A,0xFF,0x83,0xEE,0xFE,0xC0,0x00,0x86,
  0x46,0xFF,0x85,0x40,0xFF,0xC0,0xF8,0x88,
  0x30,0xFF,0xC2,0xC0,0x00,0xC0,0x86,0xD0,
  0xFE,0xC2,0xF0,0x00,0xD8,0x86,0xD4,0xFF,
  0xC2,0xD8,0x00,0xF0,0x86,0x00,0xFF,0xC2,
  0xC0,0x00,0xF0,0x84,0xDC,0xFF,0x85,0x78,
  0xFF,0x89,0xF0,0xFF,0xC0,0xC0,0x88,0xF0,
  0xFE,0xC0,0xDC,0x88,0x90,0xFE,0x85,0x98,
  0xFF,0x89,0x90,0xFF,0xC0,0x78,0x44,0x00,
  0x30,0x84,0x70,0xFE,0xC0,0x3C,0x88,0x6E,
  0xFD,0xC2,0xD8,0x00,0x70,0x84,0xD0,0xFF,
  0x83,0x98,0xFF,0xC0,0xE0,0x86,0x88,0xFF,
  0xC0,0x00,0x45,0x00,0xC0,0x84,0x50,0xFE,
  0xC6,0xC6,0x00,0xEE,0x00,0xFE,0x00,0xD6,
  0x42,0x00,0xC6,0x84,0xA0,0xFF,0xC4,0xEC,
  0x00,0xFC,0x00,0xFC,0x86,0x8E,0xFF,0x87,
  0x90,0xFE,0x85,0x22,0xFF,0x83,0x10,0xFE,
  0x87,0x20,0xFF,0x8B,0x60,0xFF,0x87,0xE2,
  0xFF,0x83,0xB0,0xFE,0x87,0x00,0xFF,0x87,
  0x90,0xFF,0x85,0x30,0xFE,0xC0,0x78,0x88,
  0x00,0xFE,0xC0,0xFC,0x45,0x00,0x30,0x88,
  0x30,0xFF,0x89,0xA0,0xFF,0x8B,0x92,0xFF,
  0x83,0x30,0xFD,0x85,0x68,0xFF,0xC4,0xD6,
  0x00,0xFE,0x00,0xEE,0x86,0x60,0xFF,0x85,
  0xE6,0xFF,0x85,0xF8,0xFD,0x87,0xF0,0xFE,
  0x87,0xFA,0xFE,0x83,0xB0,0xFD,0x87,0x54,
  0xFD,0x87,0x80,0xFD,0x44,0x60,0x00,0x83,
  0x50,0xFD,0x83,0xFE,0xFE,0x83,0x04,0xFE,
  0x83,0xC2,0xFC,0xC0,0x06,0x84,0x30,0xFD,
  0x89,0x3E,0xFC,0x83,0x30,0xFD,0xC2,0x18,
  0x00,0x3C,0x86,0xD2,0xFC,0x91,0xCE,0xFC,
  0xC0,0xFF,0x88,0x90,0xFC,0x8D,0xFA,0xFB,
  0x83,0x22,0xFF,0xC0,0x7C,0x84,0x7A,0xFD,
  0x85,0xA0,0xFF,0x87,0x40,0xFD,0x83,0x00,
  0xFE,0x85,0xE0,0xFF,0x85,0xFE,0xFD,0x85,
  0x80,0xFF,0x83,0x52,0xFC,0x83,0xD2,0xFF,
  0x87,0xD0,0xFF,0x85,0xAC,0xFC,0x83,0xF8,
  0xFC,0x85,0x60,0xFF,0x83,0x5E,0xFD,0xC0,
  0x7C,0x88,0x10,0xFD,0x83,0x90,0xFB,0x87,
  0xD2,0xFF,0xC0,0x0C,0x86,0x88,0xFE,0x85,
  0xE2,0xFC,0x85,0x90,0xFD,0x83,0x0C,0xFC,
  0x87,0x80,0xFC,0x85,0x20,0xFF,0x85,0x76,
  0xFB,0x85,0x68,0xFB,0xC0,0x70,0x86,0x84,
  0xFD,0x83,0x94,0xFD,0x85,0x00,0xFE,0x87,
  0x54,0xFC,0x89,0xD0,0xFF,0x83,0xAC,0xFD,
  0xC0,0xFE,0x86,0xFC,0xFD,0x85,0x22,0xFB,
  0x8B,0xA0,0xFF,0x87,0x60,0xFF,0x87,0x10,
  0xFC,0x89,0xE0,0xFF,0x85,0xFC,0xFD,0x8D,
  0x60,0xFF,0x85,0xE6,0xFE,0x83,0x42,0xFC,
  0x87,0x40,0xFD,0x85,0x40,0xFF,0x85,0xFE,
  0xFD,0x85,0xF0,0xFE,0x83,0xD8,0xFB,0x85,
  0x3E,0xFB,0x87,0x80,0xFC,0x87,0x9E,0xFD,
  0x87,0xF0,0xFE,0x8B,0x00,0xFE,0x83,0x90,
  0xFA,0x85,0x00,0xFE,0xC2,0x7C,0x00,0x6C,
  0x88,0x50,0xFF,0x87,0xFE,0xFD,0x8B,0xC0,
  0xFF,0x83,0xB0,0xFA,0x83,0xAE,0xFC,0x83,
  0xAC,0xFB,0x85,0x52,0xFB,0x86,0x2C,0xFC,
  0xC6,0x7F,0x00,0x7F,0x00,0x60,0x00,0x6F,
  0x42,0x00,0x68,0x84,0x39,0xFE,0x83,0x37,
  0xFE,0x83,0x33,0xFE,0x83,0x33,0xFA,0x47,
  0x68,0x00,0x00
};

const uint8_t top_bot_textbox_tiles[] = {
  0x5B, 0x5C, 0x5C, 0x5C, 0x5C, 0x5C, 0x5C, 0x5C, 0x5C, 0x5C, 0x5C, 0x5C, 0x5C, 0x5C, 0x5C, 0x5C, 0x5C, 0x5C, 0x5C, 0x5B
};

const uint8_t top_textbox_attribs[] = {
  0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0xAE
};

const uint8_t bottom_textbox_attribs[] = {
  0xCE, 0xCE, 0xCE, 0xCE, 0xCE, 0xCE, 0xCE, 0xCE, 0xCE, 0xCE, 0xCE, 0xCE, 0xCE, 0xCE, 0xCE, 0xCE, 0xCE, 0xCE, 0xCE, 0xEE
};

void set_font_tiles(uint8_t start_idx) BANKED {
  gb_decompress_bkg_data(start_idx, font_tiles);
}

uint8_t tile;

int8_t render_next_string_char_id(uint8_t str_id, int8_t character, uint8_t vram_start_idx) BANKED {
  if (character == -1) {
    return -1;
  }

  uint8_t cur_row = (uint8_t)character / 18;
  uint8_t cur_col = (uint8_t)character % 18;

  // Skip to next row if the rest of the line is only spaces
  uint8_t str_len = strlen(dialogue_strings[str_id][cur_row]);
  uint8_t ii;
  for (ii = cur_col; ii < str_len; ii++) {
    if (dialogue_strings[str_id][cur_row][ii] != ' ') {
      break;
    }
  }
  if (ii == str_len) {
    cur_row++;
    cur_col = 0;
  }

  if (cur_row >= dialogue_heights[str_id]) {
    return -1;
  }

  tile = dialogue_strings[str_id][cur_row][cur_col] + vram_start_idx - 0x20;
  VBK_REG = VBK_TILES;
  set_win_tiles(cur_col+1, cur_row+1, 1, 1, &tile);
  VBK_REG = VBK_ATTRIBUTES;
  tile = 0x8E;
  set_win_tiles(cur_col+1, cur_row+1, 1, 1, &tile);

  VBK_REG = VBK_TILES;
  return character + 1;
}

void render_textbox_id(uint8_t str_id, uint8_t vram_start_idx) BANKED {
  uint8_t cur_height = dialogue_heights[str_id];

  move_win(WIN_X_OFFSET, (SCREEN_HEIGHT_TILES - (2 + cur_height)) * 8);

  // Draw top border
  VBK_REG = VBK_TILES;
  set_win_tiles(0, 0, 20, 1, top_bot_textbox_tiles);
  VBK_REG = VBK_ATTRIBUTES;
  set_win_tiles(0, 0, 20, 1, top_textbox_attribs);

  // Draw bottom border
  VBK_REG = VBK_TILES;
  set_win_tiles(0, cur_height+1, 20, 1, top_bot_textbox_tiles);
  VBK_REG = VBK_ATTRIBUTES;
  set_win_tiles(0, cur_height+1, 20, 1, bottom_textbox_attribs);

  // Draw left side
  for (i = 1; i < cur_height + 1; i++) {
    tile = 93;
    VBK_REG = VBK_TILES;
    set_win_tiles(0, i, 1, 1, &tile);
    VBK_REG = VBK_ATTRIBUTES;
    tile = 0x8E;
    set_win_tiles(0, i, 1, 1, &tile);
  }

  // Draw right side
  for (i = 1; i < cur_height + 1; i++) {
    tile = 93;
    VBK_REG = VBK_TILES;
    set_win_tiles(19, i, 1, 1, &tile);
    VBK_REG = VBK_ATTRIBUTES;
    tile = 0xAE;
    set_win_tiles(19, i, 1, 1, &tile);
  }

  // Fill in middle
  for (i = 1; i < cur_height + 1; i++) {
    for (j = 1; j < 19; j++) {
      tile = vram_start_idx;
      VBK_REG = VBK_TILES;
      set_win_tiles(j, i, 1, 1, &tile);
      VBK_REG = VBK_ATTRIBUTES;
      tile = 0x8E;
      set_win_tiles(j, i, 1, 1, &tile);
    }
  }

  VBK_REG = VBK_TILES;
}

/* End of FONT_TILES.C */
