function randomGenerator(seed) {
  // xorshift-based prng
  let s = seed.reduce((acc, val) => ((acc * 31) + val) >>> 0, 1);
  return function() {
    s ^= (s << 13);
    s ^= (s >>> 17);
    s ^= (s << 5);
    return (s >>> 0) / 4294967296;
  };
}

const rand = randomGenerator(seed);

// circle sizes
const sizes = [3, 10, 20, 27, 36, 42];

// concentric circles
for (let i = 5; i >= 0; i--) {
  ctx.beginPath();
  ctx.fillStyle = (i % 2 === 0) ? "#fff" : "#000";
  ctx.arc(50, 50, sizes[i], 0, Math.PI*2);
  ctx.fill();
}

function addstuff(n) {
  var angle = 0;
  var last = false;
  while (!last) {
    const length = 0.1 + rand();
    if (angle + length >= Math.PI * 2. - 0.1) {
      break;
    }

    ctx.beginPath();
    ctx.arc(50, 50, sizes[n], angle, angle+length);
    ctx.lineWidth = 5.;
    ctx.stroke();

    angle += length;
    angle += 0.15 + rand() * .4;
  }
}

for (let i = 2; i < 6; i++) {
  addstuff(i);
}

// to make the orientation clear
ctx.beginPath();
let angle = Math.PI / 2 + .5;
ctx.arc(50, 50, 12, angle -0.5, angle + 0.5);
ctx.stroke();
