;
; Textured endless corridor
;
; Interlaced; 64 half-heights, byte columns
; 8x8 texture, tiled
;
tex_addr = 40000 - (32. * 32.)
.link 1000
start:	emt 14
; Unpack_tex start
; Unpacks the wall texture to byte array
; Size is 8x8x2bpp (16 bytes)
	mov #texdata, r1
	mov #tex_addr, r5
	mov #10, @sp ; texture size
	mov @sp, r2
40$:	mov (r1)+, r0
	mov @sp, r4
41$:	clr r3
	rol r0
	rol r3
	rol r0
	rol r3
	movb colors(r3), (r5)+
	sob r4, 41$
	sob r2, 40$
; unpack_tex end
	mov #32.,r3 ; Magic number 32. -- width of screen in words, also reused as texture height
	; fill the screen with background
	; TODO top half only (reuse constant from scaler generator?)
	; bottom only?
	mov #40100, r1
	mov r3, r2
1$:	mov #10421, (r1)+
	sob r2, 1$
2$:	mov 177600(r1), (r1)+
	tst r1
	bpl 2$
	;
	neg @sp ; HACK: texture height, inverted and the mask for it
	;
; start of build_drawers
; TODO run in reverse -- could save a few bytes
	mov #codepool, r5 ; running pointer of the generated code
	;mov #2, r4 ; count (we skip height 0), aka w;
	tst (r4)+ ; r4 is zero now, so it is the short way to load a constant 2
10$:	mov r4, r0
	mov r5, drawers_mid2(r0)
	neg r0
	mov r5, drawers_mid(r0)
	; setup the loop
	clr r1 ; ofs = 0
	mov r4, r2 ; wacc = w / 2
	asr r2
	; build the code using Bresenham's algo for slope
	; we map texture of size th to the span of w, the step will be the t/w (approximated)
	;     for i in range(w):
	mov r4, r0
20$:	; first. emit the code for the current offset
	mov #116112, (r5)+ ; movb n(r1), (r2)
	mov r1, (r5)+
	sub r3, r2 ; wacc -= th
	bpl 25$
	; while wacc < 0:
23$:	inc r1 ; ofs += 1
	bic @sp, r1 ; HACK for texture height of 8, repeated (32 fits without it)
	add r4, r2
	bmi 23$ ; wacc += w
25$:	mov #60502, (r5)+ ; add r5, r2 ; r5 -- line stride
	sob r0, 20$
	mov #207, (r5)+ ; ret
	tst (r4)+
	cmp #64., r4
	bhis 10$
; end of build_drawers
	; create table of texture column offsets
	clr r0
	mov #7, r5
	mov #texofs, r1
	mov r3, r2
5$:	mov r0, (r1)+
	;sub @sp, r0
	inc r5
	add r5, r0
	;
	sob r2, 5$
	mov r1, r4
	mov r3, r2
6$:	mov -(r4), (r1)+
	sob r2, 6$
	; create table of start offsets (and scalers?)
	mov #400, r5
	mov #57540, r0
	mov #coltab_mid, r1
	mov r0, r4
	mov r1, r2
60$:	mov r0, (r1)+
	sub r5, r0
	inc r0
	;
	dec r4
	mov r4, -(r2)
	sub r5, r4
	sob r3, 60$
	asr r5
	; rendering pass
	; drawers use those parameters:
	; r1 -- texture column pointer
	; r2 -- screen pointer (clobbered)
	; r5 -- screen row stride
77$:	mov #64. * 2, r4
50$:	mov texofs_b(r4), r1
	add (pc)+, r1
59$:	.word 0
	bic #177707, r1 ; keep only x bits of texture coordinate
	add #tex_addr, r1
	mov coltab_b(r4), r2
	mov drawers_b(r4), -(sp)
	call @0(sp)
	call @(sp)+
	dec r4
	sob r4, 50$
	sub @sp, @#scroll ; Scroll speed, use a multiple of 8!
	br 77$
scroll = 59$
colors:
	.byte 100, 377, 252, 146
texdata:
	.word 177777, 177777, 100142, 100302, 101402, 103002, 177777, 177777 
drawers: ; 64.x2 words
drawers_mid = drawers + 32. * 2
drawers_mid2 = drawers_mid -2
coltab = drawers + 64. * 2
coltab_mid = coltab + 32. * 2
texofs = coltab + 64. * 2
codepool = texofs + 64. * 2
; for biased loop counter
texofs_b = texofs - 2
coltab_b = coltab - 2
drawers_b = drawers - 2
.end
