import ddf.minim.*;

AudioPlayer player;
Minim minim;

PShape mainChar, brain, legl, legr;

float mainChar_tx, mainChar_ty, mainChar_tz;
float brain_tx, brain_ty, brain_tz;
float legl_tx, legl_ty, legl_tz;
float legr_tx, legr_ty, legr_tz;

float rx, ry, rz;

float sx = 5, sy = 5, sz = 5;

int xdirection = 1;
int ydirection = 1;
float xspeed = 30;
float yspeed = 30;

int startTime;
int playTime;

int Y_AXIS = 1;
int X_AXIS = 2;
color b1, b2;

public void setup() {
  size(1280, 720, P3D);
  
  mainChar_tx = width / 4;
  brain_tx = width / 4;
  legl_tx = width / 4;
  legr_tx = width / 4;
  
  frameRate(30);
  
  mainChar = loadShape("fgnxf8hp479x.obj");
  brain = loadShape("ew7y9wcr6o40.obj");
  legl = loadShape("n081b908n47l.obj");
  legr = loadShape("ejt5z6lme6tr.obj");
  
  startTime = millis();
  
  minim = new Minim(this);
  player = minim.loadFile("bgm.mp3", 2048);
  player.play();
  
  b1 = color(0, 100, 250);
  b2 = color(200);
}

public void draw() {
  playTime = (millis() - startTime) / 1000;
  background(0);
  setGradient(0, 0, width/2, height, b1, b2, X_AXIS);
  setGradient(width/2, 0, width/2, height, b2, b1, X_AXIS);
  
  ambientLight(102, 204, 255);
  // Light the bottom of the sphere
  directionalLight(51, 102, 126, 0, -1, 0);
  
  // Orange light on the upper-right of the sphere
  spotLight(204, 153, 0, 580, 160, 600, 0, 0, -1, PI/2, 600); 
  
  // Moving spotlight that follows the mouse
  spotLight(102, 153, 204, 580, playTime * 100, 600, 0, 0, -1, PI/2, 600);
  
  pushMatrix();
  translate(mainChar_tx, mainChar_ty, mainChar_tz + 40);
  scale(sx, sy, sz);
  rotateZ(PI);
  rotateY(ry);
  shape(mainChar);
  popMatrix();
  
  pushMatrix();
  translate(brain_tx, brain_ty, brain_tz + 40);
  scale(sx, sy, sz);
  rotateZ(PI);
  rotateY(ry);
  shape(brain);
  popMatrix();
  
  pushMatrix();
  translate(legl_tx, legl_ty, legl_tz + 40);
  scale(sx, sy, sz);
  rotateZ(PI);
  rotateY(ry);
  shape(legl);
  popMatrix();
  
  pushMatrix();
  translate(legr_tx, legr_ty, legr_tz + 40);
  scale(sx, sy, sz);
  rotateZ(PI);
  rotateY(ry);
  shape(legr);
  popMatrix();
  
  if(playTime < 10) {
    ry += 0.2;
    ry = min(18, ry);
    mainChar_ty += 7;
    brain_ty += 7;
    legl_ty += 7;
    legr_ty += 7;
    mainChar_ty = min(260, mainChar_ty);
    brain_ty = min(260, brain_ty);
    legl_ty = min(260, legl_ty);
    legr_ty = min(260, legr_ty);
  }
  else if(playTime < 11) {
    sx += sin(3);
  }
  else if(playTime < 12) {
    sx -= sin(3);
    sx = max(16, sx);
  }
  else if(playTime < 13) {
    sy += sin(3);
  }
  else if(playTime < 14) {
    sy -= sin(3);
    sy = max(16, sy);
  }
  else if(playTime < 15) {
    legl_tx += 0.8;
    legr_tx += 0.8;
    legl_ty += 0.8;
    legr_ty += 0.8;
    legl_tz += 0.8;
    legr_tz += 0.8;
  }
  else if(playTime < 16) {
    mainChar_tx += 6;
    mainChar_ty += 6;
    mainChar_tz += 3;
    brain_tx += 6;
    brain_ty += 6;
    brain_tz += 3;
    legl_tx += 5.2;
    legr_tx += 5.2;
    legl_ty += 5.2;
    legr_ty += 5.2;
    legl_tz += 2.2;
    legr_tz += 2.2;
    sx += 0.1;
    sy += 0.1;
    sz += 0.1;
  }
  else if(playTime < 17) {
    legl_tx += 0.8;
    legr_tx += 0.8;
    legl_ty += 0.8;
    legr_ty += 0.8;
    legl_tz += 0.8;
    legr_tz += 0.8;
  }
  else if(playTime < 18) {
    mainChar_tx += 6;
    mainChar_ty += 6;
    mainChar_tz += 3;
    brain_tx += 6;
    brain_ty += 6;
    brain_tz += 3;
    legl_tx += 5.2;
    legr_tx += 5.2;
    legl_ty += 5.2;
    legr_ty += 5.2;
    legl_tz += 2.2;
    legr_tz += 2.2;
    sx += 0.2;
    sy += 0.2;
    sz += 0.2;
  }
  else if(playTime < 19) {
    brain_ty += 12;
    println(brain_ty);
    brain_ty = min(620, brain_ty);
  }
  else if(playTime < 21) {
    brain_ty -= 6;
    println(brain_ty);
    brain_ty = max(420, brain_ty);
  }
  else if(playTime < 22) {
    brain_ty += 12;
    brain_ty = min(620, brain_ty);
  }
  else if(playTime < 24) {
    brain_ty -= 6;
    brain_ty = max(420, brain_ty);
  }
  else if(playTime < 25) {
    brain_ty += 12;
    brain_ty = min(620, brain_ty);
  }
  else if(playTime < 27) {
    brain_ty -= 6;
    brain_ty = max(420, brain_ty);
  }
  else if(playTime < 32) {
    brain_tx += ( xspeed * xdirection );
    brain_ty += ( yspeed * ydirection );
    if (brain_tx > width - width / 4 - 60 || brain_tx < width * 4 - 60) {
      xdirection *= -1;
    }
    if (brain_ty > height - 30 || brain_ty < 60) {
      ydirection *= -1;
    }
  }
  else if(playTime < 48) {
    brain_tx += ( xspeed * xdirection );
    brain_ty += ( yspeed * ydirection );
    if (brain_tx > width - width / 4 - 60 || brain_tx < 240 - width / 4) {
      xdirection *= -1;
    }
    if (brain_ty > height - 30 || brain_ty < 60) {
      ydirection *= -1;
    }
  }
  else if(playTime < 9999) {
    background(0);
    player.close();
    minim.stop();
    super.stop();
  }
}

void setGradient(int x, int y, float w, float h, color c1, color c2, int axis ) {

  noFill();

  if (axis == Y_AXIS) {  // Top to bottom gradient
    for (int i = y; i <= y+h; i++) {
      float inter = map(i, y, y+h, 0, 1);
      color c = lerpColor(c1, c2, inter);
      stroke(c);
      line(x, i, x+w, i);
    }
  }  
  else if (axis == X_AXIS) {  // Left to right gradient
    for (int i = x; i <= x+w; i++) {
      float inter = map(i, x, x+w, 0, 1);
      color c = lerpColor(c1, c2, inter);
      stroke(c);
      line(i, y, i, y+h);
    }
  }
}
