//----------------------------------------------------------------------------------------------------------------------
// C64 port of Flagquiz by Abaddon (DOS)
//----------------------------------------------------------------------------------------------------------------------
// Code and gfx: Cruzer/CML Sports 2025
// Help: Rex/CML
//----------------------------------------------------------------------------------------------------------------------
// Tab size: 8
// Assembler: KickAssembler
//----------------------------------------------------------------------------------------------------------------------
.import source "cml.cruzer.Commons.asm"
//----------------------------------------------------------------------------------------------------------------------
.encoding "petscii_mixed"
//----------------------------------------------------------------------------------------------------------------------
.var flagCnt =		$fb
.var basic =		$0801
.var codeBlob =		$080d
//----------------------------------------------------------------------------------------------------------------------
:basic(startup)
//----------------------------------------------------------------------------------------------------------------------
// Kernal/Basic addresses

.const CURSOR_X = 		$d3
.const CURSOR_Y = 		$d6
.const ENTERED_STRING = 	$0200
.const TEXT_COLOR =		$0286
.const INPUT =			$a560
.const CARRIAGE_RETURN =	$aad7
.const PRINT =			$ab1e
.const CLR =			$e544

// PETSCII chars

.const END_OF_STRING =	$00
.const WHITE =		$05
.const RETURN =		$0d
.const LOWER_CASE =	$0e
.const REVERSE_ON =	$12
.const RED =		$1c
.const GREEN =		$1e
.const CURSOR_UP =	$91
.const CLEAR =		$93
.const PINK =		$96
.const CHECKMARK =	$ba

// Opcodes

.const NOP_3_BYTES =	$0c
//----------------------------------------------------------------------------------------------------------------------
.struct quizEntry {
	flag,
	solution
}

.var quizEntries = List()

.eval quizEntries.add(quizEntry(toColorBytes("4216"), "nl"))
.eval quizEntries.add(quizEntry(toColorBytes("4027"), "de"))
.eval quizEntries.add(quizEntry(toColorBytes("4e01"), "ee"))
.eval quizEntries.add(quizEntry(toColorBytes("6677"), "ua"))
.eval quizEntries.add(quizEntry(toColorBytes("4212"), "at"))
.eval quizEntries.add(quizEntry(toColorBytes("4215"), "hu"))
.eval quizEntries.add(quizEntry(toColorBytes("1122"), "pl"))
.eval quizEntries.add(quizEntry(toColorBytes("4752"), "lt"))
.eval quizEntries.add(quizEntry(toColorBytes("4213"), "lu"))
.eval quizEntries.add(quizEntry(toColorBytes("4152"), "bg"))
.eval quizEntries.add(quizEntry(toColorBytes("7762"), "co"))
.eval quizEntries.add(quizEntry(toColorBytes("4210"), "ye"))
.eval quizEntries.add(quizEntry(toColorBytes("4267"), "am"))
.eval quizEntries.add(quizEntry(toColorBytes("451e"), "sl"))
.eval quizEntries.add(quizEntry(toColorBytes("2675"), "mu"))
.eval quizEntries.add(quizEntry(toColorBytes("457e"), "ga"))
.eval quizEntries.add(quizEntry(toColorBytes("2211"), "mc"))
.eval quizEntries.add(quizEntry(toColorBytes("2211"), "id"))

.var numFlags = quizEntries.size()

.print "numFlags: " + numFlags
//----------------------------------------------------------------------------------------------------------------------
.pc = codeBlob "codeBlob"
//----------------------------------------------------------------------------------------------------------------------
.pc = * "inputPrompt"
inputPrompt:
	.by LOWER_CASE
	.by WHITE
	.by RETURN
	.text "Guess TLD:"
	.by END_OF_STRING

.pc = * "flagSrc"
flagSrc:
	.by RETURN
	.by REVERSE_ON
	.text "      "
	.by END_OF_STRING
//----------------------------------------------------------------------------------------------------------------------
.pc = * "startup"

startup:
	jsr CLR

	ldx #numFlags * 2 - 0
loop:
	jsr printStripes
	jsr printStripes

	lda #<inputPrompt
	jsr print

	jsr INPUT

	ldx flagCnt
	ldy solutions + 1,x
	sty correctSolution + 1
	lda solutions + 0,x
	sta correctSolution + 0
	cmp ENTERED_STRING + 0
	bne wrong
	cpy ENTERED_STRING + 1
	bne wrong
right:
	ldy score + 1
	iny
	cpy #'9' + 1
	bne !+
	ldy #'1'
	sty score + 0
	dey
!:	sty score + 1

	lda #$0c
	sta CURSOR_X
	lda #<checkmark
	.by NOP_3_BYTES // Idea by Rex
wrong:
	lda #<solutionText
next:
	jsr print

	txa
	bne loop

printScore:
	lda #<scoreText
	bmi print
//----------------------------------------------------------------------------------------------------------------------
printStripes:
	
	dex
	lda colors,x
	stx flagCnt

	jsr printStripe

	lda TEXT_COLOR
	lsr
	lsr
	lsr
	lsr

printStripe:
	sta TEXT_COLOR
	and #$07
	cmp #$04
	beq return

	lda #<flagSrc
	sta $d020
	sta $d021
print:
	ldy #>codeBlob // all strings are on the same page
	jsr PRINT
	ldx flagCnt
return:	rts
//----------------------------------------------------------------------------------------------------------------------
.pc = * "scoreText"
scoreText:
	.by RETURN
	.by WHITE
	.text "Score:"
score:	.text " 0/" + numFlags
	.by END_OF_STRING

.pc = * "solutionText"
solutionText:
	.by PINK
correctSolution:
	.text "  "
	.by RETURN
	.by END_OF_STRING

.pc = * "checkmark"
checkmark:
	.by GREEN
	.by CURSOR_UP
	.text " "
	.by CHECKMARK
	.by RETURN
	.by END_OF_STRING
//----------------------------------------------------------------------------------------------------------------------
.pc = * "colors"
colors:
	.for (var i=0; i<numFlags; i++) {
		.var f = numFlags - 1 - i
		.var flag = quizEntries.get(f).flag
		.by (flag.get(3) << 4) | flag.get(2)
		.by (flag.get(1) << 4) | flag.get(0)
	}
//----------------------------------------------------------------------------------------------------------------------
.pc = * "solutions"
solutions:
	.for (var i=0; i<numFlags; i++) {
		.var f = numFlags - 1 - i
		.text quizEntries.get(f).solution
	}
//----------------------------------------------------------------------------------------------------------------------
