# Installing the Demo
The demo has been tested and optimized for the sysmoISIM-SJA5-S17 card (https://shop.sysmocom.de/SIM/). Smartcard readers may also affect the demo speed, as many readers are serial-based and can be relatively slow. The ones we used in development and for the final recording is the Gemalto ID Bridge CT30, and HID Omnikey 3121. The reader used with the GFX card is the most important, and we recommend the CT30 for that as it is the fastest reader we tested.

1. Install Zig version 0.13.0 (https://ziglang.org/download/ or using https://github.com/marler8997/zigup).
2. Install `pcscd` (https://pcsclite.apdu.fr/ or using `apt-get install pcscd` on debian/ubuntu)
3. Install `libgles-dev`, `libxcursor-dev`, `libxrandr-dev`, `libxinerama-dev`, and `libxi-dev` (`apt-get install libgles-dev libxcursor-dev libxrandr-dev libxi-dev` on debian/ubuntu). These are dependencies for raylib, which is used in the host application that presents the video and audio coming from SIM cards.
4. Change directory to `/tool` and run: `./download.sh`. This will download `asconv`, `pysim`, and `jcc` tools needed in the next steps. Next run: `./extract.sh` to extract the downloaded archives.
5. Change directory to `/tool/asconv` and build the `asconv` tool by running: `zig build -Doptimize=ReleaseSafe`. This tool converts our multimedia files into sourcecode files that are directly imported into the demo code. Add the `asconv` binary to the path.
6. Change directory to `/tool/pysim` and build the `icc/pysim:2.1.0` docker image by running: `./build.sh`. This docker image simply packages pySIM (https://github.com/osmocom/pysim).
7. Change directory to `/tool/jcc` and build the `icc/jcc:1.3.0` docker image by running: `./build.sh`. This docker image creates a self-contained compiler for Javacard applets. We use this to compile our applets and produce CAP files that can be installed on the SIM cards.
8. Install `sox` (https://sourceforge.net/projects/sox/ or using `apt-get install sox` on debian/ubuntu). We use this to do minor edits on the source audio files: trimming and converting stereo to mono.
9. Install `aseprite` (https://github.com/aseprite/aseprite). Add the `aseprite` binary to the path.
10. Change directory to `/install` and generate pySIM scripts using the supplied script generator by running: `./script__generator.sh`. It will ask for keys of your GFX and MSX cards. Make sure that these keys are valid because using scripts with invalid keys may lead to bricking of your cards.
11. Change directory to `/asset` and run the asset build script: `./convert.sh`. This will export source asset files into GIFs (`.gif`) and PCM (`.u8`) files at `/asset/export` and sourcecode files (`.java`) at `/asset/out`.
12. Change directory to `/gfx/cardreal` and run the build script for the GFX applet: `./build.sh`. This will produce a `GosiaGfx.cap` file at `/gfx/cardreal/dist`.
13. Change directory to `/msx/cardreal` and run the build script for the MSX applet: `./build.sh`. This will produce a `GosiaMsx.cap` file at `/msx/cardreal/dist`.
14. Obtain the USB path of your card reader(s) by running: `lsusb`. The output will look like: `Bus <usb_bus> Device <usb_dev>: ID <vid>:<pid> <reader_name>`. Remember the `usb_bus` and `usb_dev` values for your card readers, these will be needed in the next steps.
15. Plug your cards into the card readers. Remember which card goes into which reader, we assume that card reader #0 will contain the GFX card, and card reader #1 will contain the MSX card.
16. Change directory to `/instal` and install the GFX CAP file by running: `../tool/pysim/run.sh <usb_bus_0>/<usb_dev_0> ../gfx/cardreal/dist ./script install__gfx.pysim`. Replace `<usb_bus_0>` and `<usb_dev_0>` with the `usb_bus` and `usb_dev` (respectively) discovered using `lsusb` for the card reader #0.
17. Change directory to `/install` and install the MSX CAP file by running: `../tool/pysim/run.sh <usb_bus_1>/<usb_dev_1> ../msx/cardreal/dist ./script install__msx.pysim`. Replace `<usb_bus_1>` and `<usb_dev_1>` with the `usb_bus` and `usb_dev` (respectively) discovered using `lsusb` the card reader #1.
18. Find out the names of your card readers as identified by PC/SC by running: `pcsc_scan -c` (https://pcsc-tools.apdu.fr/ or using `apt install pcsc-tools` on debian/ubuntu). This will list all readers and cards connected to the host, the output will look like: `Reader <n>: <pcsc_reader_name> ...`. Remember the `pcsc_reader_name` for the next steps.
19.  Finally, to run the demo, we need a host application that will receive the video and audio data from your cards. Change directory to `/gfx/host` and run the following `zig build run -- --log-path host.log --card-gfx-0 "<pcsc_reader_name_0>" --card-msx "<pcsc_readear_name_1>" --card-msx-init --sample-1 ../../asset/export/msx__1.u8 --sample-2 ../../asset/export/msx__2.u8 --sample-3 ../../asset/export/msx__3.u8 --sample-4 ../../asset/export/msx__4.u8 --sample-5 ../../asset/export/msx__5.u8` (you will of course need 2 different card readers, each containing one card). **IMPORTANT: The `--card-msx-init` parameter should only be used once after the MSX card is freshly installed. All successive runs of the demo can therefore be run with: `zig build run -- --log-path host.log --card-gfx-0 "<pcsc_reader_name_0>" --card-msx "<pcsc_readear_name_1>"`. This parameter informs the host application to flash the MSX card with the PCM music data.**

## Script Generator
Since your cards will have different KIC/KIK/KID, we provided a script-generating script (`./script__generator.sh`) that creates pySIM scripts that can be used with the supplied docker image (or pySIM directly) to install the applets on your cards.

## STK Install Parameter
The value for the `--install-parameters-stk` argument can be decoded using the information contained in ETSI TS 102 226 V17.0.0 clause 8.2.1.3.2.1. We use the following value to keep things as simple and compatible as possile.
```
0x01 Length of access domain field
0x00 Access domain
0x01 Priority level of the toolki app instance
0x00 Maximum number of timers allowed for this app instance
0x00 Maximum text length for a menu entry
0x00 Maximum number of menu entries allowed for this app instance
0x00 Minimum security level
0x00 Length of TAR value(s) field
```
